/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.cdc.common.pipeline.PipelineOptions;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformOperator;
import org.apache.flink.cdc.runtime.operators.transform.TransformRule;

public class PostTransformOperatorBuilder {
    private final List<TransformRule> transformRules = new ArrayList<TransformRule>();
    private String timezone;
    private final List<Tuple3<String, String, Map<String, String>>> udfFunctions = new ArrayList<Tuple3<String, String, Map<String, String>>>();

    public PostTransformOperatorBuilder addTransform(String tableInclusions, @Nullable String projection, @Nullable String filter, String primaryKey, String partitionKey, String tableOptions, String postTransformConverter, SupportedMetadataColumn[] supportedMetadataColumns) {
        this.transformRules.add(new TransformRule(tableInclusions, projection, filter, primaryKey, partitionKey, tableOptions, postTransformConverter, supportedMetadataColumns));
        return this;
    }

    public PostTransformOperatorBuilder addTransform(String tableInclusions, @Nullable String projection, @Nullable String filter) {
        this.transformRules.add(new TransformRule(tableInclusions, projection, filter, "", "", "", null, new SupportedMetadataColumn[0]));
        return this;
    }

    public PostTransformOperatorBuilder addTimezone(String timezone) {
        this.timezone = ((String)PipelineOptions.PIPELINE_LOCAL_TIME_ZONE.defaultValue()).equals(timezone) ? ZoneId.systemDefault().toString() : timezone;
        return this;
    }

    public PostTransformOperatorBuilder addUdfFunctions(List<Tuple3<String, String, Map<String, String>>> udfFunctions) {
        this.udfFunctions.addAll(udfFunctions);
        return this;
    }

    public PostTransformOperator build() {
        return new PostTransformOperator(this.transformRules, this.timezone, this.udfFunctions);
    }
}

