/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.data.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.StringData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.ZonedTimestampData;
import org.apache.flink.cdc.common.data.binary.BinaryArrayData;
import org.apache.flink.cdc.common.data.binary.BinaryMapData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.data.binary.BinarySegmentUtils;
import org.apache.flink.cdc.common.data.binary.BinaryStringData;
import org.apache.flink.cdc.runtime.serializer.data.ArrayDataSerializer;
import org.apache.flink.cdc.runtime.serializer.data.MapDataSerializer;
import org.apache.flink.cdc.runtime.serializer.data.writer.BinaryWriter;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;

@Internal
abstract class AbstractBinaryWriter
implements BinaryWriter {
    protected MemorySegment segment;
    protected int cursor;
    protected DataOutputViewStreamWrapper outputView;

    AbstractBinaryWriter() {
    }

    protected abstract void setOffsetAndSize(int var1, int var2, long var3);

    protected abstract int getFieldOffset(int var1);

    protected abstract void afterGrow();

    protected abstract void setNullBit(int var1);

    @Override
    public void writeString(int pos, StringData input) {
        BinaryStringData string = (BinaryStringData)input;
        if (string.getSegments() == null) {
            String javaObject = string.toString();
            this.writeBytes(pos, javaObject.getBytes(StandardCharsets.UTF_8));
        } else {
            int len = string.getSizeInBytes();
            if (len <= 7) {
                byte[] bytes = BinarySegmentUtils.allocateReuseBytes((int)len);
                BinarySegmentUtils.copyToBytes((MemorySegment[])string.getSegments(), (int)string.getOffset(), (byte[])bytes, (int)0, (int)len);
                AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
            } else {
                this.writeSegmentsToVarLenPart(pos, string.getSegments(), string.getOffset(), len);
            }
        }
    }

    private void writeBytes(int pos, byte[] bytes) {
        int len = bytes.length;
        if (len <= 7) {
            AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
        } else {
            this.writeBytesToVarLenPart(pos, bytes, len);
        }
    }

    @Override
    public void writeArray(int pos, ArrayData input, ArrayDataSerializer serializer) {
        BinaryArrayData binary = serializer.toBinaryArray(input);
        this.writeSegmentsToVarLenPart(pos, binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
    }

    @Override
    public void writeMap(int pos, MapData input, MapDataSerializer serializer) {
        BinaryMapData binary = serializer.toBinaryMap(input);
        this.writeSegmentsToVarLenPart(pos, binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
    }

    private DataOutputViewStreamWrapper getOutputView() {
        if (this.outputView == null) {
            this.outputView = new DataOutputViewStreamWrapper((OutputStream)new BinaryRowWriterOutputView());
        }
        return this.outputView;
    }

    @Override
    public void writeRecord(int pos, RecordData input, TypeSerializer<RecordData> serializer) {
        BinaryRecordData recordData = (BinaryRecordData)input;
        this.writeSegmentsToVarLenPart(pos, recordData.getSegments(), recordData.getOffset(), recordData.getSizeInBytes());
    }

    @Override
    public void writeBinary(int pos, byte[] bytes) {
        int len = bytes.length;
        if (len <= 7) {
            AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
        } else {
            this.writeBytesToVarLenPart(pos, bytes, len);
        }
    }

    @Override
    public void writeDecimal(int pos, DecimalData value, int precision) {
        assert (value == null || value.precision() <= precision);
        if (DecimalData.isCompact((int)precision)) {
            assert (value != null);
            this.writeLong(pos, value.toUnscaledLong());
        } else {
            this.ensureCapacity(16);
            this.segment.putLong(this.cursor, 0L);
            this.segment.putLong(this.cursor + 8, 0L);
            if (value == null) {
                this.setNullBit(pos);
                this.setOffsetAndSize(pos, this.cursor, 0L);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                this.segment.put(this.cursor, bytes, 0, bytes.length);
                this.setOffsetAndSize(pos, this.cursor, bytes.length);
            }
            this.cursor += 16;
        }
    }

    @Override
    public void writeTimestamp(int pos, TimestampData value, int precision) {
        this.ensureCapacity(8);
        if (value == null) {
            this.setNullBit(pos);
            this.segment.putLong(this.cursor, 0L);
            this.setOffsetAndSize(pos, this.cursor, 0L);
        } else {
            this.segment.putLong(this.cursor, value.getMillisecond());
            this.setOffsetAndSize(pos, this.cursor, value.getNanoOfMillisecond());
        }
        this.cursor += 8;
    }

    @Override
    public void writeLocalZonedTimestamp(int pos, LocalZonedTimestampData value, int precision) {
        this.ensureCapacity(8);
        if (value == null) {
            this.setNullBit(pos);
            this.segment.putLong(this.cursor, 0L);
            this.setOffsetAndSize(pos, this.cursor, 0L);
        } else {
            this.segment.putLong(this.cursor, value.getEpochMillisecond());
            this.setOffsetAndSize(pos, this.cursor, value.getEpochNanoOfMillisecond());
        }
        this.cursor += 8;
    }

    @Override
    public void writeZonedTimestamp(int pos, ZonedTimestampData value, int precision) {
        String timestampString = String.join((CharSequence)"//", Arrays.asList(String.valueOf(value.getMillisecond()), String.valueOf(value.getNanoOfMillisecond()), value.getZoneId()));
        this.writeString(pos, (StringData)new BinaryStringData(timestampString));
    }

    private void zeroBytes(int offset, int size) {
        for (int i = offset; i < offset + size; ++i) {
            this.segment.put(i, (byte)0);
        }
    }

    protected void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            this.segment.putLong(this.cursor + (numBytes >> 3 << 3), 0L);
        }
    }

    protected void ensureCapacity(int neededSize) {
        int length = this.cursor + neededSize;
        if (this.segment.size() < length) {
            this.grow(length);
        }
    }

    private void writeSegmentsToVarLenPart(int pos, MemorySegment[] segments, int offset, int size) {
        int roundedSize = AbstractBinaryWriter.roundNumberOfBytesToNearestWord(size);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(size);
        if (segments.length == 1) {
            segments[0].copyTo(offset, this.segment, this.cursor, size);
        } else {
            this.writeMultiSegmentsToVarLenPart(segments, offset, size);
        }
        this.setOffsetAndSize(pos, this.cursor, size);
        this.cursor += roundedSize;
    }

    private void writeMultiSegmentsToVarLenPart(MemorySegment[] segments, int offset, int size) {
        int needCopy = size;
        int fromOffset = offset;
        int toOffset = this.cursor;
        for (MemorySegment sourceSegment : segments) {
            int remain = sourceSegment.size() - fromOffset;
            if (remain > 0) {
                int copySize = remain > needCopy ? needCopy : remain;
                sourceSegment.copyTo(fromOffset, this.segment, toOffset, copySize);
                needCopy -= copySize;
                toOffset += copySize;
                fromOffset = 0;
                continue;
            }
            fromOffset -= sourceSegment.size();
        }
    }

    private void writeBytesToVarLenPart(int pos, byte[] bytes, int len) {
        int roundedSize = AbstractBinaryWriter.roundNumberOfBytesToNearestWord(len);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(len);
        this.segment.put(this.cursor, bytes, 0, len);
        this.setOffsetAndSize(pos, this.cursor, len);
        this.cursor += roundedSize;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.segment.size();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.segment = MemorySegmentFactory.wrap((byte[])Arrays.copyOf(this.segment.getArray(), newCapacity));
        this.afterGrow();
    }

    protected static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    private static void writeBytesToFixLenPart(MemorySegment segment, int fieldOffset, byte[] bytes, int len) {
        int i;
        long firstByte = len | 0x80;
        long sevenBytes = 0L;
        if (BinaryRecordData.LITTLE_ENDIAN) {
            for (i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)i * 8L);
            }
        } else {
            for (i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)(6 - i) * 8L);
            }
        }
        long offsetAndSize = firstByte << 56 | sevenBytes;
        segment.putLong(fieldOffset, offsetAndSize);
    }

    @Internal
    public MemorySegment getSegments() {
        return this.segment;
    }

    private class BinaryRowWriterOutputView
    extends OutputStream {
        private BinaryRowWriterOutputView() {
        }

        @Override
        public void write(int b) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(1);
            AbstractBinaryWriter.this.segment.put(AbstractBinaryWriter.this.cursor, (byte)b);
            ++AbstractBinaryWriter.this.cursor;
        }

        @Override
        public void write(byte[] b) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(b.length);
            AbstractBinaryWriter.this.segment.put(AbstractBinaryWriter.this.cursor, b, 0, b.length);
            AbstractBinaryWriter.this.cursor += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(len);
            AbstractBinaryWriter.this.segment.put(AbstractBinaryWriter.this.cursor, b, off, len);
            AbstractBinaryWriter.this.cursor += len;
        }

        public void write(MemorySegment seg, int off, int len) throws IOException {
            AbstractBinaryWriter.this.ensureCapacity(len);
            seg.copyTo(off, AbstractBinaryWriter.this.segment, AbstractBinaryWriter.this.cursor, len);
            AbstractBinaryWriter.this.cursor += len;
        }
    }
}

