/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionCompiler;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionKey;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.parser.metadata.MetadataColumns;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.codehaus.janino.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionColumnProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectionColumnProcessor.class);
    private PostTransformChangeInfo tableInfo;
    private ProjectionColumn projectionColumn;
    private String timezone;
    private TransformExpressionKey transformExpressionKey;
    private final List<UserDefinedFunctionDescriptor> udfDescriptors;
    private final SupportedMetadataColumn[] supportedMetadataColumns;
    private final transient List<Object> udfFunctionInstances;
    private transient ExpressionEvaluator expressionEvaluator;

    public ProjectionColumnProcessor(PostTransformChangeInfo tableInfo, ProjectionColumn projectionColumn, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, SupportedMetadataColumn[] supportedMetadataColumns) {
        this.tableInfo = tableInfo;
        this.projectionColumn = projectionColumn;
        this.timezone = timezone;
        this.udfDescriptors = udfDescriptors;
        this.supportedMetadataColumns = supportedMetadataColumns;
        this.transformExpressionKey = this.generateTransformExpressionKey();
        this.expressionEvaluator = TransformExpressionCompiler.compileExpression(this.transformExpressionKey, udfDescriptors);
        this.udfFunctionInstances = udfFunctionInstances;
    }

    public static ProjectionColumnProcessor of(PostTransformChangeInfo tableInfo, ProjectionColumn projectionColumn, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, SupportedMetadataColumn[] supportedMetadataColumns) {
        return new ProjectionColumnProcessor(tableInfo, projectionColumn, timezone, udfDescriptors, udfFunctionInstances, supportedMetadataColumns);
    }

    public ProjectionColumn getProjectionColumn() {
        return this.projectionColumn;
    }

    public Object evaluate(BinaryRecordData record, long epochTime, String opType, Map<String, String> meta) {
        try {
            return this.expressionEvaluator.evaluate(this.generateParams(record, epochTime, opType, meta));
        }
        catch (InvocationTargetException e) {
            LOG.error("Table:{} column:{} projection:{} execute failed. {}", new Object[]{this.tableInfo.getName(), this.projectionColumn.getColumnName(), this.projectionColumn.getScriptExpression(), e});
            throw new RuntimeException(e);
        }
    }

    private Object[] generateParams(BinaryRecordData record, long epochTime, String opType, Map<String, String> meta) {
        ArrayList<Object> params = new ArrayList<Object>();
        List columns = this.tableInfo.getPreTransformedSchema().getColumns();
        RecordData.FieldGetter[] fieldGetters = this.tableInfo.getPreTransformedFieldGetters();
        LinkedHashSet<String> originalColumnNames = new LinkedHashSet<String>(this.projectionColumn.getOriginalColumnNames());
        Iterator iterator = originalColumnNames.iterator();
        block12: while (iterator.hasNext()) {
            String originalColumnName;
            switch (originalColumnName = (String)iterator.next()) {
                case "__namespace_name__": {
                    params.add(this.tableInfo.getNamespace());
                    continue block12;
                }
                case "__schema_name__": {
                    params.add(this.tableInfo.getSchemaName());
                    continue block12;
                }
                case "__table_name__": {
                    params.add(this.tableInfo.getTableName());
                    continue block12;
                }
                case "__data_event_type__": {
                    params.add(opType);
                    continue block12;
                }
            }
            boolean foundInMeta = false;
            for (SupportedMetadataColumn supportedMetadataColumn : this.supportedMetadataColumns) {
                if (!supportedMetadataColumn.getName().equals(originalColumnName)) continue;
                params.add(supportedMetadataColumn.read(meta));
                foundInMeta = true;
                break;
            }
            if (foundInMeta) continue;
            boolean argumentFound = false;
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                if (!column.getName().equals(originalColumnName)) continue;
                params.add(DataTypeConverter.convertToOriginal(fieldGetters[i].getFieldOrNull((RecordData)record), column.getType()));
                argumentFound = true;
                break;
            }
            if (argumentFound) continue;
            throw new IllegalArgumentException("Failed to evaluate argument " + originalColumnName);
        }
        params.add(this.timezone);
        params.add(epochTime);
        params.addAll(this.udfFunctionInstances);
        return params.toArray();
    }

    private TransformExpressionKey generateTransformExpressionKey() {
        ArrayList<String> argumentNames = new ArrayList<String>();
        ArrayList paramTypes = new ArrayList();
        List columns = this.tableInfo.getPreTransformedSchema().getColumns();
        String scriptExpression = this.projectionColumn.getScriptExpression();
        LinkedHashSet<String> originalColumnNames = new LinkedHashSet<String>(this.projectionColumn.getOriginalColumnNames());
        for (String originalColumnName : originalColumnNames) {
            for (Column column : columns) {
                if (!column.getName().equals(originalColumnName)) continue;
                argumentNames.add(originalColumnName);
                paramTypes.add(DataTypeConverter.convertOriginalClass(column.getType()));
                break;
            }
            MetadataColumns.METADATA_COLUMNS.stream().filter(col -> ((String)col.f0).equals(originalColumnName)).findFirst().ifPresent(col -> {
                argumentNames.add((String)col.f0);
                paramTypes.add((Class<?>)col.f2);
            });
            Stream.of(this.supportedMetadataColumns).filter(col -> col.getName().equals(originalColumnName)).findFirst().ifPresent(col -> {
                argumentNames.add(col.getName());
                paramTypes.add(col.getJavaClass());
            });
        }
        argumentNames.add("__time_zone__");
        paramTypes.add(String.class);
        argumentNames.add("__epoch_time__");
        paramTypes.add(Long.class);
        return TransformExpressionKey.of(JaninoCompiler.loadSystemFunction(scriptExpression), argumentNames, paramTypes, DataTypeConverter.convertOriginalClass(this.projectionColumn.getDataType()));
    }
}

