/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.operators.transform.PreTransformChangeInfo;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;

public class PreTransformProcessor {
    private PreTransformChangeInfo tableChangeInfo;

    public PreTransformProcessor(PreTransformChangeInfo tableChangeInfo) {
        this.tableChangeInfo = tableChangeInfo;
    }

    public CreateTableEvent preTransformCreateTableEvent(CreateTableEvent createTableEvent) {
        Schema schema = createTableEvent.getSchema().copy(this.tableChangeInfo.getPreTransformedSchema().getColumns());
        return new CreateTableEvent(createTableEvent.tableId(), schema);
    }

    public BinaryRecordData processFillDataField(BinaryRecordData data) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        List columns = this.tableChangeInfo.getPreTransformedSchema().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            valueList.add(this.getValueFromBinaryRecordData(((Column)columns.get(i)).getName(), data, this.tableChangeInfo.getSourceSchema().getColumns(), this.tableChangeInfo.getSourceFieldGetters()));
        }
        return this.tableChangeInfo.getPreTransformedRecordDataGenerator().generate(valueList.toArray(new Object[0]));
    }

    private Object getValueFromBinaryRecordData(String columnName, BinaryRecordData binaryRecordData, List<Column> columns, RecordData.FieldGetter[] fieldGetters) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columnName.equals(columns.get(i).getName())) continue;
            return DataTypeConverter.convert(fieldGetters[i].getFieldOrNull((RecordData)binaryRecordData), columns.get(i).getType());
        }
        return null;
    }
}

