/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.parser.metadata.TransformSchemaFactory;
import org.apache.flink.cdc.runtime.parser.metadata.TransformSqlOperatorTable;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformParser {
    private static final Logger LOG = LoggerFactory.getLogger(TransformParser.class);
    private static final String DEFAULT_SCHEMA = "default_schema";
    private static final String DEFAULT_TABLE = "TB";
    public static final String DEFAULT_NAMESPACE_NAME = "__namespace_name__";
    public static final String DEFAULT_SCHEMA_NAME = "__schema_name__";
    public static final String DEFAULT_TABLE_NAME = "__table_name__";

    private static SqlParser getCalciteParser(String sql) {
        return SqlParser.create((String)sql, (SqlParser.Config)SqlParser.Config.DEFAULT.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).withCaseSensitive(true).withLex(Lex.JAVA));
    }

    private static RelNode sqlToRel(List<Column> columns, SqlNode sqlNode) {
        List<Column> columnsWithMetadata = TransformParser.copyFillMetadataColumn(sqlNode.toString(), columns);
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        HashMap<String, Object> operand = new HashMap<String, Object>();
        operand.put("tableName", DEFAULT_TABLE);
        operand.put("columns", columnsWithMetadata);
        rootSchema.add(DEFAULT_SCHEMA, TransformSchemaFactory.INSTANCE.create(rootSchema.plus(), DEFAULT_SCHEMA, operand));
        SqlTypeFactoryImpl factory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        CalciteCatalogReader calciteCatalogReader = new CalciteCatalogReader(rootSchema, rootSchema.path(DEFAULT_SCHEMA), (RelDataTypeFactory)factory, (CalciteConnectionConfig)new CalciteConnectionConfigImpl(new Properties()));
        TransformSqlOperatorTable transformSqlOperatorTable = TransformSqlOperatorTable.instance();
        SqlStdOperatorTable sqlStdOperatorTable = SqlStdOperatorTable.instance();
        SqlValidatorWithHints validator = SqlValidatorUtil.newValidator((SqlOperatorTable)SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{sqlStdOperatorTable, transformSqlOperatorTable}), (SqlValidatorCatalogReader)calciteCatalogReader, (RelDataTypeFactory)factory, (SqlValidator.Config)SqlValidator.Config.DEFAULT.withIdentifierExpansion(true));
        SqlNode validateSqlNode = validator.validate(sqlNode);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter(null, (SqlValidator)validator, (Prepare.CatalogReader)calciteCatalogReader, RelOptCluster.create((RelOptPlanner)new HepPlanner(new HepProgramBuilder().build()), (RexBuilder)new RexBuilder((RelDataTypeFactory)factory)), (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, SqlToRelConverter.config().withTrimUnusedFields(false));
        RelRoot relRoot = sqlToRelConverter.convertQuery(validateSqlNode, false, true);
        return relRoot.rel;
    }

    public static SqlSelect parseSelect(String statement) {
        SqlNode sqlNode = null;
        try {
            sqlNode = TransformParser.getCalciteParser(statement).parseQuery();
        }
        catch (SqlParseException e) {
            LOG.error("Statements can not be parsed. {} \n {}", (Object)statement, (Object)e);
            throw new ParseException("Statements can not be parsed.", (Throwable)e);
        }
        if (sqlNode instanceof SqlSelect) {
            return (SqlSelect)sqlNode;
        }
        throw new ParseException("Only select statements can be parsed.");
    }

    public static List<ProjectionColumn> generateProjectionColumns(String projectionExpression, List<Column> columns) {
        if (StringUtils.isNullOrWhitespaceOnly((String)projectionExpression)) {
            return new ArrayList<ProjectionColumn>();
        }
        SqlSelect sqlSelect = TransformParser.parseProjectionExpression(projectionExpression);
        if (sqlSelect.getSelectList().isEmpty()) {
            return new ArrayList<ProjectionColumn>();
        }
        RelNode relNode = TransformParser.sqlToRel(columns, (SqlNode)sqlSelect);
        Map<String, RelDataType> relDataTypeMap = relNode.getRowType().getFieldList().stream().collect(Collectors.toMap(RelDataTypeField::getName, RelDataTypeField::getType));
        Map<String, Boolean> isNotNullMap = columns.stream().collect(Collectors.toMap(Column::getName, column -> !column.getType().isNullable()));
        ArrayList<ProjectionColumn> projectionColumns = new ArrayList<ProjectionColumn>();
        for (SqlNode sqlNode : sqlSelect.getSelectList()) {
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                if (SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind)) {
                    Optional<Object> transformOptional = Optional.empty();
                    String columnName = null;
                    List operandList = sqlBasicCall.getOperandList();
                    if (operandList.size() == 2) {
                        transformOptional = Optional.of(operandList.get(0));
                        SqlNode sqlNode1 = (SqlNode)operandList.get(1);
                        if (sqlNode1 instanceof SqlIdentifier) {
                            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode1;
                            columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                        }
                    }
                    if (TransformParser.isMetadataColumn(columnName)) continue;
                    ProjectionColumn projectionColumn = transformOptional.isPresent() ? ProjectionColumn.of(columnName, DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataTypeMap.get(columnName)), ((SqlNode)transformOptional.get()).toString(), JaninoCompiler.translateSqlNodeToJaninoExpression((SqlNode)transformOptional.get()), TransformParser.parseColumnNameList((SqlNode)transformOptional.get())) : ProjectionColumn.of(columnName, DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataTypeMap.get(columnName)));
                    boolean hasReplacedDuplicateColumn = false;
                    for (int i = 0; i < projectionColumns.size(); ++i) {
                        if (!((ProjectionColumn)projectionColumns.get(i)).getColumnName().equals(columnName) || ((ProjectionColumn)projectionColumns.get(i)).isValidTransformedProjectionColumn()) continue;
                        hasReplacedDuplicateColumn = true;
                        projectionColumns.set(i, projectionColumn);
                        break;
                    }
                    if (hasReplacedDuplicateColumn) continue;
                    projectionColumns.add(projectionColumn);
                    continue;
                }
                throw new ParseException("Unrecognized projection: " + sqlBasicCall.toString());
            }
            if (sqlNode instanceof SqlIdentifier) {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                DataType columnType = DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataTypeMap.get(columnName));
                if (TransformParser.isMetadataColumn(columnName)) {
                    projectionColumns.add(ProjectionColumn.of(columnName, columnType.notNull(), columnName, columnName, Arrays.asList(columnName)));
                    continue;
                }
                projectionColumns.add(ProjectionColumn.of(columnName, isNotNullMap.get(columnName) != false ? columnType.notNull() : columnType.nullable()));
                continue;
            }
            throw new ParseException("Unrecognized projection: " + sqlNode.toString());
        }
        return projectionColumns;
    }

    public static String translateFilterExpressionToJaninoExpression(String filterExpression) {
        if (StringUtils.isNullOrWhitespaceOnly((String)filterExpression)) {
            return "";
        }
        SqlSelect sqlSelect = TransformParser.parseFilterExpression(filterExpression);
        if (!sqlSelect.hasWhere()) {
            return "";
        }
        SqlNode where = sqlSelect.getWhere();
        return JaninoCompiler.translateSqlNodeToJaninoExpression(where);
    }

    public static List<String> parseComputedColumnNames(String projection) {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (StringUtils.isNullOrWhitespaceOnly((String)projection)) {
            return columnNames;
        }
        SqlSelect sqlSelect = TransformParser.parseProjectionExpression(projection);
        if (sqlSelect.getSelectList().isEmpty()) {
            return columnNames;
        }
        for (SqlNode sqlNode : sqlSelect.getSelectList()) {
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                if (SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind)) {
                    String columnName = null;
                    List operandList = sqlBasicCall.getOperandList();
                    for (SqlNode operand : operandList) {
                        if (!(operand instanceof SqlIdentifier)) continue;
                        SqlIdentifier sqlIdentifier = (SqlIdentifier)operand;
                        columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                    }
                    if (columnNames.contains(columnName)) {
                        throw new ParseException("Duplicate column definitions: " + columnName);
                    }
                    columnNames.add(columnName);
                    continue;
                }
                throw new ParseException("Unrecognized projection: " + sqlBasicCall.toString());
            }
            if (sqlNode instanceof SqlIdentifier) {
                String columnName = sqlNode.toString();
                if (!TransformParser.isMetadataColumn(columnName) || columnNames.contains(columnName)) continue;
                columnNames.add(columnName);
                continue;
            }
            throw new ParseException("Unrecognized projection: " + sqlNode.toString());
        }
        return columnNames;
    }

    public static List<String> parseFilterColumnNameList(String filterExpression) {
        if (StringUtils.isNullOrWhitespaceOnly((String)filterExpression)) {
            return new ArrayList<String>();
        }
        SqlSelect sqlSelect = TransformParser.parseFilterExpression(filterExpression);
        if (!sqlSelect.hasWhere()) {
            return new ArrayList<String>();
        }
        SqlNode where = sqlSelect.getWhere();
        return TransformParser.parseColumnNameList(where);
    }

    private static List<String> parseColumnNameList(SqlNode sqlNode) {
        ArrayList<String> columnNameList = new ArrayList<String>();
        if (sqlNode instanceof SqlIdentifier) {
            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
            String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
            columnNameList.add(columnName);
        } else if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            TransformParser.findSqlIdentifier(sqlBasicCall.getOperandList(), columnNameList);
        } else if (sqlNode instanceof SqlCase) {
            SqlCase sqlCase = (SqlCase)sqlNode;
            TransformParser.findSqlIdentifier(sqlCase.getWhenOperands().getList(), columnNameList);
        }
        return columnNameList;
    }

    private static void findSqlIdentifier(List<SqlNode> sqlNodes, List<String> columnNameList) {
        for (SqlNode sqlNode : sqlNodes) {
            if (sqlNode instanceof SqlIdentifier) {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                columnNameList.add(columnName);
                continue;
            }
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                TransformParser.findSqlIdentifier(sqlBasicCall.getOperandList(), columnNameList);
                continue;
            }
            if (!(sqlNode instanceof SqlCase)) continue;
            SqlCase sqlCase = (SqlCase)sqlNode;
            SqlNodeList whenOperands = sqlCase.getWhenOperands();
            TransformParser.findSqlIdentifier(whenOperands.getList(), columnNameList);
        }
    }

    private static SqlSelect parseProjectionExpression(String projection) {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT ");
        statement.append(projection);
        statement.append(" FROM ");
        statement.append(DEFAULT_TABLE);
        return TransformParser.parseSelect(statement.toString());
    }

    private static List<Column> copyFillMetadataColumn(String transformStatement, List<Column> columns) {
        ArrayList<Column> columnsWithMetadata = new ArrayList<Column>(columns);
        if (transformStatement.contains(DEFAULT_NAMESPACE_NAME) && !TransformParser.containsMetadataColumn(columnsWithMetadata, DEFAULT_NAMESPACE_NAME)) {
            columnsWithMetadata.add((Column)Column.physicalColumn((String)DEFAULT_NAMESPACE_NAME, (DataType)DataTypes.STRING()));
        }
        if (transformStatement.contains(DEFAULT_SCHEMA_NAME) && !TransformParser.containsMetadataColumn(columnsWithMetadata, DEFAULT_SCHEMA_NAME)) {
            columnsWithMetadata.add((Column)Column.physicalColumn((String)DEFAULT_SCHEMA_NAME, (DataType)DataTypes.STRING()));
        }
        if (transformStatement.contains(DEFAULT_TABLE_NAME) && !TransformParser.containsMetadataColumn(columnsWithMetadata, DEFAULT_TABLE_NAME)) {
            columnsWithMetadata.add((Column)Column.physicalColumn((String)DEFAULT_TABLE_NAME, (DataType)DataTypes.STRING()));
        }
        return columnsWithMetadata;
    }

    private static boolean containsMetadataColumn(List<Column> columns, String columnName) {
        return columns.stream().anyMatch(column -> column.getName().equals(columnName));
    }

    private static boolean isMetadataColumn(String columnName) {
        return DEFAULT_TABLE_NAME.equals(columnName) || DEFAULT_SCHEMA_NAME.equals(columnName) || DEFAULT_NAMESPACE_NAME.equals(columnName);
    }

    public static SqlSelect parseFilterExpression(String filterExpression) {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT * FROM ");
        statement.append(DEFAULT_TABLE);
        if (!StringUtils.isNullOrWhitespaceOnly((String)filterExpression)) {
            statement.append(" WHERE ");
            statement.append(filterExpression);
        }
        return TransformParser.parseSelect(statement.toString());
    }
}

