/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumnProcessor;
import org.apache.flink.cdc.runtime.operators.transform.TableChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.TableInfo;
import org.apache.flink.cdc.runtime.operators.transform.TransformProjection;
import org.apache.flink.cdc.runtime.parser.TransformParser;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformProjectionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TransformProjectionProcessor.class);
    private TableInfo tableInfo;
    private TableChangeInfo tableChangeInfo;
    private TransformProjection transformProjection;
    private String timezone;
    private Map<String, ProjectionColumnProcessor> projectionColumnProcessorMap;

    public TransformProjectionProcessor(TableInfo tableInfo, TableChangeInfo tableChangeInfo, TransformProjection transformProjection, String timezone) {
        this.tableInfo = tableInfo;
        this.tableChangeInfo = tableChangeInfo;
        this.transformProjection = transformProjection;
        this.timezone = timezone;
        this.projectionColumnProcessorMap = new ConcurrentHashMap<String, ProjectionColumnProcessor>();
    }

    public boolean hasTableChangeInfo() {
        return this.tableChangeInfo != null;
    }

    public boolean hasTableInfo() {
        return this.tableInfo != null;
    }

    public static TransformProjectionProcessor of(TableInfo tableInfo, TransformProjection transformProjection, String timezone) {
        return new TransformProjectionProcessor(tableInfo, null, transformProjection, timezone);
    }

    public static TransformProjectionProcessor of(TableChangeInfo tableChangeInfo, TransformProjection transformProjection) {
        return new TransformProjectionProcessor(null, tableChangeInfo, transformProjection, null);
    }

    public static TransformProjectionProcessor of(TransformProjection transformProjection) {
        return new TransformProjectionProcessor(null, null, transformProjection, null);
    }

    public CreateTableEvent processCreateTableEvent(CreateTableEvent createTableEvent) {
        List<ProjectionColumn> projectionColumns = TransformParser.generateProjectionColumns(this.transformProjection.getProjection(), createTableEvent.getSchema().getColumns());
        this.transformProjection.setProjectionColumns(projectionColumns);
        List<Column> allColumnList = this.transformProjection.getAllColumnList();
        Schema schema = createTableEvent.getSchema().copy(allColumnList);
        return new CreateTableEvent(createTableEvent.tableId(), schema);
    }

    public void processSchemaChangeEvent(Schema schema) {
        List<ProjectionColumn> projectionColumns = TransformParser.generateProjectionColumns(this.transformProjection.getProjection(), schema.getColumns());
        this.transformProjection.setProjectionColumns(projectionColumns);
    }

    public BinaryRecordData processFillDataField(BinaryRecordData data) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (Column column : this.tableChangeInfo.getTransformedSchema().getColumns()) {
            boolean isProjectionColumn = false;
            for (ProjectionColumn projectionColumn : this.transformProjection.getProjectionColumns()) {
                if (!column.getName().equals(projectionColumn.getColumnName()) || !projectionColumn.isValidTransformedProjectionColumn()) continue;
                valueList.add(null);
                isProjectionColumn = true;
                break;
            }
            if (isProjectionColumn) continue;
            valueList.add(this.getValueFromBinaryRecordData(column.getName(), data, this.tableChangeInfo.getOriginalSchema().getColumns(), this.tableChangeInfo.getFieldGetters()));
        }
        return this.tableChangeInfo.getRecordDataGenerator().generate(valueList.toArray(new Object[valueList.size()]));
    }

    public BinaryRecordData processData(BinaryRecordData after, long epochTime) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (Column column : this.tableInfo.getSchema().getColumns()) {
            boolean isProjectionColumn = false;
            for (ProjectionColumn projectionColumn : this.transformProjection.getProjectionColumns()) {
                if (!column.getName().equals(projectionColumn.getColumnName()) || !projectionColumn.isValidTransformedProjectionColumn()) continue;
                if (!this.projectionColumnProcessorMap.containsKey(projectionColumn.getColumnName())) {
                    this.projectionColumnProcessorMap.put(projectionColumn.getColumnName(), ProjectionColumnProcessor.of(this.tableInfo, projectionColumn, this.timezone));
                }
                ProjectionColumnProcessor projectionColumnProcessor = this.projectionColumnProcessorMap.get(projectionColumn.getColumnName());
                valueList.add(DataTypeConverter.convert(projectionColumnProcessor.evaluate(after, epochTime), projectionColumn.getDataType()));
                isProjectionColumn = true;
                break;
            }
            if (isProjectionColumn) continue;
            valueList.add(this.getValueFromBinaryRecordData(column.getName(), after, this.tableInfo.getSchema().getColumns(), this.tableInfo.getFieldGetters()));
        }
        return this.tableInfo.getRecordDataGenerator().generate(valueList.toArray(new Object[valueList.size()]));
    }

    private Object getValueFromBinaryRecordData(String columnName, BinaryRecordData binaryRecordData, List<Column> columns, RecordData.FieldGetter[] fieldGetters) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columnName.equals(columns.get(i).getName())) continue;
            return DataTypeConverter.convert(fieldGetters[i].getFieldOrNull((RecordData)binaryRecordData), columns.get(i).getType());
        }
        return null;
    }
}

