/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class TransformExpressionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final List<String> argumentNames;
    private final List<Class<?>> argumentClasses;
    private final Class<?> returnClass;

    private TransformExpressionKey(String expression, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass) {
        this.expression = expression;
        this.argumentNames = argumentNames;
        this.argumentClasses = argumentClasses;
        this.returnClass = returnClass;
    }

    public String getExpression() {
        return this.expression;
    }

    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    public List<Class<?>> getArgumentClasses() {
        return this.argumentClasses;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public static TransformExpressionKey of(String expression, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass) {
        return new TransformExpressionKey(expression, argumentNames, argumentClasses, returnClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformExpressionKey that = (TransformExpressionKey)o;
        return this.expression.equals(that.expression) && this.argumentNames.equals(that.argumentNames) && this.argumentClasses.equals(that.argumentClasses) && this.returnClass.equals(that.returnClass);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.argumentNames, this.argumentClasses, this.returnClass);
    }
}

