/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.table;

import io.debezium.util.HexConverter;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Optional;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.debezium.table.DeserializationRuntimeConverter;
import org.apache.flink.cdc.debezium.table.DeserializationRuntimeConverterFactory;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;

public class PostgreSQLDeserializationConverterFactory {
    public static final String SRID = "srid";
    public static final String HEXEWKB = "hexewkb";

    public static DeserializationRuntimeConverterFactory instance() {
        return new DeserializationRuntimeConverterFactory(){
            private static final long serialVersionUID = 1L;

            @Override
            public Optional<DeserializationRuntimeConverter> createUserDefinedConverter(LogicalType logicalType, ZoneId serverTimeZone) {
                switch (logicalType.getTypeRoot()) {
                    case VARCHAR: {
                        return PostgreSQLDeserializationConverterFactory.createStringConverter();
                    }
                }
                return Optional.empty();
            }
        };
    }

    private static Optional<DeserializationRuntimeConverter> createStringConverter() {
        ObjectMapper objectMapper = new ObjectMapper();
        final ObjectWriter objectWriter = objectMapper.writer();
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if ("io.debezium.data.geometry.Geometry".equals(schema.name()) || "io.debezium.data.geometry.Geography".equals(schema.name())) {
                    try {
                        Struct geometryStruct = (Struct)dbzObj;
                        byte[] wkb = geometryStruct.getBytes("wkb");
                        Optional<Integer> srid = Optional.ofNullable(geometryStruct.getInt32(PostgreSQLDeserializationConverterFactory.SRID));
                        HashMap<String, Object> geometryInfo = new HashMap<String, Object>(2);
                        geometryInfo.put(PostgreSQLDeserializationConverterFactory.HEXEWKB, HexConverter.convertToHexString(wkb));
                        geometryInfo.put(PostgreSQLDeserializationConverterFactory.SRID, srid.orElse(0));
                        return StringData.fromString((String)objectWriter.writeValueAsString(geometryInfo));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Failed to convert %s to geometry JSON.", dbzObj), e);
                    }
                }
                return StringData.fromString((String)dbzObj.toString());
            }
        });
    }
}

