/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.reader.external;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceRecords;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplit;
import org.apache.flink.cdc.connectors.base.source.meta.wartermark.WatermarkEvent;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.base.source.reader.external.Fetcher;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.shaded.guava31.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSourceStreamFetcher
implements Fetcher<SourceRecords, SourceSplitBase> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalSourceStreamFetcher.class);
    private final FetchTask.Context taskContext;
    private final ExecutorService executorService;
    private final Set<TableId> pureStreamPhaseTables;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile boolean currentTaskRunning;
    private volatile Throwable readException;
    private FetchTask<SourceSplitBase> streamFetchTask;
    private StreamSplit currentStreamSplit;
    private Map<TableId, List<FinishedSnapshotSplitInfo>> finishedSplitsInfo;
    private Map<TableId, Offset> maxSplitHighWatermarkMap;
    private final boolean isBackfillSkipped;
    private static final long READER_CLOSE_TIMEOUT_SECONDS = 30L;

    public IncrementalSourceStreamFetcher(FetchTask.Context taskContext, int subTaskId) {
        this.taskContext = taskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subTaskId).build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.currentTaskRunning = true;
        this.pureStreamPhaseTables = new HashSet<TableId>();
        this.isBackfillSkipped = taskContext.getSourceConfig().isSkipSnapshotBackfill();
    }

    @Override
    public void submitTask(FetchTask<SourceSplitBase> fetchTask) {
        this.streamFetchTask = fetchTask;
        this.currentStreamSplit = fetchTask.getSplit().asStreamSplit();
        this.configureFilter();
        this.taskContext.configure(this.currentStreamSplit);
        this.queue = this.taskContext.getQueue();
        this.executorService.submit(() -> {
            try {
                this.streamFetchTask.execute(this.taskContext);
            }
            catch (Exception e) {
                LOG.error(String.format("Execute stream read task for stream split %s fail", this.currentStreamSplit), (Throwable)e);
                this.readException = e;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.currentStreamSplit == null || !this.currentTaskRunning;
    }

    @Override
    @Nullable
    public Iterator<SourceRecords> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        if (this.currentTaskRunning) {
            List<DataChangeEvent> batch = this.queue.poll();
            for (DataChangeEvent event : batch) {
                if (WatermarkEvent.isEndWatermarkEvent(event.getRecord())) {
                    LOG.info("Read split {} end watermark event", (Object)this.currentStreamSplit);
                    try {
                        this.stopReadTask();
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.shouldEmit(event.getRecord())) {
                    sourceRecords.add(event.getRecord());
                    continue;
                }
                LOG.debug("{} data change event should not emit", (Object)event);
            }
            ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
            sourceRecordsSet.add(new SourceRecords(sourceRecords));
            return sourceRecordsSet.iterator();
        }
        return null;
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new FlinkRuntimeException(String.format("Read split %s error due to %s.", this.currentStreamSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            this.stopReadTask();
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Failed to close the stream fetcher in {} seconds.", (Object)30L);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Close stream fetcher error", (Throwable)e);
        }
    }

    private boolean shouldEmit(SourceRecord sourceRecord) {
        if (this.taskContext.isDataChangeRecord(sourceRecord)) {
            Offset position;
            TableId tableId = this.taskContext.getTableId(sourceRecord);
            if (this.hasEnterPureStreamPhase(tableId, position = this.taskContext.getStreamOffset(sourceRecord))) {
                return true;
            }
            if (this.finishedSplitsInfo.containsKey(tableId)) {
                if (this.isBackfillSkipped) {
                    return true;
                }
                for (FinishedSnapshotSplitInfo splitInfo : this.finishedSplitsInfo.get(tableId)) {
                    if (!this.taskContext.isRecordBetween(sourceRecord, splitInfo.getSplitStart(), splitInfo.getSplitEnd()) || !position.isAfter(splitInfo.getHighWatermark())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean hasEnterPureStreamPhase(TableId tableId, Offset position) {
        if (this.pureStreamPhaseTables.contains(tableId)) {
            return true;
        }
        if (this.maxSplitHighWatermarkMap.containsKey(tableId) && position.isAtOrAfter(this.maxSplitHighWatermarkMap.get(tableId))) {
            this.pureStreamPhaseTables.add(tableId);
            return true;
        }
        if (!this.taskContext.getSourceConfig().isScanNewlyAddedTableEnabled()) {
            return !this.maxSplitHighWatermarkMap.containsKey(tableId) && this.taskContext.getTableFilter().isIncluded(tableId);
        }
        return false;
    }

    private void configureFilter() {
        List<FinishedSnapshotSplitInfo> finishedSplitInfos = this.currentStreamSplit.getFinishedSnapshotSplitInfos();
        HashMap<TableId, List<FinishedSnapshotSplitInfo>> splitsInfoMap = new HashMap<TableId, List<FinishedSnapshotSplitInfo>>();
        HashMap<TableId, Offset> tableIdOffsetPositionMap = new HashMap<TableId, Offset>();
        if (this.taskContext.getSourceConfig().getStartupOptions().isStreamOnly()) {
            for (TableId tableId : this.currentStreamSplit.getTableSchemas().keySet()) {
                tableIdOffsetPositionMap.put(tableId, this.currentStreamSplit.getStartingOffset());
            }
        } else {
            for (FinishedSnapshotSplitInfo finishedSplitInfo : finishedSplitInfos) {
                TableId tableId = finishedSplitInfo.getTableId();
                List list = splitsInfoMap.getOrDefault(tableId, new ArrayList());
                list.add(finishedSplitInfo);
                splitsInfoMap.put(tableId, list);
                Offset highWatermark = finishedSplitInfo.getHighWatermark();
                Offset maxHighWatermark = (Offset)tableIdOffsetPositionMap.get(tableId);
                if (maxHighWatermark != null && !highWatermark.isAfter(maxHighWatermark)) continue;
                tableIdOffsetPositionMap.put(tableId, highWatermark);
            }
        }
        this.finishedSplitsInfo = splitsInfoMap;
        this.maxSplitHighWatermarkMap = tableIdOffsetPositionMap;
        this.pureStreamPhaseTables.clear();
    }

    public void stopReadTask() throws Exception {
        this.currentTaskRunning = false;
        if (this.taskContext != null) {
            this.taskContext.close();
        }
        if (this.streamFetchTask != null) {
            this.streamFetchTask.close();
        }
    }
}

