/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.cli;

import java.nio.file.Path;
import java.util.List;
import org.apache.flink.cdc.cli.parser.YamlPipelineDefinitionParser;
import org.apache.flink.cdc.cli.utils.FlinkEnvironmentUtils;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.composer.PipelineComposer;
import org.apache.flink.cdc.composer.PipelineExecution;
import org.apache.flink.cdc.composer.definition.PipelineDef;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class CliExecutor {
    private final Path pipelineDefPath;
    private final Configuration flinkConfig;
    private final Configuration globalPipelineConfig;
    private final boolean useMiniCluster;
    private final List<Path> additionalJars;
    private PipelineComposer composer = null;
    private final SavepointRestoreSettings savepointSettings;

    public CliExecutor(Path pipelineDefPath, Configuration flinkConfig, Configuration globalPipelineConfig, boolean useMiniCluster, List<Path> additionalJars, SavepointRestoreSettings savepointSettings) {
        this.pipelineDefPath = pipelineDefPath;
        this.flinkConfig = flinkConfig;
        this.globalPipelineConfig = globalPipelineConfig;
        this.useMiniCluster = useMiniCluster;
        this.additionalJars = additionalJars;
        this.savepointSettings = savepointSettings;
    }

    public PipelineExecution.ExecutionInfo run() throws Exception {
        YamlPipelineDefinitionParser pipelineDefinitionParser = new YamlPipelineDefinitionParser();
        PipelineDef pipelineDef = pipelineDefinitionParser.parse(this.pipelineDefPath, this.globalPipelineConfig);
        PipelineComposer composer = this.getComposer();
        PipelineExecution execution = composer.compose(pipelineDef);
        return execution.execute();
    }

    private PipelineComposer getComposer() {
        if (this.composer == null) {
            return FlinkEnvironmentUtils.createComposer(this.useMiniCluster, this.flinkConfig, this.additionalJars, this.savepointSettings);
        }
        return this.composer;
    }

    @VisibleForTesting
    void setComposer(PipelineComposer composer) {
        this.composer = composer;
    }

    @VisibleForTesting
    public Configuration getFlinkConfig() {
        return this.flinkConfig;
    }

    @VisibleForTesting
    public Configuration getGlobalPipelineConfig() {
        return this.globalPipelineConfig;
    }

    @VisibleForTesting
    public List<Path> getAdditionalJars() {
        return this.additionalJars;
    }

    public SavepointRestoreSettings getSavepointSettings() {
        return this.savepointSettings;
    }
}

