/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.metrics;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;

public class SourceReaderMetrics {
    public static final long UNDEFINED = -1L;
    private final SourceReaderMetricGroup metricGroup;
    private volatile long fetchDelay = -1L;
    private final Counter numRecordsInErrorsCounter;

    public SourceReaderMetrics(SourceReaderMetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        this.numRecordsInErrorsCounter = metricGroup.getNumRecordsInErrorsCounter();
    }

    public void registerMetrics() {
        this.metricGroup.gauge("currentFetchEventTimeLag", this::getFetchDelay);
    }

    public long getFetchDelay() {
        return this.fetchDelay;
    }

    public void recordFetchDelay(long fetchDelay) {
        this.fetchDelay = fetchDelay;
    }

    public void addNumRecordsInErrors(long delta) {
        this.numRecordsInErrorsCounter.inc(delta);
    }
}

