/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.meta.split;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceRecords;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;

public final class ChangeEventRecords
implements RecordsWithSplitIds<SourceRecords> {
    @Nullable
    private String splitId;
    @Nullable
    private Iterator<SourceRecords> recordsForCurrentSplit;
    @Nullable
    private final Iterator<SourceRecords> recordsForSplit;
    private final Set<String> finishedSnapshotSplits;

    public ChangeEventRecords(@Nullable String splitId, @Nullable Iterator recordsForSplit, Set<String> finishedSnapshotSplits) {
        this.splitId = splitId;
        this.recordsForSplit = recordsForSplit;
        this.finishedSnapshotSplits = finishedSnapshotSplits;
    }

    @Nullable
    public String nextSplit() {
        String nextSplit = this.splitId;
        this.splitId = null;
        this.recordsForCurrentSplit = nextSplit != null ? this.recordsForSplit : null;
        return nextSplit;
    }

    @Nullable
    public SourceRecords nextRecordFromSplit() {
        Iterator<SourceRecords> recordsForSplit = this.recordsForCurrentSplit;
        if (recordsForSplit != null) {
            if (recordsForSplit.hasNext()) {
                return recordsForSplit.next();
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public Set<String> finishedSplits() {
        return this.finishedSnapshotSplits;
    }

    public static ChangeEventRecords forRecords(String splitId, Iterator<SourceRecords> recordsForSplit) {
        return new ChangeEventRecords(splitId, recordsForSplit, Collections.emptySet());
    }

    public static ChangeEventRecords forSnapshotRecords(String splitId, Iterator<SourceRecords> recordsForSplit) {
        return new ChangeEventRecords(splitId, recordsForSplit, Collections.singleton(splitId));
    }

    public static ChangeEventRecords forFinishedSplit(String splitId) {
        return new ChangeEventRecords(null, null, Collections.singleton(splitId));
    }
}

