/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.felix.webconsole");

    public static String getName(Bundle bundle, Locale locale) {
        String loc = locale == null ? null : locale.toString();
        String name = (String)bundle.getHeaders(loc).get("Bundle-Name");
        if ((name == null || name.length() == 0) && (name = bundle.getSymbolicName()) == null && (name = bundle.getLocation()) == null) {
            name = String.valueOf(bundle.getBundleId());
        }
        return name;
    }

    public static String getHeaderValue(Bundle bundle, String headerName) {
        Object value = bundle.getHeaders().get(headerName);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public static void sort(Bundle[] bundles, Locale locale) {
        Arrays.sort(bundles, new BundleNameComparator(locale));
    }

    public static final Locale parseLocaleString(String locale) {
        String language;
        if (locale == null) {
            return Locale.getDefault();
        }
        int idx = locale.indexOf(95);
        String country = "";
        if (idx < 0) {
            language = locale;
        } else {
            int last;
            language = locale.substring(0, idx);
            if ((last = locale.indexOf(95, ++idx)) < 0) {
                last = locale.length();
            }
            country = locale.substring(idx, last);
        }
        return new Locale(language, country);
    }

    public static void sendJsonOk(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print("{ \"status\": true }");
    }

    public static void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.addHeader("Cache-Control", "max-age=0");
        response.setHeader("Expires", "Thu, 01 Jan 1970 01:00:00 GMT");
        response.setHeader("Pragma", "no-cache");
    }

    public static String getStringProperty(ServiceReference<?> service, String propertyName) {
        Object property = service.getProperty(propertyName);
        if (property instanceof String) {
            return (String)property;
        }
        return null;
    }

    public static void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        if (!((String)redirectUrl).startsWith("/")) {
            Object base = request.getContextPath() + request.getServletPath() + request.getPathInfo();
            int i = ((String)base).lastIndexOf(47);
            if (i > -1) {
                base = ((String)base).substring(0, i);
            } else {
                i = ((String)base).indexOf(58);
                Object object = base = i > -1 ? ((String)base).substring(i + 1, ((String)base).length()) : "";
            }
            if (!((String)base).startsWith("/")) {
                base = "/" + (String)base;
            }
            redirectUrl = (String)base + "/" + (String)redirectUrl;
        }
        response.sendRedirect((String)redirectUrl);
    }

    public static String[] toStringArray(Object value) {
        Collection<Object> col;
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value != null && (col = value.getClass().isArray() ? Arrays.asList((Object[])value) : (value instanceof Collection ? (Collection)value : null)) != null && !col.isEmpty()) {
            String[] entries = new String[col.size()];
            int i = 0;
            Iterator<Object> cli = col.iterator();
            while (cli.hasNext()) {
                entries[i] = String.valueOf(cli.next());
                ++i;
            }
            return entries;
        }
        return null;
    }

    public static final String toString(Object value) {
        if (value == null) {
            return "n/a";
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            int len = Array.getLength(value);
            sb.append('[');
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(value, i);
                if (element instanceof Byte) {
                    sb.append("0x");
                    String x = Integer.toHexString(((Byte)element).intValue() & 0xFF);
                    if (1 == x.length()) {
                        sb.append('0');
                    }
                    sb.append(x);
                } else {
                    sb.append(Util.toString(element));
                }
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            return sb.append(']').toString();
        }
        return value.toString();
    }

    public static String toString(ServiceReference<?> ref) {
        return "Service " + ref.getProperty("service.id") + "(" + ref + ") from bundle " + ref.getBundle().getSymbolicName() + ":" + ref.getBundle().getVersion() + "(" + ref.getBundle().getBundleId() + ")";
    }

    /*
     * Exception decompiling
     */
    public static final String readTemplateFile(Class<?> clazz, String templateFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class BundleNameComparator
    implements Comparator<Bundle> {
        private final Locale locale;

        BundleNameComparator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public int compare(Bundle b1, Bundle b2) {
            Version v2;
            if (b1 == b2 || b1.getBundleId() == b2.getBundleId()) {
                return 0;
            }
            if (b1.getBundleId() == 0L) {
                return -1;
            }
            if (b2.getBundleId() == 0L) {
                return 1;
            }
            int snComp = Util.getName(b1, this.locale).compareToIgnoreCase(Util.getName(b2, this.locale));
            if (snComp != 0) {
                return snComp;
            }
            Version v1 = Version.parseVersion((String)((String)b1.getHeaders().get("Bundle-Version")));
            int vComp = v1.compareTo(v2 = Version.parseVersion((String)((String)b2.getHeaders().get("Bundle-Version"))));
            if (vComp != 0) {
                return vComp;
            }
            if (b1.getBundleId() < b2.getBundleId()) {
                return -1;
            }
            return 1;
        }
    }
}

