/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.webconsole.internal.configuration.MetaTypeSupport;
import org.apache.felix.webconsole.internal.configuration.MetatypePropertyDescriptor;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

class MetaTypeServiceSupport
extends MetaTypeSupport {
    private final BundleContext bundleContext;
    private final MetaTypeService service;
    private static final IdGetter PID_GETTER = new IdGetter(){

        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getPids();
        }
    };
    private static final IdGetter FACTORY_PID_GETTER = new IdGetter(){

        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getFactoryPids();
        }
    };

    MetaTypeServiceSupport(BundleContext bundleContext, Object service) {
        this.bundleContext = bundleContext;
        this.service = (MetaTypeService)service;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public MetaTypeService getMetaTypeService() {
        return this.service;
    }

    Map getPidObjectClasses(String locale) {
        return this.getObjectClassDefinitions(PID_GETTER, locale);
    }

    Map getFactoryPidObjectClasses(String locale) {
        return this.getObjectClassDefinitions(FACTORY_PID_GETTER, locale);
    }

    private Map getObjectClassDefinitions(IdGetter idGetter, String locale) {
        HashMap<String, ObjectClassDefinition> objectClassesDefinitions = new HashMap<String, ObjectClassDefinition>();
        MetaTypeService mts = this.getMetaTypeService();
        if (mts != null) {
            Bundle[] bundles = this.getBundleContext().getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                MetaTypeInformation mti = mts.getMetaTypeInformation(bundles[i]);
                if (mti == null) continue;
                String[] idList = idGetter.getIds(mti);
                for (int j = 0; idList != null && j < idList.length; ++j) {
                    ObjectClassDefinition ocd = null;
                    try {
                        ocd = mti.getObjectClassDefinition(idList[j], locale);
                    }
                    catch (IllegalArgumentException ignore) {
                        // empty catch block
                    }
                    if (ocd == null) continue;
                    objectClassesDefinitions.put(idList[j], ocd);
                }
            }
        }
        return objectClassesDefinitions;
    }

    ObjectClassDefinition getObjectClassDefinition(Configuration config, String locale) {
        Bundle bundle;
        if (config.getBundleLocation() != null && (bundle = MetaTypeServiceSupport.getBundle(this.getBundleContext(), config.getBundleLocation())) != null) {
            String id = config.getFactoryPid();
            if (null == id) {
                id = config.getPid();
            }
            return this.getObjectClassDefinition(bundle, id, locale);
        }
        if (config.getFactoryPid() != null) {
            return this.getObjectClassDefinition(config.getFactoryPid(), locale);
        }
        return this.getObjectClassDefinition(config.getPid(), locale);
    }

    ObjectClassDefinition getObjectClassDefinition(Bundle bundle, String pid, String locale) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        if (bundle != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(bundle)) != null) {
            try {
                return mti.getObjectClassDefinition(pid, locale);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return null;
    }

    ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            try {
                ObjectClassDefinition ocd = this.getObjectClassDefinition(bundles[i], pid, locale);
                if (ocd == null) continue;
                return ocd;
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return null;
    }

    Map getAttributeDefinitionMap(Configuration config, String locale) {
        AttributeDefinition[] ad;
        HashMap<String, MetatypePropertyDescriptor> adMap = new HashMap<String, MetatypePropertyDescriptor>();
        ObjectClassDefinition ocd = this.getObjectClassDefinition(config, locale);
        if (ocd != null && (ad = ocd.getAttributeDefinitions(-1)) != null) {
            for (int i = 0; i < ad.length; ++i) {
                adMap.put(ad[i].getID(), new MetatypePropertyDescriptor(ad[i], false));
            }
        }
        return adMap;
    }

    void mergeWithMetaType(Dictionary props, ObjectClassDefinition ocd, JSONWriter json) throws JSONException {
        List<AttributeDefinition> optional;
        json.key("title").value((Object)ocd.getName());
        if (ocd.getDescription() != null) {
            json.key("description").value((Object)ocd.getDescription());
        }
        AttributeDefinition[] ad = ocd.getAttributeDefinitions(-1);
        AttributeDefinition[] optionalArray = ocd.getAttributeDefinitions(2);
        List<AttributeDefinition> list = optional = optionalArray == null ? Collections.EMPTY_LIST : Arrays.asList(optionalArray);
        if (ad != null) {
            json.key("properties").object();
            for (int i = 0; i < ad.length; ++i) {
                AttributeDefinition adi = ad[i];
                String attrId = adi.getID();
                json.key(attrId);
                boolean isOptional = optional.contains(adi);
                MetaTypeServiceSupport.attributeToJson(json, new MetatypePropertyDescriptor(adi, isOptional), props.get(attrId));
            }
            json.endObject();
        }
    }

    private static interface IdGetter {
        public String[] getIds(MetaTypeInformation var1);
    }
}

