/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.apache.felix.webconsole.internal.servlet.Password;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

class ConfigurationSupport
implements ManagedService {
    protected final OsgiManager osgiManager;

    ConfigurationSupport(OsgiManager osgiManager) {
        this.osgiManager = osgiManager;
    }

    public void updated(final Dictionary config) throws ConfigurationException {
        if (null != System.getSecurityManager()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ConfigurationSupport.this.updated0(config);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception x = e.getException();
                if (x instanceof ConfigurationException) {
                    throw (ConfigurationException)x;
                }
                throw new ConfigurationException("?", "Update failed", (Throwable)x);
            }
        } else {
            this.updated0(config);
        }
    }

    void updated0(Dictionary config) throws ConfigurationException {
        if (this.isPasswordHashed(config)) {
            this.osgiManager.updateConfiguration(config);
        } else {
            ConfigurationAdmin ca;
            BundleContext bc = this.osgiManager.getBundleContext();
            ServiceReference ref = bc.getServiceReference(ConfigurationAdmin.class.getName());
            if (ref != null && (ca = (ConfigurationAdmin)bc.getService(ref)) != null) {
                try {
                    Configuration cfg = ca.getConfiguration(this.osgiManager.getConfigurationPid());
                    Dictionary newConfig = cfg.getProperties();
                    if (newConfig != null) {
                        String pwd = (String)config.get("password");
                        String hashedPassword = Password.hashPassword(pwd);
                        newConfig.put("password", hashedPassword);
                        cfg.update(newConfig);
                    }
                }
                catch (Exception e) {
                    throw new ConfigurationException("password", "Cannot update password property", (Throwable)e);
                }
                finally {
                    bc.ungetService(ref);
                }
            }
        }
    }

    private boolean isPasswordHashed(Dictionary config) {
        if (config == null) {
            return true;
        }
        Object pwd = config.get("password");
        return pwd instanceof String && Password.isPasswordHashed((String)pwd);
    }
}

