/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.DefaultBrandingPlugin;
import org.osgi.framework.BundleContext;

public abstract class AbstractWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_FILEUPLOAD = "org.apache.felix.webconsole.fileupload";
    public static final String GET_RESOURCE_METHOD_NAME = "getResource";
    private Method getResourceMethod;
    private boolean getResourceMethodChecked;
    private BundleContext bundleContext;
    private String adminTitle;
    private static BrandingPlugin brandingPlugin = DefaultBrandingPlugin.getInstance();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;

    public String getServletName() {
        return this.getTitle();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.spoolResource(request, response)) {
            if (this.isHtmlRequest(request)) {
                PrintWriter pw = this.startResponse(request, response);
                this.renderTopNavigation(request, pw);
                pw.println("<div id='content'>");
                this.renderContent(request, response);
                pw.println("</div>");
                this.endResponse(pw);
            } else {
                this.renderContent(request, response);
            }
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return true;
    }

    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        Dictionary headers = bundleContext.getBundle().getHeaders();
        this.adminTitle = (String)headers.get("Bundle-Name");
    }

    public void deactivate() {
        this.bundleContext = null;
    }

    public abstract String getTitle();

    public abstract String getLabel();

    protected abstract void renderContent(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected String[] getCssReferences() {
        return null;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected Object getResourceProvider() {
        return this;
    }

    private Method getGetResourceMethod() {
        if (this.getResourceMethodChecked) {
            return this.getResourceMethod;
        }
        Method tmpGetResourceMethod = null;
        Object resourceProvider = this.getResourceProvider();
        if (resourceProvider != null) {
            try {
                block2: for (Class<?> cl = resourceProvider.getClass(); tmpGetResourceMethod == null && cl != (class$java$lang$Object == null ? AbstractWebConsolePlugin.class$("java.lang.Object") : class$java$lang$Object); cl = cl.getSuperclass()) {
                    Method[] methods = cl.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        int mod;
                        Method m = methods[i];
                        if (!GET_RESOURCE_METHOD_NAME.equals(m.getName()) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != (class$java$lang$String == null ? AbstractWebConsolePlugin.class$("java.lang.String") : class$java$lang$String) || m.getReturnType() != (class$java$net$URL == null ? AbstractWebConsolePlugin.class$("java.net.URL") : class$java$net$URL) || !Modifier.isProtected(mod = m.getModifiers()) && !Modifier.isPublic(mod) && (!Modifier.isPrivate(mod) || cl != resourceProvider.getClass())) continue;
                        m.setAccessible(true);
                        tmpGetResourceMethod = m;
                        continue block2;
                    }
                }
            }
            catch (Throwable t) {
                tmpGetResourceMethod = null;
            }
        }
        this.getResourceMethod = tmpGetResourceMethod;
        this.getResourceMethodChecked = true;
        return this.getResourceMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean spoolResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Method getResourceMethod = this.getGetResourceMethod();
        if (getResourceMethod == null) {
            return false;
        }
        String pi = request.getPathInfo();
        InputStream ins = null;
        try {
            int rd;
            URL url = (URL)getResourceMethod.invoke(this.getResourceProvider(), pi);
            if (url == null) {
                boolean bl = false;
                return bl;
            }
            URLConnection connection = url.openConnection();
            ins = connection.getInputStream();
            long lastModified = connection.getLastModified();
            if (lastModified > 0L) {
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince >= lastModified / 1000L * 1000L) {
                    response.setStatus(304);
                    boolean bl = true;
                    return bl;
                }
                response.setDateHeader("Last-Modified", lastModified);
            }
            response.setContentType(this.getServletContext().getMimeType(pi));
            response.setIntHeader("Content-Length", connection.getContentLength());
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[2048];
            while ((rd = ins.read(buf)) >= 0) {
                out.write(buf, 0, rd);
            }
            boolean bl = true;
            return bl;
        }
        catch (IllegalAccessException iae) {
            return false;
        }
        catch (InvocationTargetException ite) {
            return false;
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected PrintWriter startResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        String header = MessageFormat.format(this.getHeader(), this.adminTitle, this.getTitle(), appRoot, this.getLabel(), brandingPlugin.getFavIcon(), brandingPlugin.getMainStyleSheet(), brandingPlugin.getProductURL(), brandingPlugin.getProductName(), brandingPlugin.getProductImage(), this.getCssLinks(appRoot));
        pw.println(header);
        return pw;
    }

    protected void renderTopNavigation(HttpServletRequest request, PrintWriter pw) {
        boolean linkToCurrent = true;
        String current = request.getPathInfo();
        int slash = current.indexOf("/", 1);
        if (slash < 0) {
            slash = current.length();
            linkToCurrent = false;
        }
        current = current.substring(1, slash);
        boolean disabled = false;
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Map labelMap = (Map)request.getAttribute("felix.webconsole.labelMap");
        if (labelMap != null) {
            TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            Iterator ri = labelMap.entrySet().iterator();
            while (ri.hasNext()) {
                Map.Entry labelMapEntry = ri.next();
                if (labelMapEntry.getKey() == null) continue;
                if (disabled || current.equals(labelMapEntry.getKey())) {
                    if (linkToCurrent) {
                        map.put(labelMapEntry.getValue(), "<a class='technavat' href='" + appRoot + "/" + labelMapEntry.getKey() + "'>" + labelMapEntry.getValue() + "</a>");
                        continue;
                    }
                    map.put(labelMapEntry.getValue(), "<span class='technavat'>" + labelMapEntry.getValue() + "</span>");
                    continue;
                }
                map.put(labelMapEntry.getValue(), "<a href='" + appRoot + "/" + labelMapEntry.getKey() + "'>" + labelMapEntry.getValue() + "</a>");
            }
            pw.println("<div id='technav'>");
            Iterator li = map.values().iterator();
            while (li.hasNext()) {
                pw.print("<div class='technavitem'>");
                pw.print(li.next());
                pw.println("</div>");
            }
            pw.println("</div>");
        }
    }

    protected void endResponse(PrintWriter pw) {
        pw.println(this.getFooter());
    }

    public static String getParameter(HttpServletRequest request, String name) {
        FileItem[] param;
        if (!ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(request))) {
            return request.getParameter(name);
        }
        HashMap<String, FileItem[]> params = (HashMap<String, FileItem[]>)request.getAttribute(ATTR_FILEUPLOAD);
        if (params == null) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(256000);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(-1L);
            params = new HashMap<String, FileItem[]>();
            try {
                List items = upload.parseRequest(request);
                Iterator fiter = items.iterator();
                while (fiter.hasNext()) {
                    FileItem fi = (FileItem)fiter.next();
                    FileItem[] current = (FileItem[])params.get(fi.getFieldName());
                    if (current == null) {
                        current = new FileItem[]{fi};
                    } else {
                        FileItem[] newCurrent = new FileItem[current.length + 1];
                        System.arraycopy(current, 0, newCurrent, 0, current.length);
                        newCurrent[current.length] = fi;
                        current = newCurrent;
                    }
                    params.put(fi.getFieldName(), current);
                }
            }
            catch (FileUploadException fue) {
                // empty catch block
            }
            request.setAttribute(ATTR_FILEUPLOAD, params);
        }
        if ((param = (FileItem[])params.get(name)) != null) {
            for (int i = 0; i < param.length; ++i) {
                if (!param[i].isFormField()) continue;
                return param[i].getString();
            }
        }
        return null;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        if (!redirectUrl.startsWith("/")) {
            String base = request.getContextPath() + request.getServletPath() + request.getPathInfo();
            int i = base.lastIndexOf(47);
            if (i > -1) {
                base = base.substring(0, i);
            } else {
                i = base.indexOf(58);
                String string = base = i > -1 ? base.substring(i + 1, base.length()) : "";
            }
            if (!base.startsWith("/")) {
                base = '/' + base;
            }
            redirectUrl = base + '/' + redirectUrl;
        }
        response.sendRedirect(redirectUrl);
    }

    public static BrandingPlugin getBrandingPlugin() {
        return brandingPlugin;
    }

    public static void setBrandingPlugin(BrandingPlugin brandingPlugin) {
        AbstractWebConsolePlugin.brandingPlugin = brandingPlugin == null ? DefaultBrandingPlugin.getInstance() : brandingPlugin;
    }

    private String getHeader() {
        String header = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\">  <head>    <meta http-equiv=\"Content-Type\" content=\"text/html; utf-8\">    <link rel=\"icon\" href=\"{2}{4}\">    <title>{0} - {1}</title>    <link href=\"{2}/res/ui/admin.css\" rel=\"stylesheet\" type=\"text/css\">    <link href=\"{2}{5}\" rel=\"stylesheet\" type=\"text/css\">    {9}    <script language=\"JavaScript\">      appRoot = \"{2}\";      pluginRoot = \"{2}/{3}\";    </script>    <script src=\"{2}/res/ui/jquery-1.3.2.min.js\" language=\"JavaScript\"></script>    <script src=\"{2}/res/ui/jquery.tablesorter-2.0.3.min.js\" language=\"JavaScript\"></script>    <script src=\"{2}/res/ui/admin.js\" language=\"JavaScript\"></script>    <script src=\"{2}/res/ui/ui.js\" language=\"JavaScript\"></script>  </head>  <body>    <div id=\"main\">      <div id=\"lead\">        <h1>          {0}<br>{1}        </h1>        <p>          <a target=\"_blank\" href=\"{6}\" title=\"{7}\"><img src=\"{2}{8}\" border=\"0\"></a>        </p>      </div>";
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\">  <head>    <meta http-equiv=\"Content-Type\" content=\"text/html; utf-8\">    <link rel=\"icon\" href=\"{2}{4}\">    <title>{0} - {1}</title>    <link href=\"{2}/res/ui/admin.css\" rel=\"stylesheet\" type=\"text/css\">    <link href=\"{2}{5}\" rel=\"stylesheet\" type=\"text/css\">    {9}    <script language=\"JavaScript\">      appRoot = \"{2}\";      pluginRoot = \"{2}/{3}\";    </script>    <script src=\"{2}/res/ui/jquery-1.3.2.min.js\" language=\"JavaScript\"></script>    <script src=\"{2}/res/ui/jquery.tablesorter-2.0.3.min.js\" language=\"JavaScript\"></script>    <script src=\"{2}/res/ui/admin.js\" language=\"JavaScript\"></script>    <script src=\"{2}/res/ui/ui.js\" language=\"JavaScript\"></script>  </head>  <body>    <div id=\"main\">      <div id=\"lead\">        <h1>          {0}<br>{1}        </h1>        <p>          <a target=\"_blank\" href=\"{6}\" title=\"{7}\"><img src=\"{2}{8}\" border=\"0\"></a>        </p>      </div>";
    }

    private String getFooter() {
        String footer = "    </div>  </body></html>";
        return "    </div>  </body></html>";
    }

    private String getCssLinks(String appRoot) {
        String[] cssRefs = this.getCssReferences();
        if (cssRefs == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cssRefs.length; ++i) {
            buf.append("<link href='");
            String cssRef = cssRefs[i];
            if (cssRef.startsWith("/")) {
                buf.append(appRoot);
            }
            buf.append(cssRef).append("' rel='stylesheet' type='text/css'>");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

