/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class Util {
    public static final String PAGE_WEBAPPS = "/webapps";
    public static final String PAGE_VM_STAT = "/vmstat";
    public static final String PAGE_LOGS = "/logs";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_SHUTDOWN = "shutdown";
    public static final String VALUE_SHUTDOWN = "shutdown";
    private static final Comparator BUNDLE_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.compare((Bundle)o1, (Bundle)o2);
        }

        public int compare(Bundle b1, Bundle b2) {
            Version v2;
            if (b1 == b2 || b1.getBundleId() == b2.getBundleId()) {
                return 0;
            }
            if (b1.getBundleId() == 0L) {
                return -1;
            }
            if (b2.getBundleId() == 0L) {
                return 1;
            }
            int snComp = Util.getName(b1).compareToIgnoreCase(Util.getName(b2));
            if (snComp != 0) {
                return snComp;
            }
            Version v1 = Version.parseVersion((String)((String)b1.getHeaders().get("Bundle-Version")));
            int vComp = v1.compareTo((Object)(v2 = Version.parseVersion((String)((String)b2.getHeaders().get("Bundle-Version")))));
            if (vComp != 0) {
                return vComp;
            }
            if (b1.getBundleId() < b2.getBundleId()) {
                return -1;
            }
            return 1;
        }
    };
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$Util;

    public static void startScript(PrintWriter pw) {
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
    }

    public static void endScript(PrintWriter pw) {
        pw.println("// ]]>");
        pw.println("</script>");
    }

    public static void script(PrintWriter pw, String appRoot, String scriptName) {
        pw.println("<script src='" + appRoot + "/res/ui/" + scriptName + "' language='JavaScript'></script>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spool(String res, HttpServletResponse resp) throws IOException {
        InputStream ins = Util.getResource(res);
        if (ins != null) {
            try {
                IOUtils.copy((InputStream)ins, (OutputStream)resp.getOutputStream());
            }
            finally {
                IOUtils.closeQuietly((InputStream)ins);
            }
        }
    }

    private static InputStream getResource(String resource) {
        return (class$org$apache$felix$webconsole$internal$Util == null ? (class$org$apache$felix$webconsole$internal$Util = Util.class$("org.apache.felix.webconsole.internal.Util")) : class$org$apache$felix$webconsole$internal$Util).getResourceAsStream(resource);
    }

    public static String getName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        if ((name == null || name.length() == 0) && (name = bundle.getSymbolicName()) == null && (name = bundle.getLocation()) == null) {
            name = String.valueOf(bundle.getBundleId());
        }
        return name;
    }

    public static void sort(Bundle[] bundles) {
        Arrays.sort(bundles, BUNDLE_NAME_COMPARATOR);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

