/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.system;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.BaseManagementPlugin;

public class VMStatRender
extends BaseManagementPlugin
implements Render {
    public static final String NAME = "vmstat";
    public static final String LABEL = "System Information";
    private static final long startDate = new Date().getTime();

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return LABEL;
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        pw.println("");
        boolean shutdown = false;
        String target = request.getRequestURI();
        if (request.getParameter("shutdown") != null) {
            target = "shutdown";
            shutdown = true;
        }
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Start Level Information:</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>System Start Level</td>");
        pw.println("<td class='content'>");
        pw.println("<form method='post'>");
        pw.println("<input type='hidden' name='action' value='setStartLevel'>");
        pw.println("<input class='input' type='text' size='3' name='systemStartLevel' value='" + this.getStartLevel().getStartLevel() + "'/>");
        pw.println("&nbsp;&nbsp;<input class='submit' type='submit' name='Set Start Level' value='Change'>");
        pw.println("</form>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Default Bundle Start Level</td>");
        pw.println("<td class='content'>");
        pw.println("<form method='post'>");
        pw.println("<input type='hidden' name='action' value='setStartLevel'>");
        pw.println("<input class='input' type='text' size='3' name='bundleStartLevel' value='" + this.getStartLevel().getInitialBundleStartLevel() + "'/>");
        pw.println("&nbsp;&nbsp;<input class='submit' type='submit' name='Set Start Level' value='Change'>");
        pw.println("</form>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td colspan='2' class='content'>&nbsp;</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Server Information:</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Last Started</td>");
        pw.println("<td class='content'>");
        pw.println("<script language='JavaScript'>");
        pw.println("localDate(" + startDate + ")");
        pw.println("</script>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<form name='shutdownform' method='post' action='" + target + "'>");
        pw.println("<td class='content'>Server</td>");
        pw.println("<td class='content'>");
        if (!shutdown) {
            pw.println("<input type='hidden' name='shutdown' value='shutdown'>");
            pw.println("<input class='submit important' type='submit' value='Stop' onclick=\"return confirm('This will terminate all running applications. Do you want to stop the server?')\">");
        } else {
            pw.println("<input class='submit important' type='button' value='Abort' onclick=\"abort('" + request.getRequestURI() + "')\">&nbsp;");
            pw.println("<input type='hidden' name='action' value='shutdown'>");
            pw.println("Shutdown in <span id='countdowncell'>&nbsp;</span>");
            pw.println("<script language='JavaScript'>");
            pw.println("shutdown(3, 'shutdownform', 'countdowncell');");
            pw.println("</script>");
        }
        pw.println("</td>");
        pw.println("</form>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td colspan='2' class='content'>&nbsp;</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Java Information:</th>");
        pw.println("</tr>");
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
        long usedMem = totalMem - freeMem;
        this.infoLine(pw, "Java Runtime", System.getProperty("java.runtime.name") + "(build " + System.getProperty("java.runtime.version") + ")");
        this.infoLine(pw, "Java Virtual Machine", System.getProperty("java.vm.name") + "(build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")");
        this.infoLine(pw, "Total Memory", totalMem + " KB");
        this.infoLine(pw, "Used Memory", usedMem + " KB");
        this.infoLine(pw, "Free Memory", freeMem + " KB");
        pw.println("<tr class='content'>");
        pw.println("<form method='post'>");
        pw.println("<td class='content'>Garbage Collection</td>");
        pw.println("<td class='content'>");
        pw.println("<input type='hidden' name='action' value='gc'>");
        pw.println("<input class='submit' type='submit' name='Collect Garbage' value='Run'>");
        pw.println("</form></td></tr>");
        pw.println("</table>");
    }

    private void infoLine(PrintWriter pw, String label, String value) {
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>" + label + "</td>");
        pw.println("<td class='content'>");
        pw.println(value);
        pw.println("</td></tr>");
    }
}

