/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public class MultiplePrototypeRefPair<S, T>
extends RefPair<S, T> {
    private final ServiceObjects<T> serviceObjects;
    private final ConcurrentMap<ComponentContextImpl<S>, T> instances = new ConcurrentHashMap<ComponentContextImpl<S>, T>();

    public MultiplePrototypeRefPair(BundleContext context, ServiceReference<T> ref) {
        super(ref);
        this.serviceObjects = context.getServiceObjects(ref);
    }

    @Override
    public ServiceObjects<T> getServiceObjects() {
        return this.serviceObjects;
    }

    @Override
    public T getServiceObject(ComponentContextImpl<S> key) {
        return (T)this.instances.get(key);
    }

    @Override
    public boolean setServiceObject(ComponentContextImpl<S> key, T serviceObject) {
        return this.instances.putIfAbsent(key, serviceObject) == null;
    }

    @Override
    public T unsetServiceObject(ComponentContextImpl<S> key) {
        return (T)this.instances.get(key);
    }

    public String toString() {
        return "[MultiplePrototypeRefPair: ref: [" + this.getRef() + "] has service: [" + !this.instances.isEmpty() + "]]";
    }

    @Override
    public boolean getServiceObject(ComponentContextImpl<S> key, BundleContext context) {
        Object service = key.getComponentServiceObjectsHelper().getPrototypeRefInstance(this.getRef(), this.serviceObjects);
        if (service == null) {
            this.setFailed();
            key.getLogger().log(2, "Could not get service from serviceobjects for ref {0}", null, this.getRef());
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            this.serviceObjects.ungetService(service);
        }
        return true;
    }
}

