/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentContainer;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.ComponentManager;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.ReferenceManager;
import org.apache.felix.scr.impl.manager.RegistrationManager;
import org.apache.felix.scr.impl.manager.ThreadDump;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentManager<S>
implements SimpleLogger,
ComponentManager<S> {
    static final String[] REASONS = new String[]{"Unspecified", "Component disabled", "Reference became unsatisfied", "Configuration modified", "Configuration deleted", "Component disabled", "Bundle stopped"};
    protected final ComponentContainer<S> m_container;
    protected final boolean m_factoryInstance;
    private long m_componentId;
    private final ComponentMethods m_componentMethods;
    private final List<DependencyManager<S, ?>> m_dependencyManagers;
    private volatile boolean m_dependencyManagersInitialized;
    private final AtomicInteger m_trackingCount = new AtomicInteger();
    private final ReentrantLock m_stateLock;
    private final AtomicReference<Deferred<Void>> m_enabledLatchRef = new AtomicReference(new Deferred());
    private final AtomicReference<State> state = new AtomicReference<State>(State.disabled);
    private int m_floor;
    private volatile int m_ceiling;
    private final Lock m_missingLock = new ReentrantLock();
    private final Condition m_missingCondition = this.m_missingLock.newCondition();
    private final Set<Integer> m_missing = new TreeSet<Integer>();
    protected final ReentrantReadWriteLock m_activationLock = new ReentrantReadWriteLock();
    private static final AtomicLong taskCounter = new AtomicLong();
    private final RegistrationManager<ServiceRegistration<S>> registrationManager = new RegistrationManager<ServiceRegistration<S>>(){

        @Override
        ServiceRegistration<S> register(String[] services) {
            BundleContext bundleContext = AbstractComponentManager.this.getBundleContext();
            if (bundleContext == null) {
                return null;
            }
            Dictionary<String, Object> serviceProperties = AbstractComponentManager.this.getServiceProperties();
            try {
                ServiceRegistration serviceRegistration = bundleContext.registerService(services, AbstractComponentManager.this.getService(), serviceProperties);
                return serviceRegistration;
            }
            catch (ServiceException e) {
                this.log(1, "Unexpected error registering component service with properties {0}", new Object[]{serviceProperties}, e);
                return null;
            }
        }

        @Override
        void postRegister(ServiceRegistration<S> t) {
            AbstractComponentManager.this.postRegister();
        }

        @Override
        void unregister(ServiceRegistration<S> serviceRegistration) {
            AbstractComponentManager.this.preDeregister();
            serviceRegistration.unregister();
        }

        @Override
        void log(int level, String message, Object[] arguments, Throwable ex) {
            AbstractComponentManager.this.log(level, message, arguments, ex);
        }

        @Override
        long getTimeout() {
            return AbstractComponentManager.this.getLockTimeout();
        }

        @Override
        void reportTimeout() {
            AbstractComponentManager.this.dumpThreads();
        }
    };

    protected AbstractComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods) {
        this(container, componentMethods, false);
    }

    protected AbstractComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods, boolean factoryInstance) {
        this.m_enabledLatchRef.get().resolve(null);
        this.m_factoryInstance = factoryInstance;
        this.m_container = container;
        this.m_componentMethods = componentMethods;
        this.m_componentId = -1L;
        ComponentMetadata metadata = container.getComponentMetadata();
        this.m_dependencyManagers = this.loadDependencyManagers(metadata);
        this.m_stateLock = new ReentrantLock(true);
        if (this.isLogEnabled(4)) {
            this.log(4, "Component {0} created: DS={1}, implementation={2}, immediate={3}, default-enabled={4}, factory={5}, configuration-policy={6}, activate={7}, deactivate={8}, modified={9} configuration-pid={10}", new Object[]{metadata.getName(), metadata.getDSVersion(), metadata.getImplementationClassName(), metadata.isImmediate(), metadata.isEnabled(), metadata.getFactoryIdentifier(), metadata.getConfigurationPolicy(), metadata.getActivate(), metadata.getDeactivate(), metadata.getModified(), metadata.getConfigurationPid()}, null);
            if (metadata.getServiceMetadata() != null) {
                this.log(4, "Component {0} Services: scope={1}, services={2}", new Object[]{metadata.getName(), metadata.getServiceScope(), Arrays.asList(metadata.getServiceMetadata().getProvides())}, null);
            }
            if (metadata.getProperties() != null) {
                this.log(4, "Component {0} Properties: {1}", new Object[]{metadata.getName(), metadata.getProperties()}, null);
            }
        }
    }

    final long getLockTimeout() {
        ComponentActivator activator = this.getActivator();
        if (activator != null && activator.getConfiguration() != null) {
            return activator.getConfiguration().lockTimeout();
        }
        return 5000L;
    }

    private void obtainLock(Lock lock) {
        try {
            if (!lock.tryLock(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                this.dumpThreads();
                throw new IllegalStateException("Could not obtain lock");
            }
        }
        catch (InterruptedException e) {
            try {
                if (!lock.tryLock(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                    this.dumpThreads();
                    throw new IllegalStateException("Could not obtain lock");
                }
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted twice: Could not obtain lock");
            }
            Thread.currentThread().interrupt();
        }
    }

    final void obtainActivationReadLock() {
        this.obtainLock(this.m_activationLock.readLock());
    }

    final void releaseActivationReadLock() {
        this.m_activationLock.readLock().unlock();
    }

    final void obtainActivationWriteLock() {
        this.obtainLock(this.m_activationLock.writeLock());
    }

    final void releaseActivationWriteeLock() {
        if (this.m_activationLock.getWriteHoldCount() > 0) {
            this.m_activationLock.writeLock().unlock();
        }
    }

    final void obtainStateLock() {
        this.obtainLock(this.m_stateLock);
    }

    final void releaseStateLock() {
        this.m_stateLock.unlock();
    }

    final boolean isStateLocked() {
        return this.m_stateLock.getHoldCount() > 0;
    }

    final void dumpThreads() {
        try {
            String dump = new ThreadDump().call();
            this.log(4, dump, null);
        }
        catch (Throwable t) {
            this.log(4, "Could not dump threads", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tracked(int trackingCount) {
        this.m_missingLock.lock();
        try {
            if (trackingCount == this.m_floor + 1) {
                ++this.m_floor;
                this.m_missing.remove(trackingCount);
            } else if (trackingCount < this.m_ceiling) {
                this.m_missing.remove(trackingCount);
            }
            if (trackingCount > this.m_ceiling) {
                for (int i = this.m_ceiling + 1; i < trackingCount; ++i) {
                    this.m_missing.add(i);
                }
                this.m_ceiling = trackingCount;
            }
            this.m_missingCondition.signalAll();
        }
        finally {
            this.m_missingLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    void waitForTracked(int trackingCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean doMissingWait() throws InterruptedException {
        if (!this.m_missingCondition.await(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
            this.log(1, "waitForTracked timed out: {0} ceiling: {1} missing: {2},  Expect further errors", new Object[]{this.m_trackingCount, this.m_ceiling, this.m_missing}, null);
            this.dumpThreads();
            this.m_missing.clear();
            return false;
        }
        return true;
    }

    void registerComponentId() {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            this.m_componentId = activator.registerComponentId(this);
        }
    }

    void unregisterComponentId() {
        if (this.m_componentId >= 0L) {
            ComponentActivator activator = this.getActivator();
            if (activator != null) {
                activator.unregisterComponentId(this);
            }
            this.m_componentId = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Promise<Void> enable(boolean async) {
        Deferred<Void> enableLatch = null;
        try {
            enableLatch = this.enableLatchWait();
            if (!async) {
                this.enableInternal();
            }
        }
        finally {
            if (!async) {
                enableLatch.resolve(null);
            }
        }
        if (async) {
            final Deferred<Void> latch = enableLatch;
            this.getActivator().schedule(new Runnable(){
                long count = AbstractComponentManager.access$000().incrementAndGet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AbstractComponentManager.this.enableInternal();
                    }
                    finally {
                        latch.resolve(null);
                    }
                }

                public String toString() {
                    return "Async Activate: " + AbstractComponentManager.this.getComponentMetadata().getName() + " id: " + this.count;
                }
            });
        }
        return enableLatch.getPromise();
    }

    Deferred<Void> enableLatchWait() {
        Deferred<Void> newEnabledLatch;
        Deferred<Void> enabledLatch;
        do {
            enabledLatch = this.m_enabledLatchRef.get();
            boolean waited = false;
            boolean interrupted = false;
            while (!waited) {
                try {
                    enabledLatch.getPromise().getValue();
                    waited = true;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if (!interrupted) continue;
            Thread.currentThread().interrupt();
        } while (!this.m_enabledLatchRef.compareAndSet(enabledLatch, newEnabledLatch = new Deferred<Void>()));
        return newEnabledLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Promise<Void> disable(boolean async) {
        Deferred<Void> enableLatch = null;
        try {
            enableLatch = this.enableLatchWait();
            if (!async) {
                this.disableInternal();
            }
        }
        finally {
            if (!async) {
                enableLatch.resolve(null);
            }
        }
        if (async) {
            final Deferred<Void> latch = enableLatch;
            this.getActivator().schedule(new Runnable(){
                long count = AbstractComponentManager.access$000().incrementAndGet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AbstractComponentManager.this.disableInternal();
                    }
                    finally {
                        latch.resolve(null);
                    }
                }

                public String toString() {
                    return "Async Deactivate: " + AbstractComponentManager.this.getComponentMetadata().getName() + " id: " + this.count;
                }
            });
        }
        return enableLatch.getPromise();
    }

    void dispose() {
        this.dispose(5);
    }

    public void dispose(int reason) {
        this.deactivateInternal(reason, true, true);
    }

    <T> void registerMissingDependency(DependencyManager<S, T> dm, ServiceReference<T> ref, int trackingCount) {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.registerMissingDependency(dm, ref, trackingCount);
        }
    }

    @Override
    public long getId() {
        return this.m_componentId;
    }

    protected String getName() {
        return this.getComponentMetadata().getName();
    }

    public Bundle getBundle() {
        BundleContext context = this.getBundleContext();
        if (context != null) {
            try {
                return context.getBundle();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    BundleContext getBundleContext() {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.getBundleContext();
        }
        return null;
    }

    protected boolean isImmediate() {
        return this.getComponentMetadata().isImmediate();
    }

    public boolean isFactory() {
        return false;
    }

    final void enableInternal() {
        State previousState = this.getState();
        if (previousState == State.disposed) {
            throw new IllegalStateException("enable: " + this);
        }
        if (!this.isActivatorActive()) {
            this.log(4, "Bundle's component activator is not active; not enabling component", null);
            return;
        }
        if (previousState.isEnabled()) {
            this.log(2, "enable  called but component is already in state {0}", new Object[]{previousState}, null);
            return;
        }
        this.registerComponentId();
        this.log(4, "Updating target filters", null);
        this.updateTargets(this.getProperties());
        this.setState(previousState, State.unsatisfiedReference);
        this.log(4, "Component enabled", null);
        this.activateInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activateInternal() {
        this.log(4, "ActivateInternal", null);
        State s = this.getState();
        if (s == State.disposed) {
            this.log(4, "ActivateInternal: disposed", null);
            return;
        }
        if (s == State.active) {
            this.log(4, "ActivateInternal: already activated", null);
            return;
        }
        if (!s.isEnabled()) {
            this.log(4, "Component is not enabled; not activating component", null);
            return;
        }
        if (!this.isActivatorActive()) {
            this.log(4, "Bundle's component activator is not active; not activating component", null);
            return;
        }
        this.log(4, "Activating component from state {0}", new Object[]{this.getState()}, null);
        if (!this.hasServiceRegistrationPermissions()) {
            this.log(4, "Component is not permitted to register all services, cannot activate", null);
            return;
        }
        this.obtainActivationReadLock();
        try {
            s = this.getState();
            if (s == State.disposed) {
                this.log(4, "ActivateInternal: disposed", null);
                return;
            }
            if (s == State.active) {
                this.log(4, "ActivateInternal: already activated", null);
                return;
            }
            if (!s.isEnabled()) {
                this.log(4, "Component is not enabled; not activating component", null);
                return;
            }
            if (!this.verifyDependencyManagers()) {
                this.log(4, "Not all dependencies satisfied, cannot activate", null);
                return;
            }
            if (!this.registerService()) {
                return;
            }
            if (this.isImmediate() || this.getComponentMetadata().isFactory()) {
                this.getServiceInternal(this.registrationManager.getServiceRegistration());
            }
        }
        finally {
            this.releaseActivationReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deactivateInternal(int reason, boolean disable, boolean dispose) {
        if (!this.getState().isEnabled()) {
            return;
        }
        State nextState = State.unsatisfiedReference;
        if (disable) {
            nextState = State.disabled;
        }
        if (dispose) {
            nextState = State.disposed;
        }
        this.log(4, "Deactivating component", null);
        this.obtainActivationReadLock();
        try {
            this.doDeactivate(reason, disable || this.m_factoryInstance);
            this.setState(this.getState(), nextState);
        }
        finally {
            this.releaseActivationReadLock();
        }
        if (this.isFactory() || this.m_factoryInstance || dispose) {
            this.log(4, "Disposing component (reason: " + reason + ")", null);
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeactivate(int reason, boolean disable) {
        try {
            if (!this.unregisterService()) {
                this.log(4, "Component deactivation occuring on another thread", null);
            }
            this.obtainStateLock();
            try {
                this.deleteComponent(reason);
                this.deactivateDependencyManagers();
                if (disable) {
                    this.disableDependencyManagers();
                }
            }
            finally {
                this.releaseStateLock();
            }
        }
        catch (Throwable t) {
            this.log(2, "Component deactivation threw an exception", t);
        }
    }

    final void disableInternal() {
        this.deactivateInternal(1, true, false);
        this.unregisterComponentId();
    }

    protected abstract void deleteComponent(int var1);

    boolean getServiceInternal(ServiceRegistration<S> serviceRegistration) {
        return false;
    }

    private Object getService() {
        return this;
    }

    ComponentMethods getComponentMethods() {
        return this.m_componentMethods;
    }

    protected String[] getProvidedServices() {
        if (this.getComponentMetadata().getServiceMetadata() != null) {
            String[] provides = this.getComponentMetadata().getServiceMetadata().getProvides();
            return provides;
        }
        return null;
    }

    protected boolean registerService() {
        String[] services = this.getProvidedServices();
        if (services != null) {
            return this.registrationManager.changeRegistration(RegistrationManager.RegState.registered, services);
        }
        return true;
    }

    protected boolean unregisterService() {
        String[] services = this.getProvidedServices();
        if (services != null) {
            return this.registrationManager.changeRegistration(RegistrationManager.RegState.unregistered, services);
        }
        return true;
    }

    AtomicInteger getTrackingCount() {
        return this.m_trackingCount;
    }

    private void initDependencyManagers() {
        Class implementationObjectClass;
        if (this.m_dependencyManagersInitialized) {
            return;
        }
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            this.log(1, "bundle shut down while trying to load implementation object class", null);
            throw new IllegalStateException("bundle shut down while trying to load implementation object class");
        }
        try {
            implementationObjectClass = bundle.loadClass(this.getComponentMetadata().getImplementationClassName());
        }
        catch (ClassNotFoundException e) {
            this.log(1, "Could not load implementation object class {0}", new Object[]{this.getComponentMetadata().getImplementationClassName()}, e);
            throw new IllegalStateException("Could not load implementation object class " + this.getComponentMetadata().getImplementationClassName());
        }
        this.m_componentMethods.initComponentMethods(this.getComponentMetadata(), implementationObjectClass);
        for (DependencyManager<S, ?> dependencyManager : this.m_dependencyManagers) {
            dependencyManager.initBindingMethods(this.m_componentMethods.getBindMethods(dependencyManager.getName()));
        }
        this.m_dependencyManagersInitialized = true;
    }

    protected boolean collectDependencies(ComponentContextImpl<S> componentContext) {
        this.initDependencyManagers();
        for (DependencyManager<S, ?> dependencyManager : this.m_dependencyManagers) {
            if (dependencyManager.prebind(componentContext)) continue;
            this.deactivateDependencyManagers();
            this.log(4, "Could not get required dependency for dependency manager: {0}", new Object[]{dependencyManager.getName()}, null);
            return false;
        }
        this.log(4, "This thread collected dependencies", null);
        return true;
    }

    abstract <T> boolean invokeUpdatedMethod(DependencyManager<S, T> var1, RefPair<S, T> var2, int var3);

    abstract <T> void invokeBindMethod(DependencyManager<S, T> var1, RefPair<S, T> var2, int var3);

    abstract <T> void invokeUnbindMethod(DependencyManager<S, T> var1, RefPair<S, T> var2, int var3);

    public ComponentActivator getActivator() {
        return this.m_container.getActivator();
    }

    boolean isActivatorActive() {
        ComponentActivator activator = this.getActivator();
        return activator != null && activator.isActive();
    }

    synchronized void clear() {
        if (this.m_container.getActivator() != null) {
            this.m_container.getActivator().unregisterComponentId(this);
        }
    }

    @Override
    public boolean isLogEnabled(int level) {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.isLogEnabled(level);
        }
        return false;
    }

    @Override
    public void log(int level, String message, Throwable ex) {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, this.getComponentMetadata(), this.m_componentId, ex);
        }
    }

    @Override
    public void log(int level, String message, Object[] arguments, Throwable ex) {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, arguments, this.getComponentMetadata(), this.m_componentId, ex);
        }
    }

    public String toString() {
        return "Component: " + this.getName() + " (" + this.getId() + ")";
    }

    private boolean hasServiceRegistrationPermissions() {
        String[] services;
        ServiceMetadata serviceMetadata;
        boolean allowed = true;
        if (System.getSecurityManager() != null && (serviceMetadata = this.getComponentMetadata().getServiceMetadata()) != null && (services = serviceMetadata.getProvides()) != null && services.length > 0) {
            Bundle bundle = this.getBundle();
            for (String service : services) {
                ServicePermission perm = new ServicePermission(service, "register");
                if (bundle.hasPermission((Object)perm)) continue;
                this.log(4, "Permission to register service {0} is denied", new Object[]{service}, null);
                allowed = false;
            }
        }
        return allowed;
    }

    private List<DependencyManager<S, ?>> loadDependencyManagers(ComponentMetadata metadata) {
        ArrayList depMgrList = new ArrayList(metadata.getDependencies().size());
        if (metadata.getDependencies().size() != 0) {
            int index = 0;
            for (ReferenceMetadata currentdependency : metadata.getDependencies()) {
                DependencyManager depmanager = new DependencyManager(this, currentdependency, index++);
                depMgrList.add(depmanager);
            }
        }
        return depMgrList;
    }

    final void updateTargets(Map<String, Object> properties) {
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            dm.setTargetFilter(properties);
        }
    }

    protected boolean verifyDependencyManagers() {
        State previousState = this.getState();
        boolean satisfied = true;
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            if (!dm.hasGetPermission()) {
                if (dm.isOptional()) {
                    this.log(4, "No permission to get optional dependency: {0}; assuming satisfied", new Object[]{dm.getName()}, null);
                    continue;
                }
                this.log(4, "No permission to get mandatory dependency: {0}; assuming unsatisfied", new Object[]{dm.getName()}, null);
                satisfied = false;
                continue;
            }
            if (dm.isSatisfied()) continue;
            this.log(4, "Dependency not satisfied: {0}", new Object[]{dm.getName()}, null);
            satisfied = false;
        }
        if (satisfied != previousState.isSatisfied()) {
            this.setState(previousState, satisfied ? State.satisfied : State.unsatisfiedReference);
        }
        return satisfied;
    }

    List<DependencyManager<S, ?>> getDependencyManagers() {
        return this.m_dependencyManagers;
    }

    @Override
    public List<? extends ReferenceManager<S, ?>> getReferenceManagers() {
        return this.m_dependencyManagers;
    }

    List<DependencyManager<S, ?>> getReversedDependencyManagers() {
        ArrayList list = new ArrayList(this.m_dependencyManagers);
        Collections.reverse(list);
        return list;
    }

    DependencyManager<S, ?> getDependencyManager(String name) {
        for (ReferenceManager referenceManager : this.getDependencyManagers()) {
            if (!name.equals(referenceManager.getName())) continue;
            return (DependencyManager)referenceManager;
        }
        return null;
    }

    private void deactivateDependencyManagers() {
        this.log(4, "Deactivating dependency managers", null);
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            dm.deactivate();
        }
    }

    private void disableDependencyManagers() {
        this.log(4, "Disabling dependency managers", null);
        AtomicInteger trackingCount = new AtomicInteger();
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            dm.unregisterServiceListener(trackingCount);
        }
    }

    @Override
    public abstract Map<String, Object> getProperties();

    public abstract void setServiceProperties(Dictionary<String, ?> var1);

    public Dictionary<String, Object> getServiceProperties() {
        return AbstractComponentManager.copyTo(null, this.getProperties(), false);
    }

    protected static Dictionary<String, Object> copyTo(Dictionary<String, Object> target, Map<String, ?> source, boolean allProps) {
        if (target == null) {
            target = new Hashtable<String, Object>();
        }
        if (source != null && !source.isEmpty()) {
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                String key = entry.getKey();
                if (!allProps && key.charAt(0) == '.') continue;
                target.put(key, entry.getValue());
            }
        }
        return target;
    }

    protected static Map<String, Object> copyToMap(Dictionary<String, ?> source, boolean allProps) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        if (source != null && !source.isEmpty()) {
            Enumeration<String> ce = source.keys();
            while (ce.hasMoreElements()) {
                String key = ce.nextElement();
                if (!allProps && key.charAt(0) == '.') continue;
                target.put(key, source.get(key));
            }
        }
        return target;
    }

    protected static Dictionary<String, Object> copyToDictionary(Dictionary<String, ?> source, boolean allProps) {
        Hashtable<String, Object> target = new Hashtable<String, Object>();
        if (source != null && !source.isEmpty()) {
            Enumeration<String> ce = source.keys();
            while (ce.hasMoreElements()) {
                String key = ce.nextElement();
                if (!allProps && key.charAt(0) == '.') continue;
                target.put(key, source.get(key));
            }
        }
        return target;
    }

    public ComponentMetadata getComponentMetadata() {
        return this.m_container.getComponentMetadata();
    }

    @Override
    public int getSpecState() {
        return this.getState().getSpecState();
    }

    State getState() {
        State s = this.state.get();
        this.log(4, "Querying state {0}", new Object[]{s}, null);
        return s;
    }

    void setState(State previousState, State newState) {
        if (this.state.compareAndSet(previousState, newState)) {
            this.log(4, "Changed state from {0} to {1}", new Object[]{previousState, newState}, null);
        } else {
            this.log(4, "Did not change state from {0} to {1}: current state {2}", new Object[]{previousState, newState, this.state.get()}, null);
        }
    }

    abstract boolean hasInstance();

    public void setServiceProperties(MethodResult methodResult, Integer trackingCount) {
        if (methodResult.hasResult()) {
            if (trackingCount != null) {
                this.tracked(trackingCount);
            }
            Hashtable<String, Object> serviceProps = methodResult.getResult() == null ? null : new Hashtable<String, Object>(methodResult.getResult());
            this.setServiceProperties(serviceProps);
        }
    }

    abstract void postRegister();

    abstract void preDeregister();

    public abstract void reconfigure(Map<String, Object> var1, boolean var2);

    public abstract void getComponentManagers(List<AbstractComponentManager<S>> var1);

    static /* synthetic */ AtomicLong access$000() {
        return taskCounter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        disposed(-1, false, false, false),
        disabled(-1, false, false, false),
        unsatisfiedReference(2, true, false, false),
        satisfied(4, true, true, false),
        active(8, true, true, true);

        private final int specState;
        private final boolean enabled;
        private final boolean satisfed;
        private final boolean actve;

        private State(int specState, boolean enabled, boolean satisfied, boolean active) {
            this.specState = specState;
            this.enabled = enabled;
            this.satisfed = satisfied;
            this.actve = active;
        }

        public int getSpecState() {
            return this.specState;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isSatisfied() {
            return this.satisfed;
        }

        public boolean isActive() {
            return this.actve;
        }
    }
}

