/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class TargetedPID {
    private final String rawPid;
    private final String servicePid;
    private final String symbolicName;
    private final String version;
    private final String location;
    private final short bindingLevel;

    public static String getBundleVersion(Bundle bundle) {
        Object vHeader = bundle.getHeaders().get("Bundle-Version");
        Version version = vHeader == null ? Version.emptyVersion : new Version(vHeader.toString());
        return version.toString();
    }

    public TargetedPID(String rawPid) {
        this.rawPid = rawPid;
        if (rawPid.indexOf(124) < 0) {
            this.servicePid = rawPid;
            this.symbolicName = null;
            this.version = null;
            this.location = null;
            this.bindingLevel = 0;
        } else {
            int start = 0;
            int end = rawPid.indexOf(124);
            this.servicePid = rawPid.substring(start, end);
            start = end + 1;
            if ((end = rawPid.indexOf(124, start)) >= 0) {
                this.symbolicName = rawPid.substring(start, end);
                start = end + 1;
                if ((end = rawPid.indexOf(124, start)) >= 0) {
                    this.version = rawPid.substring(start, end);
                    this.location = rawPid.substring(end + 1);
                    this.bindingLevel = (short)3;
                } else {
                    this.version = rawPid.substring(start);
                    this.location = null;
                    this.bindingLevel = (short)2;
                }
            } else {
                this.symbolicName = rawPid.substring(start);
                this.version = null;
                this.location = null;
                this.bindingLevel = 1;
            }
        }
    }

    public boolean matchesTarget(Bundle serviceBundle) {
        if (serviceBundle == null) {
            return false;
        }
        if (this.symbolicName == null) {
            return true;
        }
        if (!this.symbolicName.equals(serviceBundle.getSymbolicName())) {
            return false;
        }
        if (this.version == null) {
            return true;
        }
        if (!this.version.equals(TargetedPID.getBundleVersion(serviceBundle))) {
            return false;
        }
        return this.location == null || this.location.equals(serviceBundle.getLocation());
    }

    public String getRawPid() {
        return this.rawPid;
    }

    public String getServicePid() {
        return this.servicePid;
    }

    public boolean bindsStronger(TargetedPID other) {
        return other == null || this.bindingLevel > other.bindingLevel;
    }

    public int hashCode() {
        return this.rawPid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            return this.rawPid.equals(((TargetedPID)obj).rawPid);
        }
        return false;
    }

    public String toString() {
        return this.rawPid;
    }
}

