/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.LinkedList;
import org.apache.felix.scr.impl.helper.SimpleLogger;

class ComponentActorThread
implements Runnable {
    private static final Runnable TERMINATION_TASK = new Runnable(){

        public void run() {
        }

        public String toString() {
            return "Component Actor Terminator";
        }
    };
    private LinkedList<Runnable> tasks = new LinkedList();
    private SimpleLogger logger;

    ComponentActorThread(SimpleLogger log) {
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logger.log(4, "Starting ComponentActorThread", null);
        while (true) {
            Runnable task;
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                while (this.tasks.isEmpty()) {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                task = this.tasks.removeFirst();
            }
            try {
                if (task == TERMINATION_TASK) {
                    this.logger.log(4, "Shutting down ComponentActorThread", null);
                    return;
                }
                this.logger.log(4, "Running task: " + task, null);
                task.run();
                continue;
            }
            catch (Throwable t) {
                this.logger.log(1, "Unexpected problem executing task " + task, t);
                continue;
            }
            finally {
                linkedList = this.tasks;
                synchronized (linkedList) {
                    this.tasks.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.schedule(TERMINATION_TASK);
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            while (!this.tasks.isEmpty()) {
                try {
                    this.tasks.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.log(1, "Interrupted exception waiting for queue to empty", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable task) {
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            this.logger.log(4, "Adding task [{0}] as #{1} in the queue", new Object[]{task, this.tasks.size()}, null);
            this.tasks.notifyAll();
        }
    }
}

