/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.apache.felix.scr.impl.runtime.ServiceComponentRuntimeImpl;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractExtender {
    static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    static final String PACKAGEADMIN_CLASS = "org.osgi.service.packageadmin.PackageAdmin";
    private static ScrConfiguration m_configuration;
    private static BundleContext m_context;
    private static Bundle m_bundle;
    private static volatile ServiceTracker<LogService, LogService> m_logService;
    private static volatile ServiceTracker<?, ?> m_packageAdmin;
    private Map<Long, BundleComponentActivator> m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;
    private ServiceRegistration<?> m_runtime_reg;
    private ScrCommand m_scrCommand;

    public Activator() {
        m_configuration = new ScrConfiguration(this);
        this.setSynchronous(true);
    }

    public void start(BundleContext context) throws Exception {
        m_context = context;
        m_bundle = context.getBundle();
        m_logService = new ServiceTracker(m_context, LOGSERVICE_CLASS, null);
        m_logService.open();
        m_configuration.start(m_context);
    }

    public void restart(boolean globalExtender) {
        BundleContext context = globalExtender ? m_context.getBundle(0L).getBundleContext() : m_context;
        if (m_packageAdmin != null) {
            Activator.log(3, m_bundle, "Stopping to restart with new globalExtender setting: " + globalExtender, null);
            try {
                super.stop(context);
            }
            catch (Exception e) {
                Activator.log(1, m_bundle, "Exception stopping during restart", e);
            }
        }
        try {
            Activator.log(3, m_bundle, "Starting with globalExtender setting: " + globalExtender, null);
            super.start(context);
        }
        catch (Exception e) {
            Activator.log(1, m_bundle, "Exception starting during restart", e);
        }
    }

    protected void doStart() throws Exception {
        this.m_componentBundles = new HashMap<Long, BundleComponentActivator>();
        this.m_componentRegistry = new ComponentRegistry(m_context);
        ServiceComponentRuntimeImpl runtime = new ServiceComponentRuntimeImpl(m_context, this.m_componentRegistry);
        this.m_runtime_reg = m_context.registerService(ServiceComponentRuntime.class, (Object)runtime, null);
        Activator.log(3, m_bundle, " Version = {0}", new Object[]{m_bundle.getHeaders().get("Bundle-Version")}, null);
        this.m_componentActor = new ComponentActorThread();
        Thread t = new Thread((Runnable)this.m_componentActor, "SCR Component Actor");
        t.setDaemon(true);
        t.start();
        super.doStart();
        this.m_scrCommand = ScrCommand.register(m_context, runtime, m_configuration);
        m_configuration.setScrCommand(this.m_scrCommand);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        m_configuration.stop();
        m_configuration = null;
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.m_scrCommand != null) {
            this.m_scrCommand.unregister();
            this.m_scrCommand = null;
        }
        if (this.m_runtime_reg != null) {
            this.m_runtime_reg.unregister();
            this.m_runtime_reg = null;
        }
        if (this.m_componentRegistry != null) {
            this.m_componentRegistry.dispose();
            this.m_componentRegistry = null;
        }
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            this.m_componentActor = null;
        }
        if (m_logService != null) {
            m_logService.close();
            m_logService = null;
        }
        if (m_packageAdmin != null) {
            m_packageAdmin.close();
            m_packageAdmin = null;
        }
        m_context = null;
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        return new ScrExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponents(Bundle bundle) {
        boolean loaded;
        if (bundle.getHeaders().get("Service-Component") == null) {
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            Activator.log(1, m_bundle, "Cannot get BundleContext of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, null);
            return;
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List extenderWires = wiring.getRequiredWires("osgi.extender");
        try {
            for (BundleWire wire : extenderWires) {
                if (!"osgi.component".equals(wire.getCapability().getAttributes().get("osgi.extender"))) continue;
                if (((BundleRevision)m_bundle.adapt(BundleRevision.class)).equals(wire.getProvider())) break;
                Activator.log(4, m_bundle, "Bundle {0}/{1} wired to a different extender: {2}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId(), wire.getProvider().getSymbolicName()}, null);
                return;
            }
        }
        catch (NoSuchMethodError e) {
            Activator.log(4, m_bundle, "Cannot determine bundle wiring on pre R6 framework", null, null);
        }
        Long bundleId = bundle.getBundleId();
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            if (this.m_componentBundles.containsKey(bundleId)) {
                loaded = true;
            } else {
                this.m_componentBundles.put(bundleId, null);
                loaded = false;
            }
        }
        if (loaded) {
            Activator.log(4, m_bundle, "Components for bundle {0}/{1} already loaded. Nothing to do.", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, null);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this.m_componentRegistry, this.m_componentActor, context, m_configuration);
            ga.initialEnable();
            Map<Long, BundleComponentActivator> map2 = this.m_componentBundles;
            synchronized (map2) {
                this.m_componentBundles.put(bundleId, ga);
            }
        }
        catch (Exception e) {
            Map<Long, BundleComponentActivator> map3 = this.m_componentBundles;
            synchronized (map3) {
                this.m_componentBundles.remove(bundleId);
            }
            if (e instanceof IllegalStateException && bundle.getState() != 32) {
                Activator.log(4, m_bundle, "Bundle {0}/{1} has been stopped while trying to activate its components. Trying again when the bundles gets started again.", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
            }
            Activator.log(1, m_bundle, "Error while loading components of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeComponents(Bundle bundle) {
        BundleComponentActivator ga;
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            ga = this.m_componentBundles.remove(bundle.getBundleId());
        }
        if (ga != null) {
            try {
                int reason = this.isStopping() ? 5 : 6;
                ga.dispose(reason);
            }
            catch (Exception e) {
                Activator.log(1, m_bundle, "Error while disposing components of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
            }
        }
    }

    protected void debug(Bundle bundle, String msg) {
        String message = MessageFormat.format(msg + " bundle: {0}/{1}", bundle.getSymbolicName(), bundle.getBundleId());
        Activator.log(4, bundle, message, null);
    }

    protected void warn(Bundle bundle, String msg, Throwable t) {
        String message = MessageFormat.format(msg + " bundle: {0}/{1}", bundle.getSymbolicName(), bundle.getBundleId());
        Activator.log(2, bundle, message, t);
    }

    protected void error(String msg, Throwable t) {
        Activator.log(4, m_bundle, msg, t);
    }

    public static void log(int level, Bundle bundle, String pattern, Object[] arguments, Throwable ex) {
        if (Activator.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            Activator.log(level, bundle, message, ex);
        }
    }

    public static boolean isLogEnabled(int level) {
        return m_configuration == null || m_configuration.getLogLevel() >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int level, Bundle bundle, String message, Throwable ex) {
        if (Activator.isLogEnabled(level)) {
            LogService logger;
            ServiceTracker<LogService, LogService> t = m_logService;
            LogService logService = logger = t != null ? (LogService)t.getService() : null;
            if (logger == null) {
                PrintStream out = level == 1 ? System.err : System.out;
                StringBuffer buf = new StringBuffer();
                switch (level) {
                    case 4: {
                        buf.append("DEBUG: ");
                        break;
                    }
                    case 3: {
                        buf.append("INFO : ");
                        break;
                    }
                    case 2: {
                        buf.append("WARN : ");
                        break;
                    }
                    case 1: {
                        buf.append("ERROR: ");
                        break;
                    }
                    default: {
                        buf.append("UNK  : ");
                    }
                }
                if (bundle != null) {
                    buf.append(bundle.getSymbolicName());
                    buf.append(" (");
                    buf.append(bundle.getBundleId());
                    buf.append("): ");
                }
                buf.append(message);
                PrintStream printStream = out;
                synchronized (printStream) {
                    out.println(buf);
                    if (ex != null) {
                        ex.printStackTrace(out);
                    }
                }
            } else {
                logger.log(level, message, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getPackageAdmin() {
        if (m_packageAdmin != null) return m_packageAdmin.getService();
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            if (m_packageAdmin != null) return m_packageAdmin.getService();
            m_packageAdmin = new ServiceTracker(m_context, PACKAGEADMIN_CLASS, null);
            m_packageAdmin.open();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_packageAdmin.getService();
        }
    }

    protected class ScrExtension
    implements Extension {
        private final Bundle bundle;
        private final CountDownLatch started;

        public ScrExtension(Bundle bundle) {
            this.bundle = bundle;
            this.started = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            try {
                Activator.this.loadComponents(this.bundle);
            }
            finally {
                this.started.countDown();
            }
        }

        public void destroy() {
            try {
                this.started.await(m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Activator.log(2, m_bundle, "The wait for bundle {0}/{1} being started before destruction has been interrupted.", new Object[]{this.bundle.getSymbolicName(), this.bundle.getBundleId()}, e);
            }
            Activator.this.disposeComponents(this.bundle);
        }
    }
}

