/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Dictionary;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.component.ExtComponentContext;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.helper.ComponentServiceObjectsHelper;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContextImpl<S>
implements ExtComponentContext {
    private final SingleComponentManager<S> m_componentManager;
    private final EdgeInfo[] edgeInfos;
    private final ComponentInstance m_componentInstance = new ComponentInstanceImpl(this);
    private final Bundle m_usingBundle;
    private volatile S m_implementationObject;
    private volatile boolean m_implementationAccessible;
    private final CountDownLatch accessibleLatch = new CountDownLatch(1);
    private final ComponentServiceObjectsHelper serviceObjectsHelper;

    public ComponentContextImpl(SingleComponentManager<S> componentManager, Bundle usingBundle) {
        this.m_componentManager = componentManager;
        this.m_usingBundle = usingBundle;
        this.edgeInfos = new EdgeInfo[componentManager.getComponentMetadata().getDependencies().size()];
        for (int i = 0; i < this.edgeInfos.length; ++i) {
            this.edgeInfos[i] = new EdgeInfo();
        }
        this.serviceObjectsHelper = new ComponentServiceObjectsHelper(usingBundle.getBundleContext());
    }

    public void cleanup() {
        this.serviceObjectsHelper.cleanup();
    }

    public ComponentServiceObjectsHelper getComponentServiceObjectsHelper() {
        return this.serviceObjectsHelper;
    }

    public void setImplementationObject(S implementationObject) {
        this.m_implementationObject = implementationObject;
    }

    void setImplementationAccessible(boolean implementationAccessible) {
        this.m_implementationAccessible = implementationAccessible;
        if (implementationAccessible) {
            this.accessibleLatch.countDown();
        }
    }

    EdgeInfo getEdgeInfo(DependencyManager<S, ?> dm) {
        int index = dm.getIndex();
        return this.edgeInfos[index];
    }

    protected SingleComponentManager<S> getComponentManager() {
        return this.m_componentManager;
    }

    @Override
    public final Dictionary<String, Object> getProperties() {
        return new ReadOnlyDictionary<String, Object>(this.m_componentManager.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object locateService(String name) {
        Object var3_3;
        this.m_componentManager.obtainActivationReadLock("locate.service.name");
        try {
            DependencyManager dm = this.m_componentManager.getDependencyManager(name);
            var3_3 = dm != null ? dm.getService(this) : null;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_componentManager.releaseActivationReadLock("locate.service.name");
            throw throwable;
        }
        this.m_componentManager.releaseActivationReadLock("locate.service.name");
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object locateService(String name, ServiceReference ref) {
        Object var4_4;
        this.m_componentManager.obtainActivationReadLock("locate.service.ref");
        try {
            DependencyManager dm = this.m_componentManager.getDependencyManager(name);
            var4_4 = dm != null ? dm.getService(this, ref) : null;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_componentManager.releaseActivationReadLock("locate.service.ref");
            throw throwable;
        }
        this.m_componentManager.releaseActivationReadLock("locate.service.ref");
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] locateServices(String name) {
        Object[] objectArray;
        this.m_componentManager.obtainActivationReadLock("locate.services");
        try {
            DependencyManager dm = this.m_componentManager.getDependencyManager(name);
            objectArray = dm != null ? dm.getServices(this) : null;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_componentManager.releaseActivationReadLock("locate.services");
            throw throwable;
        }
        this.m_componentManager.releaseActivationReadLock("locate.services");
        return objectArray;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_componentManager.getBundleContext();
    }

    @Override
    public Bundle getUsingBundle() {
        return this.m_usingBundle;
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return this.m_componentInstance;
    }

    @Override
    public void enableComponent(String name) {
        BundleComponentActivator activator = this.m_componentManager.getActivator();
        if (activator != null) {
            activator.enableComponent(name);
        }
    }

    @Override
    public void disableComponent(String name) {
        BundleComponentActivator activator = this.m_componentManager.getActivator();
        if (activator != null) {
            activator.disableComponent(name);
        }
    }

    public ServiceReference<S> getServiceReference() {
        return this.m_componentManager.getServiceReference();
    }

    @Override
    public void setServiceProperties(Dictionary<String, ?> properties) {
        this.getComponentManager().setServiceProperties(properties);
    }

    S getImplementationObject(boolean requireAccessible) {
        if (!requireAccessible || this.m_implementationAccessible) {
            return this.m_implementationObject;
        }
        try {
            if (this.accessibleLatch.await(this.m_componentManager.getLockTimeout(), TimeUnit.MILLISECONDS) && this.m_implementationAccessible) {
                return this.m_implementationObject;
            }
        }
        catch (InterruptedException e) {
            try {
                if (this.accessibleLatch.await(this.m_componentManager.getLockTimeout(), TimeUnit.MILLISECONDS) && this.m_implementationAccessible) {
                    return this.m_implementationObject;
                }
            }
            catch (InterruptedException e1) {
                this.m_componentManager.log(3, "Interrupted twice waiting for implementation object to become accessible", e1);
            }
            Thread.currentThread().interrupt();
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentInstanceImpl<S>
    implements ComponentInstance {
        private final ComponentContextImpl<S> m_componentContext;

        private ComponentInstanceImpl(ComponentContextImpl<S> m_componentContext) {
            this.m_componentContext = m_componentContext;
        }

        @Override
        public Object getInstance() {
            return this.m_componentContext.getImplementationObject(true);
        }

        @Override
        public void dispose() {
            this.m_componentContext.getComponentManager().dispose();
        }
    }
}

