/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.manager.ServiceTrackerCustomizer;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTracker<S, T> {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer<S, T> customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference<S> trackReference;
    private volatile Tracked tracked;
    private boolean active;
    private volatile ServiceReference<S> cachedReference;
    private volatile T cachedService;

    public Tracked tracked() {
        return this.tracked;
    }

    public ServiceTracker(BundleContext context, ServiceReference<S> reference, ServiceTrackerCustomizer<S, T> customizer) {
        this.context = context;
        this.trackReference = reference;
        this.trackClass = null;
        this.customizer = customizer;
        this.listenerFilter = "(service.id=" + reference.getProperty("service.id").toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer<S, T> customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = clazz;
        this.customizer = customizer;
        this.listenerFilter = "(objectClass=" + clazz + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(BundleContext context, Filter filter, ServiceTrackerCustomizer<S, T> customizer, boolean initialActive) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = null;
        this.listenerFilter = filter.toString();
        this.filter = filter;
        this.customizer = customizer;
        this.active = initialActive;
        if (context == null) {
            throw new NullPointerException("BundleContext");
        }
    }

    public ServiceTracker(BundleContext context, Class<S> clazz, ServiceTrackerCustomizer<S, T> customizer) {
        this(context, clazz.getName(), customizer);
    }

    public void open(AtomicInteger trackingCount) {
        this.open(false, trackingCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean trackAllServices, AtomicInteger trackingCount) {
        Tracked t;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked = t = trackAllServices ? new AllTracked(trackingCount) : new Tracked(trackingCount);
            synchronized (tracked) {
                try {
                    this.context.addServiceListener((ServiceListener)t, this.listenerFilter);
                    ServiceReference<S>[] references = null;
                    if (this.trackClass != null) {
                        references = this.getInitialReferences(trackAllServices, this.trackClass, null);
                    } else if (this.trackReference != null) {
                        if (this.trackReference.getBundle() != null) {
                            ServiceReference[] single = new ServiceReference[]{this.trackReference};
                            references = single;
                        }
                    } else {
                        references = this.getInitialReferences(trackAllServices, null, this.listenerFilter);
                    }
                    t.setInitial(references);
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage(), e);
                }
            }
            this.tracked = t;
        }
        t.trackInitial();
    }

    private ServiceReference<S>[] getInitialReferences(boolean trackAllServices, String className, String filterString) throws InvalidSyntaxException {
        ServiceReference[] result = trackAllServices ? this.context.getAllServiceReferences(className, filterString) : this.context.getServiceReferences(className, filterString);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ServiceReference<S>, T> close(AtomicInteger trackingCount) {
        Tracked outgoing;
        TreeMap map = new TreeMap(Collections.reverseOrder());
        Object object = this;
        synchronized (object) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return map;
            }
            outgoing.close();
            Tracked tracked = outgoing;
            synchronized (tracked) {
                trackingCount.set(outgoing.getTrackingCount());
                outgoing.copyEntries(map);
            }
            try {
                this.context.removeServiceListener((ServiceListener)outgoing);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.modified();
        object = outgoing;
        synchronized (object) {
            outgoing.notifyAll();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeClose(Map<ServiceReference<S>, T> toUntrack) {
        Tracked outgoing;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
        }
        for (ServiceReference<S> ref : toUntrack.keySet()) {
            outgoing.untrack(ref, null);
        }
        this.tracked = null;
    }

    public T addingService(ServiceReference<S> reference, int trackingCount) {
        Object result = this.context.getService(reference);
        return (T)result;
    }

    public void modifiedService(ServiceReference<S> reference, T service, int trackingCount) {
    }

    public void removedService(ServiceReference<S> reference, T service, int trackingCount) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T waitForService(long timeout) throws InterruptedException {
        long endTime;
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        T object = this.getService();
        if (object != null) {
            return object;
        }
        long l = endTime = timeout == 0L ? 0L : System.currentTimeMillis() + timeout;
        do {
            Tracked t;
            if ((t = this.tracked()) == null) {
                return null;
            }
            Tracked tracked = t;
            synchronized (tracked) {
                if (t.size() == 0) {
                    t.wait(timeout);
                }
            }
            object = this.getService();
        } while ((endTime <= 0L || (timeout = endTime - System.currentTimeMillis()) > 0L) && object == null);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<S>[] getServiceReferences() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            ServiceReference[] result = new ServiceReference[length];
            return t.copyKeys(result);
        }
    }

    public ServiceReference<S> getServiceReference() {
        int length;
        ServiceReference<S> reference = this.cachedReference;
        if (reference != null) {
            return reference;
        }
        ServiceReference<S>[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            for (int i = 0; i < length; ++i) {
                int ranking;
                Object property = references[i].getProperty("service.ranking");
                rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                    continue;
                }
                if (ranking != maxRanking) continue;
                ++count;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                for (int i = 0; i < length; ++i) {
                    long id;
                    if (rankings[i] != maxRanking || (id = ((Long)references[i].getProperty("service.id")).longValue()) >= minId) continue;
                    index = i;
                    minId = id;
                }
            }
        }
        this.cachedReference = references[index];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getService(ServiceReference<S> reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            ServiceReference<S>[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                return null;
            }
            Object[] objects = new Object[length];
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getService(references[i]);
            }
            return objects;
        }
    }

    public T getService() {
        T service = this.cachedService;
        if (service != null) {
            return service;
        }
        ServiceReference<S> reference = this.getServiceReference();
        if (reference == null) {
            return null;
        }
        this.cachedService = this.getService(reference);
        return this.cachedService;
    }

    public void remove(ServiceReference<S> reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(reference, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    void modified() {
        this.cachedReference = null;
        this.cachedService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ServiceReference<S>, T> getTracked(Boolean activate, AtomicInteger trackingCount) {
        TreeMap map = new TreeMap(Collections.reverseOrder());
        Tracked t = this.tracked();
        if (t == null) {
            return map;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            if (activate != null) {
                this.active = activate;
            }
            trackingCount.set(t.getTrackingCount());
            return t.copyEntries(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Tracked t = this.tracked();
        if (t == null) {
            return true;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Tracked t = this.tracked();
        if (t == null) {
            return false;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getServices(T[] array) {
        Tracked t = this.tracked();
        if (t == null) {
            if (array.length > 0) {
                array[0] = null;
            }
            return array;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            ServiceReference<S>[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                if (array.length > 0) {
                    array[0] = null;
                }
                return array;
            }
            if (length > array.length) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
            }
            for (int i = 0; i < length; ++i) {
                array[i] = this.getService(references[i]);
            }
            if (array.length > length) {
                array[length] = null;
            }
            return array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllTracked
    extends Tracked
    implements AllServiceListener {
        AllTracked(AtomicInteger trackingCount) {
            super(trackingCount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tracked
    extends AbstractTracked<ServiceReference<S>, T, ServiceEvent>
    implements ServiceListener {
        Tracked(AtomicInteger trackingCount) {
            super(trackingCount);
        }

        public final void serviceChanged(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    this.track(reference, event);
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(reference, event);
                    break;
                }
                default: {
                    System.out.println("Unrecognized event type: ServiceTracker.Tracked.serviceChanged[" + event.getType() + "]: " + reference);
                }
            }
        }

        @Override
        final int modified() {
            int trackingCount = super.modified();
            ServiceTracker.this.modified();
            return trackingCount;
        }

        @Override
        final T customizerAdding(ServiceReference<S> item, ServiceEvent related) {
            return ServiceTracker.this.customizer.addingService(item);
        }

        @Override
        final void customizerAdded(ServiceReference<S> item, ServiceEvent related, T object, int trackingCount) {
            ServiceTracker.this.customizer.addedService(item, object, trackingCount);
        }

        @Override
        final void customizerModified(ServiceReference<S> item, ServiceEvent related, T object, int trackingCount) {
            ServiceTracker.this.customizer.modifiedService(item, object, trackingCount);
        }

        @Override
        final void customizerRemoved(ServiceReference<S> item, ServiceEvent related, T object, int trackingCount) {
            ServiceTracker.this.customizer.removedService(item, object, trackingCount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractTracked<S, T, R> {
        static final boolean DEBUG = false;
        private final Map<S, T> tracked = new HashMap<S, T>();
        private final AtomicInteger trackingCount;
        private final List<S> adding;
        volatile boolean closed;
        private final LinkedList<S> initial;

        AbstractTracked(AtomicInteger trackingCount) {
            this.trackingCount = trackingCount;
            this.adding = new ArrayList<S>(6);
            this.initial = new LinkedList();
            this.closed = false;
        }

        void setInitial(S[] list) {
            if (list == null) {
                return;
            }
            for (S item : list) {
                if (item == null) continue;
                this.initial.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trackInitial() {
            while (true) {
                S item;
                AbstractTracked abstractTracked = this;
                synchronized (abstractTracked) {
                    if (this.closed || this.initial.size() == 0) {
                        return;
                    }
                    item = this.initial.removeFirst();
                    if (this.tracked.get(item) != null) {
                        continue;
                    }
                    if (this.adding.contains(item)) {
                        continue;
                    }
                    this.adding.add(item);
                }
                this.trackAdding(item, null);
            }
        }

        void close() {
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void track(S item, R related) {
            T object;
            boolean tracking;
            int trackingCount = -1;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed) {
                    return;
                }
                tracking = this.tracked.containsKey(item);
                object = this.tracked.get(item);
                if (!tracking) {
                    if (this.adding.contains(item)) {
                        return;
                    }
                    this.adding.add(item);
                } else {
                    trackingCount = this.modified();
                }
            }
            if (!tracking) {
                this.trackAdding(item, related);
            } else {
                this.customizerModified(item, related, object, trackingCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackAdding(S item, R related) {
            AbstractTracked abstractTracked;
            T object = null;
            boolean becameUntracked = false;
            int trackingCount = -1;
            try {
                object = this.customizerAdding(item, related);
                Object var7_6 = null;
                abstractTracked = this;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                AbstractTracked abstractTracked2 = this;
                synchronized (abstractTracked2) {
                    if (this.adding.remove(item) && !this.closed) {
                        this.tracked.put(item, object);
                        trackingCount = this.modified();
                        this.notifyAll();
                    } else {
                        becameUntracked = true;
                    }
                }
                throw throwable;
            }
            synchronized (abstractTracked) {
                if (this.adding.remove(item) && !this.closed) {
                    this.tracked.put(item, object);
                    trackingCount = this.modified();
                    this.notifyAll();
                } else {
                    becameUntracked = true;
                }
            }
            if (becameUntracked) {
                this.customizerRemoved(item, related, object, trackingCount);
            } else {
                this.customizerAdded(item, related, object, trackingCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void untrack(S item, R related) {
            int trackingCount;
            T object;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.initial.remove(item)) {
                    return;
                }
                if (this.adding.remove(item)) {
                    return;
                }
                object = this.tracked.remove(item);
                if (object == null) {
                    return;
                }
                trackingCount = this.modified();
            }
            this.customizerRemoved(item, related, object, trackingCount);
        }

        int size() {
            return this.tracked.size();
        }

        boolean isEmpty() {
            return this.tracked.isEmpty();
        }

        T getCustomizedObject(S item) {
            return this.tracked.get(item);
        }

        S[] copyKeys(S[] list) {
            return this.tracked.keySet().toArray(list);
        }

        int modified() {
            return this.trackingCount.incrementAndGet();
        }

        int getTrackingCount() {
            return this.trackingCount.get();
        }

        <M extends Map<? super S, ? super T>> M copyEntries(M map) {
            map.putAll(this.tracked);
            return map;
        }

        abstract T customizerAdding(S var1, R var2);

        abstract void customizerAdded(S var1, R var2, T var3, int var4);

        abstract void customizerModified(S var1, R var2, T var3, int var4);

        abstract void customizerRemoved(S var1, R var2, T var3, int var4);
    }
}

