/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefPair<T> {
    private final ServiceReference<T> ref;
    private AtomicReference<T> serviceObjectRef = new AtomicReference();
    private boolean failed;

    public RefPair(ServiceReference<T> ref) {
        this.ref = ref;
    }

    public ServiceReference<T> getRef() {
        return this.ref;
    }

    public T getServiceObject() {
        return this.serviceObjectRef.get();
    }

    public boolean setServiceObject(T serviceObject) {
        boolean set = this.serviceObjectRef.compareAndSet(null, serviceObject);
        if (serviceObject != null) {
            this.failed = false;
        }
        return set;
    }

    public T unsetServiceObject() {
        return this.serviceObjectRef.getAndSet(null);
    }

    public void setFailed() {
        this.failed = true;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String toString() {
        return "[RefPair: ref: [" + this.ref + "] service: [" + this.serviceObjectRef.get() + "]]";
    }
}

