/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.TargetedPID;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.ConfigurableComponentHolder;
import org.apache.felix.scr.impl.config.ConfigurationSupport;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.manager.ConfigurationComponentFactoryImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry
implements ScrService,
ServiceListener {
    public static final String CONFIGURATION_ADMIN = "org.osgi.service.cm.ConfigurationAdmin";
    private BundleContext m_bundleContext;
    private final Map<ComponentRegistryKey, ComponentHolder> m_componentHoldersByName;
    private final Map<String, Set<ComponentHolder>> m_componentHoldersByPid;
    private final Map<Long, AbstractComponentManager<?>> m_componentsById;
    private long m_componentCounter = -1L;
    private ServiceRegistration m_registration;
    private ConfigurationSupport configurationSupport;
    private final Map<ServiceReference<?>, List<Entry>> m_missingDependencies = new HashMap();

    protected ComponentRegistry(BundleContext context) {
        this.m_bundleContext = context;
        this.m_componentHoldersByName = new HashMap<ComponentRegistryKey, ComponentHolder>();
        this.m_componentHoldersByPid = new HashMap<String, Set<ComponentHolder>>();
        this.m_componentsById = new HashMap();
        try {
            context.addServiceListener((ServiceListener)this, "(objectclass=org.osgi.service.cm.ConfigurationAdmin)");
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        if (context.getServiceReference(CONFIGURATION_ADMIN) != null) {
            this.getOrCreateConfigurationSupport();
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Management Agent");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = context.registerService(new String[]{ScrService.class.getName()}, (Object)this, props);
    }

    public void dispose() {
        this.m_bundleContext.removeServiceListener((ServiceListener)this);
        if (this.configurationSupport != null) {
            this.configurationSupport.dispose();
            this.configurationSupport = null;
        }
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    @Override
    public Component[] getComponents() {
        ComponentHolder[] holders = this.getComponentHolders();
        ArrayList<Component> list = new ArrayList<Component>();
        for (ComponentHolder holder : holders) {
            Component[] components;
            if (holder == null) continue;
            for (Component component : components = holder.getComponents()) {
                list.add(component);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Component[list.size()]);
    }

    @Override
    public Component[] getComponents(Bundle bundle) {
        ComponentHolder[] holders = this.getComponentHolders();
        ArrayList<Component> list = new ArrayList<Component>();
        for (ComponentHolder holder : holders) {
            Component[] components;
            BundleComponentActivator activator;
            if (holder == null || (activator = holder.getActivator()) == null || activator.getBundleContext().getBundle() != bundle) continue;
            for (Component component : components = holder.getComponents()) {
                list.add(component);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Component[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponent(long componentId) {
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            return this.m_componentsById.get(componentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component[] getComponents(String componentName) {
        ArrayList<Component> list = new ArrayList<Component>();
        Map<ComponentRegistryKey, ComponentHolder> map = this.m_componentHoldersByName;
        synchronized (map) {
            for (ComponentHolder c : this.m_componentHoldersByName.values()) {
                if (!c.getComponentMetadata().getName().equals(componentName)) continue;
                list.addAll(Arrays.asList(c.getComponents()));
            }
        }
        return list.isEmpty() ? null : list.toArray(new Component[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long registerComponentId(AbstractComponentManager<?> componentManager) {
        long componentId;
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            componentId = ++this.m_componentCounter;
            this.m_componentsById.put(componentId, componentManager);
        }
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentId(long componentId) {
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            this.m_componentsById.remove(componentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ComponentRegistryKey checkComponentName(Bundle bundle, String name) {
        boolean present;
        ComponentRegistryKey key = new ComponentRegistryKey(bundle, name);
        ComponentHolder existingRegistration = null;
        Map<ComponentRegistryKey, ComponentHolder> map = this.m_componentHoldersByName;
        synchronized (map) {
            present = this.m_componentHoldersByName.containsKey(key);
            if (!present) {
                this.m_componentHoldersByName.put(key, null);
            } else {
                existingRegistration = this.m_componentHoldersByName.get(key);
            }
        }
        if (present) {
            String message = "The component name '" + name + "' has already been registered";
            if (existingRegistration != null) {
                Bundle cBundle = existingRegistration.getActivator().getBundleContext().getBundle();
                ComponentMetadata cMeta = existingRegistration.getComponentMetadata();
                StringBuffer buf = new StringBuffer(message);
                buf.append(" by Bundle ").append(cBundle.getBundleId());
                if (cBundle.getSymbolicName() != null) {
                    buf.append(" (").append(cBundle.getSymbolicName()).append(")");
                }
                buf.append(" as Component of Class ").append(cMeta.getImplementationClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerComponentHolder(ComponentRegistryKey key, ComponentHolder componentHolder) {
        Activator.log(4, null, "Registering component with pid {0} for bundle {1}", new Object[]{componentHolder.getComponentMetadata().getConfigurationPid(), key.getBundleId()}, null);
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            if (this.m_componentHoldersByName.get(key) != null) {
                throw new ComponentException("The component name '{0}" + componentHolder.getComponentMetadata().getName() + "' has already been registered.");
            }
            this.m_componentHoldersByName.put(key, componentHolder);
        }
        map = this.m_componentHoldersByPid;
        synchronized (map) {
            String configurationPid = componentHolder.getComponentMetadata().getConfigurationPid();
            Set<ComponentHolder> set = this.m_componentHoldersByPid.get(configurationPid);
            if (set == null) {
                set = new HashSet<ComponentHolder>();
                this.m_componentHoldersByPid.put(configurationPid, set);
            }
            set.add(componentHolder);
        }
        if (this.configurationSupport != null) {
            this.configurationSupport.configureComponentHolder(componentHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentHolder getComponentHolder(Bundle bundle, String name) {
        Map<ComponentRegistryKey, ComponentHolder> map = this.m_componentHoldersByName;
        synchronized (map) {
            return this.m_componentHoldersByName.get(new ComponentRegistryKey(bundle, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<ComponentHolder> getComponentHoldersByPid(TargetedPID targetedPid) {
        String pid = targetedPid.getServicePid();
        HashSet<ComponentHolder> componentHoldersUsingPid = new HashSet<ComponentHolder>();
        Map<String, Set<ComponentHolder>> map = this.m_componentHoldersByPid;
        synchronized (map) {
            Set<ComponentHolder> set = this.m_componentHoldersByPid.get(pid);
            if (set != null) {
                for (ComponentHolder holder : set) {
                    if (!targetedPid.matchesTarget(holder)) continue;
                    componentHoldersUsingPid.add(holder);
                }
            }
        }
        return componentHoldersUsingPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentHolder[] getComponentHolders() {
        Map<ComponentRegistryKey, ComponentHolder> map = this.m_componentHoldersByName;
        synchronized (map) {
            return this.m_componentHoldersByName.values().toArray(new ComponentHolder[this.m_componentHoldersByName.size()]);
        }
    }

    final void unregisterComponentHolder(Bundle bundle, String name) {
        this.unregisterComponentHolder(new ComponentRegistryKey(bundle, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentHolder(ComponentRegistryKey key) {
        ComponentHolder component;
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            component = this.m_componentHoldersByName.remove(key);
        }
        if (component != null) {
            Activator.log(4, null, "Unregistering component with pid {0} for bundle {1}", new Object[]{component.getComponentMetadata().getConfigurationPid(), key.getBundleId()}, null);
            map = this.m_componentHoldersByPid;
            synchronized (map) {
                String configurationPid = component.getComponentMetadata().getConfigurationPid();
                Set<ComponentHolder> componentsForPid = this.m_componentHoldersByPid.get(configurationPid);
                if (componentsForPid != null) {
                    componentsForPid.remove(component);
                    if (componentsForPid.size() == 0) {
                        this.m_componentHoldersByPid.remove(configurationPid);
                    }
                }
            }
        }
    }

    public ComponentHolder createComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        ComponentHolder holder = metadata.isFactory() ? (!activator.getConfiguration().isFactoryEnabled() ? new ComponentFactoryImpl(activator, metadata) : new ConfigurationComponentFactoryImpl(activator, metadata)) : new ConfigurableComponentHolder(activator, metadata);
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            ConfigurationSupport configurationSupport = this.getOrCreateConfigurationSupport();
            ServiceReference caRef = event.getServiceReference();
            Object service = this.m_bundleContext.getService(caRef);
            if (service != null) {
                try {
                    configurationSupport.configureComponentHolders((ServiceReference<ConfigurationAdmin>)caRef, service);
                }
                finally {
                    this.m_bundleContext.ungetService(caRef);
                }
            }
        } else if (event.getType() == 4) {
            this.disposeConfigurationSupport();
        }
    }

    static boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders().get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    private ConfigurationSupport getOrCreateConfigurationSupport() {
        if (this.configurationSupport == null) {
            this.configurationSupport = new ConfigurationSupport(this.m_bundleContext, this);
        }
        return this.configurationSupport;
    }

    private void disposeConfigurationSupport() {
        if (this.configurationSupport != null) {
            this.configurationSupport.dispose();
            this.configurationSupport = null;
        }
    }

    public void missingServicePresent(final ServiceReference serviceReference, ComponentActorThread actor) {
        final List<Entry> dependencyManagers = this.m_missingDependencies.remove(serviceReference);
        if (dependencyManagers != null) {
            actor.schedule(new Runnable(){

                public void run() {
                    for (Entry entry : dependencyManagers) {
                        entry.getDm().invokeBindMethodLate(serviceReference, entry.getTrackingCount());
                    }
                }

                public String toString() {
                    return "Late binding task of reference " + serviceReference + " for dependencyManagers " + dependencyManagers;
                }
            });
        }
    }

    public synchronized void registerMissingDependency(DependencyManager<?, ?> dependencyManager, ServiceReference serviceReference, int trackingCount) {
        if (serviceReference.getProperty("component.name") == null || serviceReference.getProperty("component.id") == null) {
            return;
        }
        List<Entry> dependencyManagers = this.m_missingDependencies.get(serviceReference);
        if (dependencyManagers == null) {
            dependencyManagers = new ArrayList<Entry>();
            this.m_missingDependencies.put(serviceReference, dependencyManagers);
        }
        dependencyManagers.add(new Entry(dependencyManager, trackingCount));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private final DependencyManager<?, ?> dm;
        private final int trackingCount;

        private Entry(DependencyManager<?, ?> dm, int trackingCount) {
            this.dm = dm;
            this.trackingCount = trackingCount;
        }

        public DependencyManager<?, ?> getDm() {
            return this.dm;
        }

        public int getTrackingCount() {
            return this.trackingCount;
        }
    }
}

