/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.impl.config.ScrManagedServiceServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ScrConfiguration {
    private static final String VALUE_TRUE = Boolean.TRUE.toString();
    public static final String PID = "org.apache.felix.scr.ScrService";
    public static final String PROP_FACTORY_ENABLED = "ds.factory.enabled";
    public static final String PROP_DELAYED_KEEP_INSTANCES = "ds.delayed.keepInstances";
    public static final String PROP_LOGLEVEL = "ds.loglevel";
    private static final String LOG_LEVEL_DEBUG = "debug";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final String LOG_LEVEL_ERROR = "error";
    private static final String PROP_SHOWTRACE = "ds.showtrace";
    private static final String PROP_SHOWERRORS = "ds.showerrors";
    private int logLevel;
    private boolean factoryEnabled;
    private boolean keepInstances;
    private BundleContext bundleContext;
    private ServiceRegistration managedService;

    public ScrConfiguration() {
        this.configure(null);
    }

    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configure(null);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", PID);
        ((Dictionary)props).put("service.description", "SCR Configurator");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)new ScrManagedServiceServiceFactory(this), props);
    }

    public void stop() {
        if (this.managedService != null) {
            this.managedService.unregister();
            this.managedService = null;
        }
        this.bundleContext = null;
    }

    void configure(Dictionary config) {
        if (config == null) {
            if (this.bundleContext == null) {
                this.logLevel = 1;
                this.factoryEnabled = false;
                this.keepInstances = false;
            } else {
                this.logLevel = this.getDefaultLogLevel();
                this.factoryEnabled = this.getDefaultFactoryEnabled();
                this.keepInstances = this.getDefaultKeepInstances();
            }
        } else {
            this.logLevel = this.getLogLevel(config.get(PROP_LOGLEVEL));
            this.factoryEnabled = VALUE_TRUE.equalsIgnoreCase(String.valueOf(config.get(PROP_FACTORY_ENABLED)));
            this.keepInstances = VALUE_TRUE.equalsIgnoreCase(String.valueOf(config.get(PROP_DELAYED_KEEP_INSTANCES)));
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public boolean isFactoryEnabled() {
        return this.factoryEnabled;
    }

    public boolean keepInstances() {
        return this.keepInstances;
    }

    private boolean getDefaultFactoryEnabled() {
        return VALUE_TRUE.equals(this.bundleContext.getProperty(PROP_FACTORY_ENABLED));
    }

    private boolean getDefaultKeepInstances() {
        return VALUE_TRUE.equals(this.bundleContext.getProperty(PROP_DELAYED_KEEP_INSTANCES));
    }

    private int getDefaultLogLevel() {
        return this.getLogLevel(this.bundleContext.getProperty(PROP_LOGLEVEL));
    }

    private int getLogLevel(Object levelObject) {
        block9: {
            if (levelObject != null) {
                if (levelObject instanceof Number) {
                    return ((Number)levelObject).intValue();
                }
                String levelString = levelObject.toString();
                try {
                    return Integer.parseInt(levelString);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LOG_LEVEL_DEBUG.equalsIgnoreCase(levelString)) {
                        return 4;
                    }
                    if (LOG_LEVEL_INFO.equalsIgnoreCase(levelString)) {
                        return 3;
                    }
                    if (LOG_LEVEL_WARN.equalsIgnoreCase(levelString)) {
                        return 2;
                    }
                    if (!LOG_LEVEL_ERROR.equalsIgnoreCase(levelString)) break block9;
                    return 1;
                }
            }
        }
        if (VALUE_TRUE.equalsIgnoreCase(this.bundleContext.getProperty(PROP_SHOWTRACE))) {
            return 4;
        }
        if ("false".equalsIgnoreCase(this.bundleContext.getProperty(PROP_SHOWERRORS))) {
            return -1;
        }
        return 1;
    }
}

