/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    private static int m_logLevel = 1;
    private BundleContext m_context;
    private static ServiceTracker m_logService;
    private Map m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;
    static /* synthetic */ Class class$org$apache$felix$shell$Command;
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;

    public void start(BundleContext context) throws Exception {
        this.m_context = context;
        this.m_componentBundles = new HashMap();
        this.m_componentRegistry = new ComponentRegistry(this.m_context);
        m_logService = new ServiceTracker(context, LOGSERVICE_CLASS, null);
        m_logService.open();
        m_logLevel = Activator.getLogLevel(context);
        if ("true".equalsIgnoreCase(context.getProperty("ds.showversion"))) {
            Activator.log(3, context.getBundle(), " Version = " + context.getBundle().getHeaders().get("Bundle-Version"), null);
        }
        this.m_componentActor = new ComponentActorThread();
        this.m_componentActor.start();
        context.addBundleListener((BundleListener)this);
        this.loadAllComponents(context);
        try {
            context.registerService((class$org$apache$felix$shell$Command == null ? (class$org$apache$felix$shell$Command = Activator.class$("org.apache.felix.shell.Command")) : class$org$apache$felix$shell$Command).getName(), (Object)new ScrCommand(this.m_context, this.m_componentRegistry), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        this.disposeAllComponents();
        this.m_componentRegistry.dispose();
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            try {
                this.m_componentActor.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2) {
            this.loadComponents(event.getBundle());
        } else if (event.getType() == 256) {
            this.disposeComponents(event.getBundle());
        }
    }

    private void loadAllComponents(BundleContext context) {
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (bundle.getState() != 32) continue;
            this.loadComponents(bundle);
        }
    }

    private void loadComponents(Bundle bundle) {
        if (bundle.getHeaders().get("Service-Component") == null) {
            return;
        }
        BundleContext context = this.getBundleContext(bundle);
        if (context == null) {
            Activator.log(1, this.m_context.getBundle(), "Cannot get BundleContext of bundle " + bundle.getSymbolicName(), null);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this.m_componentRegistry, this.m_componentActor, context, m_logLevel);
            this.m_componentBundles.put(bundle.getSymbolicName(), ga);
        }
        catch (Exception e) {
            Activator.log(1, this.m_context.getBundle(), "Error while loading components of bundle " + bundle.getSymbolicName(), e);
        }
    }

    private void disposeComponents(Bundle bundle) {
        String name = bundle.getSymbolicName();
        BundleComponentActivator ga = (BundleComponentActivator)this.m_componentBundles.remove(name);
        if (ga != null) {
            try {
                ga.dispose();
            }
            catch (Exception e) {
                Activator.log(1, this.m_context.getBundle(), "Error while disposing components of bundle " + name, e);
            }
        }
    }

    private void disposeAllComponents() {
        Iterator it = this.m_componentBundles.values().iterator();
        while (it.hasNext()) {
            BundleComponentActivator ga = (BundleComponentActivator)it.next();
            try {
                ga.dispose();
            }
            catch (Exception e) {
                Activator.log(1, this.m_context.getBundle(), "Error while disposing components of bundle " + ga.getBundleContext().getBundle().getSymbolicName(), e);
            }
            it.remove();
        }
    }

    private BundleContext getBundleContext(Bundle bundle) {
        try {
            return bundle.getBundleContext();
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            BundleContext context = null;
            for (Class<?> clazz = bundle.getClass(); context == null && clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    context = this.getBundleContext(clazz, bundle, "getBundleContext");
                    if (context != null) continue;
                    context = this.getBundleContext(clazz, bundle, "getContext");
                    continue;
                }
                catch (NoSuchMethodException nsme) {
                    continue;
                }
                catch (Throwable t2) {
                    Activator.log(1, this.m_context.getBundle(), "Cannot get BundleContext for " + bundle.getSymbolicName(), t2);
                }
            }
            return context;
        }
    }

    private BundleContext getBundleContext(Class clazz, Bundle bundle, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method m = clazz.getDeclaredMethod(methodName, null);
        if (m.getReturnType().equals(class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = Activator.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext)) {
            m.setAccessible(true);
            return (BundleContext)m.invoke((Object)bundle, null);
        }
        return null;
    }

    private static int getLogLevel(BundleContext bundleContext) {
        String levelString;
        block8: {
            levelString = bundleContext.getProperty("ds.loglevel");
            if (levelString != null) {
                try {
                    return Integer.parseInt(levelString);
                }
                catch (NumberFormatException numberFormatException) {
                    if ("debug".equalsIgnoreCase(levelString)) {
                        return 4;
                    }
                    if ("info".equalsIgnoreCase(levelString)) {
                        return 3;
                    }
                    if ("warn".equalsIgnoreCase(levelString)) {
                        return 2;
                    }
                    if (!"error".equalsIgnoreCase(levelString)) break block8;
                    return 1;
                }
            }
        }
        levelString = bundleContext.getProperty("ds.trace");
        if ("true".equalsIgnoreCase(bundleContext.getProperty("ds.showtrace"))) {
            return 4;
        }
        if ("false".equalsIgnoreCase(bundleContext.getProperty("ds.showerrors"))) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void log(int level, Bundle bundle, String message, Throwable ex) {
        if (m_logLevel >= level) {
            Object logger;
            Object object = logger = m_logService != null ? m_logService.getService() : null;
            if (logger == null) {
                PrintStream out = level == 1 ? System.err : System.out;
                StringBuffer buf = new StringBuffer();
                switch (level) {
                    case 4: {
                        buf.append("DEBUG: ");
                        break;
                    }
                    case 3: {
                        buf.append("INFO : ");
                        break;
                    }
                    case 2: {
                        buf.append("WARN : ");
                        break;
                    }
                    case 1: {
                        buf.append("ERROR: ");
                        break;
                    }
                    default: {
                        buf.append("UNK  : ");
                    }
                }
                if (bundle != null) {
                    buf.append(bundle.getSymbolicName());
                    buf.append(" (");
                    buf.append(bundle.getBundleId());
                    buf.append("): ");
                }
                buf.append(message);
                PrintStream printStream = out;
                synchronized (printStream) {
                    out.println(buf);
                    if (ex != null) {
                        ex.printStackTrace(out);
                    }
                }
            } else {
                ((LogService)logger).log(level, message, ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

