/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.impl.PropertyMetadata;
import org.apache.felix.scr.impl.ReferenceMetadata;
import org.apache.felix.scr.impl.ServiceMetadata;
import org.osgi.service.component.ComponentException;

public class ComponentMetadata {
    private String m_name;
    private boolean m_enabled = true;
    private String m_factory = null;
    private Boolean m_immediate = null;
    private String m_implementationClassName = null;
    private Dictionary m_properties = new Hashtable();
    private List m_propertyMetaData = new ArrayList();
    private ServiceMetadata m_service = null;
    private List m_references = new ArrayList();
    private boolean m_validated = false;

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setEnabled(boolean enabled) {
        if (this.m_validated) {
            return;
        }
        this.m_enabled = enabled;
    }

    public void setFactoryIdentifier(String factoryIdentifier) {
        if (this.m_validated) {
            return;
        }
        this.m_factory = factoryIdentifier;
    }

    public void setImmediate(boolean immediate) {
        if (this.m_validated) {
            return;
        }
        this.m_immediate = immediate ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setImplementationClassName(String implementationClassName) {
        if (this.m_validated) {
            return;
        }
        this.m_implementationClassName = implementationClassName;
    }

    public void addProperty(PropertyMetadata newProperty) {
        if (this.m_validated) {
            return;
        }
        if (newProperty == null) {
            throw new IllegalArgumentException("Cannot add a null property");
        }
        this.m_propertyMetaData.add(newProperty);
    }

    public void setService(ServiceMetadata service) {
        if (this.m_validated) {
            return;
        }
        this.m_service = service;
    }

    public void addDependency(ReferenceMetadata newReference) {
        if (newReference == null) {
            throw new IllegalArgumentException("Cannot add a null ReferenceMetadata");
        }
        this.m_references.add(newReference);
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public String getFactoryIdentifier() {
        return this.m_factory;
    }

    public boolean isImmediate() {
        if (this.m_immediate != null) {
            return this.m_immediate;
        }
        return this.m_service == null;
    }

    public String getImplementationClassName() {
        return this.m_implementationClassName;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.m_service;
    }

    public Dictionary getProperties() {
        return this.m_properties;
    }

    public List getDependencies() {
        return this.m_references;
    }

    public boolean isFactory() {
        return this.m_factory != null;
    }

    void validate() {
        Iterator propertyIterator = this.m_propertyMetaData.iterator();
        while (propertyIterator.hasNext()) {
            PropertyMetadata propMeta = (PropertyMetadata)propertyIterator.next();
            propMeta.validate();
            this.m_properties.put(propMeta.getName(), propMeta.getValue());
        }
        this.m_propertyMetaData.clear();
        if (this.m_service != null) {
            this.m_service.validate();
        }
        Iterator referenceIterator = this.m_references.iterator();
        while (referenceIterator.hasNext()) {
            ((ReferenceMetadata)referenceIterator.next()).validate();
        }
        if (this.m_name == null) {
            throw new ComponentException("The component name has not been set");
        }
        if (this.m_implementationClassName == null) {
            throw new ComponentException("The implementation class name has not been set for this component");
        }
        if (this.m_immediate != null && !this.isImmediate() && this.m_service == null) {
            throw new ComponentException("Component '" + this.m_name + "' is specified as being delayed but does not provide any service.");
        }
        if (this.m_factory != null && !this.isImmediate()) {
            throw new ComponentException("A factory cannot be a delayed component");
        }
        if (this.m_service != null && this.m_service.isServiceFactory() && (this.isFactory() || this.isImmediate())) {
            throw new ComponentException("A ServiceFactory service cannot be a factory or immediate component");
        }
        this.m_validated = true;
    }
}

