/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.felix.scr.impl.AbstractComponentManager;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentManager;
import org.apache.felix.scr.impl.ComponentMetadata;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ImmediateComponentManager;
import org.apache.felix.scr.impl.ManagerFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class ComponentFactoryImpl
extends AbstractComponentManager
implements ComponentFactory,
ManagedServiceFactory {
    private ComponentRegistry m_componentRegistry;
    private Map m_configuredServices;
    private Map m_createdComponents;
    static /* synthetic */ Class class$org$osgi$service$component$ComponentFactory;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    ComponentFactoryImpl(BundleComponentActivator activator, ComponentMetadata metadata, ComponentRegistry componentRegistry) {
        super(activator, metadata, componentRegistry.createComponentId());
        this.m_componentRegistry = componentRegistry;
        this.m_createdComponents = new IdentityHashMap();
    }

    public ComponentInstance newInstance(Dictionary dictionary) {
        return (ComponentInstance)((Object)this.createComponentManager(dictionary));
    }

    protected boolean createComponent() {
        return true;
    }

    protected void deleteComponent() {
    }

    protected ServiceRegistration registerComponentService() {
        this.getActivator().log(4, "registering component factory", this.getComponentMetadata(), null);
        Dictionary serviceProperties = this.getProperties();
        return this.getActivator().getBundleContext().registerService(new String[]{(class$org$osgi$service$component$ComponentFactory == null ? (class$org$osgi$service$component$ComponentFactory = ComponentFactoryImpl.class$("org.osgi.service.component.ComponentFactory")) : class$org$osgi$service$component$ComponentFactory).getName(), (class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ComponentFactoryImpl.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName()}, this.getService(), serviceProperties);
    }

    public Object getInstance() {
        return null;
    }

    public Dictionary getProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("component.name", this.getComponentMetadata().getName());
        ((Dictionary)props).put("component.factory", this.getComponentMetadata().getFactoryIdentifier());
        ((Dictionary)props).put("service.pid", this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.description", "ManagedServiceFactory for Factory Component" + this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
        return props;
    }

    protected Object getService() {
        return this;
    }

    public void updated(String pid, Dictionary configuration) {
        ComponentManager cm;
        if (this.m_configuredServices != null) {
            cm = (ComponentManager)this.m_configuredServices.get(pid);
        } else {
            this.m_configuredServices = new HashMap();
            cm = null;
        }
        if (cm == null) {
            cm = this.createComponentManager(configuration);
            this.m_configuredServices.put(pid, cm);
        } else if (cm instanceof ImmediateComponentManager) {
            ((ImmediateComponentManager)cm).reconfigure(configuration);
        }
    }

    public void deleted(String pid) {
        ComponentManager cm;
        if (this.m_configuredServices != null && (cm = (ComponentManager)this.m_configuredServices.remove(pid)) != null) {
            this.disposeComponentManager(cm);
        }
    }

    public String getName() {
        return "Component Factory " + this.getComponentMetadata().getName();
    }

    private ComponentManager createComponentManager(Dictionary configuration) {
        long componentId = this.m_componentRegistry.createComponentId();
        ComponentManager cm = ManagerFactory.createManager(this.getActivator(), this.getComponentMetadata(), componentId);
        this.getActivator().getInstanceReferences().add(cm);
        this.m_createdComponents.put(cm, cm);
        if (cm instanceof ImmediateComponentManager) {
            ((ImmediateComponentManager)cm).setFactoryProperties(configuration);
        }
        cm.enable();
        return cm;
    }

    private void disposeComponentManager(ComponentManager cm) {
        this.m_createdComponents.remove(cm);
        this.getActivator().getInstanceReferences().remove(cm);
        cm.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

