/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.Dictionary;
import org.apache.felix.scr.impl.AbstractComponentManager;
import org.apache.felix.scr.impl.DependencyManager;
import org.apache.felix.scr.impl.ReadOnlyDictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

class ComponentContextImpl
implements ComponentContext {
    private AbstractComponentManager m_componentManager;

    ComponentContextImpl(AbstractComponentManager componentManager) {
        this.m_componentManager = componentManager;
    }

    protected AbstractComponentManager getComponentManager() {
        return this.m_componentManager;
    }

    public Dictionary getProperties() {
        return new ReadOnlyDictionary(this.m_componentManager.getProperties());
    }

    public Object locateService(String name) {
        ServiceReference selectedRef;
        DependencyManager dm = this.m_componentManager.getDependencyManager(name);
        if (dm == null) {
            return null;
        }
        if (dm.size() == 1) {
            selectedRef = dm.getServiceReference();
        } else {
            int maxRanking = Integer.MIN_VALUE;
            long minId = Long.MAX_VALUE;
            selectedRef = null;
            ServiceReference[] refs = dm.getFrameworkServiceReferences();
            for (int i = 0; refs != null && i < refs.length; ++i) {
                ServiceReference ref = refs[i];
                Integer rank = (Integer)ref.getProperty("service.ranking");
                int ranking = rank == null ? Integer.MIN_VALUE : rank;
                long id = (Long)ref.getProperty("service.id");
                if (maxRanking >= ranking && (maxRanking != ranking || id >= minId)) continue;
                maxRanking = ranking;
                minId = id;
                selectedRef = ref;
            }
        }
        if (selectedRef == null) {
            return null;
        }
        return dm.getService(selectedRef);
    }

    public Object locateService(String name, ServiceReference ref) {
        DependencyManager dm = this.m_componentManager.getDependencyManager(name);
        return dm != null ? dm.getService(ref) : null;
    }

    public Object[] locateServices(String name) {
        DependencyManager dm = this.m_componentManager.getDependencyManager(name);
        return dm != null ? dm.getServices() : null;
    }

    public BundleContext getBundleContext() {
        return this.m_componentManager.getActivator().getBundleContext();
    }

    public Bundle getUsingBundle() {
        return null;
    }

    public ComponentInstance getComponentInstance() {
        return this.m_componentManager;
    }

    public void enableComponent(String name) {
        this.m_componentManager.getActivator().enableComponent(name);
    }

    public void disableComponent(String name) {
        this.m_componentManager.getActivator().disableComponent(name);
    }

    public ServiceReference getServiceReference() {
        return this.m_componentManager.getServiceReference();
    }
}

