/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.Comparator;
import org.apache.felix.framework.capabilityset.Capability;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateComparator
implements Comparator<Capability> {
    @Override
    public int compare(Capability cap1, Capability cap2) {
        int c = 0;
        if (cap1.getModule().isResolved() && !cap2.getModule().isResolved()) {
            c = -1;
        } else if (!cap1.getModule().isResolved() && cap2.getModule().isResolved()) {
            c = 1;
        }
        if (c == 0 && cap1.getNamespace().equals("module")) {
            c = ((Comparable)cap1.getAttribute("bundle-symbolic-name").getValue()).compareTo(cap2.getAttribute("bundle-symbolic-name").getValue());
            if (c == 0) {
                Version v1 = cap1.getAttribute("bundle-version") == null ? Version.emptyVersion : (Version)cap1.getAttribute("bundle-version").getValue();
                Version v2 = cap2.getAttribute("bundle-version") == null ? Version.emptyVersion : (Version)cap2.getAttribute("bundle-version").getValue();
                c = v2.compareTo(v1);
            }
        } else if (c == 0 && cap1.getNamespace().equals("package") && (c = ((Comparable)cap1.getAttribute("package").getValue()).compareTo(cap2.getAttribute("package").getValue())) == 0) {
            Version v1 = cap1.getAttribute("version") == null ? Version.emptyVersion : (Version)cap1.getAttribute("version").getValue();
            Version v2 = cap2.getAttribute("version") == null ? Version.emptyVersion : (Version)cap2.getAttribute("version").getValue();
            c = v2.compareTo(v1);
        }
        if (c == 0) {
            if (cap1.getModule().getBundle().getBundleId() < cap2.getModule().getBundle().getBundleId()) {
                c = -1;
            } else if (cap1.getModule().getBundle().getBundleId() > cap2.getModule().getBundle().getBundleId()) {
                c = 1;
            }
        }
        return c;
    }

    @Override
    public /* synthetic */ int compare(Object x0, Object x1) {
        return this.compare((Capability)x0, (Capability)x1);
    }
}

