/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.CandidateComparator;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.resolver.WireImpl;
import org.apache.felix.framework.resolver.WireModuleImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverImpl
implements Resolver {
    private final Logger m_logger;
    private static final List<Wire> m_emptyWires = Util.m_emptyList;
    private final List<Map<Requirement, Set<Capability>>> m_usesPermutations = new ArrayList<Map<Requirement, Set<Capability>>>();
    private final List<Map<Requirement, Set<Capability>>> m_importPermutations = new ArrayList<Map<Requirement, Set<Capability>>>();
    private Map<Capability, List<Capability>> m_packageSourcesCache = new HashMap<Capability, List<Capability>>();

    public ResolverImpl(Logger logger) {
        this.m_logger = logger;
        String v = System.getProperty("invoke.count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Module, List<Wire>> resolve(Resolver.ResolverState state, Module module) {
        Map<Module, List<Wire>> wireMap = new HashMap<Module, List<Wire>>();
        HashMap<Module, Packages> modulePkgMap = new HashMap<Module, Packages>();
        if (!module.isResolved()) {
            try {
                Map<Requirement, Set<Capability>> candidateMap = new HashMap<Requirement, Set<Capability>>();
                this.populateCandidates(state, module, candidateMap, new HashMap<Module, Object>());
                this.m_usesPermutations.add(candidateMap);
                ResolveException rethrow = null;
                HashMap<Capability, Set<Requirement>> capDepSet = new HashMap<Capability, Set<Requirement>>();
                do {
                    rethrow = null;
                    modulePkgMap.clear();
                    capDepSet.clear();
                    this.m_packageSourcesCache.clear();
                    candidateMap = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                    this.calculatePackageSpaces(module, candidateMap, modulePkgMap, capDepSet, new HashMap<Capability, List<Module>>(), new HashSet<Module>());
                    try {
                        this.checkPackageSpaceConsistency(module, candidateMap, modulePkgMap, capDepSet, new HashMap<Module, Object>());
                    }
                    catch (ResolveException ex) {
                        rethrow = ex;
                        System.out.println(new StringBuffer().append("RE: ").append(ex).toString());
                    }
                } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                if (rethrow != null) {
                    throw rethrow;
                }
                wireMap = ResolverImpl.populateWireMap(module, modulePkgMap, wireMap, candidateMap);
            }
            finally {
                this.m_usesPermutations.clear();
                this.m_importPermutations.clear();
            }
        }
        return wireMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Module, List<Wire>> resolve(Resolver.ResolverState state, Module module, String pkgName) {
        Map<Requirement, Set<Capability>> candidateMap = ResolverImpl.getDynamicImportCandidates(state, module, pkgName);
        if (candidateMap != null) {
            try {
                Map<Module, List<Wire>> wireMap = new HashMap<Module, List<Wire>>();
                HashMap<Module, Packages> modulePkgMap = new HashMap<Module, Packages>();
                this.populateDynamicCandidates(state, module, candidateMap);
                this.m_usesPermutations.add(candidateMap);
                ResolveException rethrow = null;
                HashMap<Capability, Set<Requirement>> capDepSet = new HashMap<Capability, Set<Requirement>>();
                do {
                    rethrow = null;
                    modulePkgMap.clear();
                    capDepSet.clear();
                    candidateMap = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                    this.calculatePackageSpaces(module, candidateMap, modulePkgMap, capDepSet, new HashMap<Capability, List<Module>>(), new HashSet<Module>());
                    try {
                        this.checkPackageSpaceConsistency(module, candidateMap, modulePkgMap, capDepSet, new HashMap<Module, Object>());
                    }
                    catch (ResolveException ex) {
                        rethrow = ex;
                        System.out.println(new StringBuffer().append("RE: ").append(ex).toString());
                    }
                } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                if (rethrow != null) {
                    throw rethrow;
                }
                Map<Module, List<Wire>> map = wireMap = ResolverImpl.populateDynamicWireMap(module, pkgName, modulePkgMap, wireMap, candidateMap);
                return map;
            }
            finally {
                this.m_usesPermutations.clear();
                this.m_importPermutations.clear();
            }
        }
        return null;
    }

    private static Map<Requirement, Set<Capability>> getDynamicImportCandidates(Resolver.ResolverState state, Module module, String pkgName) {
        if (!module.isResolved() || pkgName.length() == 0) {
            return null;
        }
        List<Requirement> dynamics = module.getDynamicRequirements();
        if (dynamics == null || dynamics.size() == 0) {
            return null;
        }
        List<Capability> caps = module.getCapabilities();
        for (int i = 0; caps != null && i < caps.size(); ++i) {
            if (!caps.get(i).getNamespace().equals("package") || !caps.get(i).getAttribute("package").getValue().equals(pkgName)) continue;
            return null;
        }
        List<Wire> wires = module.getWires();
        for (int i = 0; wires != null && i < wires.size(); ++i) {
            if (!wires.get(i).hasPackage(pkgName)) continue;
            return null;
        }
        List dirs = Collections.EMPTY_LIST;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(new Attribute("package", pkgName, false));
        RequirementImpl req = new RequirementImpl(module, "package", dirs, attrs);
        Set<Capability> candidates = state.getCandidates(module, req, false);
        Requirement dynReq = null;
        for (int dynIdx = 0; candidates.size() > 0 && dynReq == null && dynIdx < dynamics.size(); ++dynIdx) {
            Iterator<Capability> itCand = candidates.iterator();
            while (dynReq == null && itCand.hasNext()) {
                Capability cap = itCand.next();
                if (!CapabilitySet.matches(cap, dynamics.get(dynIdx).getFilter())) continue;
                dynReq = dynamics.get(dynIdx);
            }
        }
        if (dynReq != null) {
            Iterator<Capability> itCand = candidates.iterator();
            while (itCand.hasNext()) {
                Capability cap = itCand.next();
                if (CapabilitySet.matches(cap, dynReq.getFilter())) continue;
                itCand.remove();
            }
        } else {
            candidates.clear();
        }
        if (candidates.size() > 0) {
            HashMap<Requirement, Set<Capability>> candidateMap = new HashMap<Requirement, Set<Capability>>();
            candidateMap.put(dynReq, candidates);
            return candidateMap;
        }
        return null;
    }

    private void populateCandidates(Resolver.ResolverState state, Module module, Map<Requirement, Set<Capability>> candidateMap, Map<Module, Object> resultCache) {
        Integer cycleCount = null;
        Map<Requirement, Set<Capability>> localCandidateMap = null;
        List<Requirement> remainingReqs = null;
        Object[] cacheValue = resultCache.get(module);
        if (cacheValue instanceof ResolveException) {
            throw (ResolveException)cacheValue;
        }
        if (cacheValue instanceof Boolean) {
            return;
        }
        if (cacheValue != null) {
            Integer n = new Integer((Integer)((Object[])cacheValue)[0] + 1);
            ((Object[])cacheValue)[0] = n;
            cycleCount = n;
            localCandidateMap = (Map)((Object[])cacheValue)[1];
            remainingReqs = (List)((Object[])cacheValue)[2];
        }
        if (remainingReqs == null && localCandidateMap == null) {
            state.checkExecutionEnvironment(module);
            state.checkNativeLibraries(module);
            cycleCount = new Integer(0);
            localCandidateMap = new HashMap();
            remainingReqs = new ArrayList<Requirement>(module.getRequirements());
            cacheValue = new Object[]{cycleCount, localCandidateMap, remainingReqs};
            resultCache.put(module, cacheValue);
        }
        while (remainingReqs.size() > 0) {
            Requirement req = (Requirement)remainingReqs.remove(0);
            Set<Capability> candidates = state.getCandidates(module, req, true);
            Iterator<Capability> itCandCap = candidates.iterator();
            while (itCandCap.hasNext()) {
                Capability candCap = itCandCap.next();
                if (candCap.getModule().isResolved()) continue;
                try {
                    this.populateCandidates(state, candCap.getModule(), candidateMap, resultCache);
                }
                catch (ResolveException ex) {
                    itCandCap.remove();
                }
            }
            if (candidates.size() == 0 && !req.isOptional()) {
                ResolveException ex = new ResolveException(new StringBuffer().append("Unable to resolve ").append(module).append(": missing requirement ").append(req).toString(), module, req);
                resultCache.put(module, ex);
                this.m_logger.log(4, "No viable candidates", ex);
                throw ex;
            }
            if (candidates.size() <= 0) continue;
            localCandidateMap.put(req, candidates);
        }
        if (cycleCount > 0) {
            ((Object[])cacheValue)[0] = new Integer(cycleCount - 1);
        } else if (cycleCount == 0) {
            resultCache.put(module, Boolean.TRUE);
            if (localCandidateMap.size() > 0) {
                candidateMap.putAll(localCandidateMap);
            }
        }
    }

    private void populateDynamicCandidates(Resolver.ResolverState state, Module module, Map<Requirement, Set<Capability>> candidateMap) {
        Map.Entry<Requirement, Set<Capability>> entry = candidateMap.entrySet().iterator().next();
        Requirement dynReq = entry.getKey();
        Set<Capability> candidates = entry.getValue();
        Iterator<Capability> itCandCap = candidates.iterator();
        while (itCandCap.hasNext()) {
            Capability candCap = itCandCap.next();
            if (candCap.getModule().isResolved()) continue;
            try {
                this.populateCandidates(state, candCap.getModule(), candidateMap, new HashMap<Module, Object>());
            }
            catch (ResolveException ex) {
                itCandCap.remove();
            }
        }
        if (candidates.size() == 0) {
            candidateMap.remove(dynReq);
            throw new ResolveException("Dynamic import failed.", module, dynReq);
        }
    }

    private void calculatePackageSpaces(Module module, Map<Requirement, Set<Capability>> candidateMap, Map<Module, Packages> modulePkgMap, Map<Capability, Set<Requirement>> capDepSet, Map<Capability, List<Module>> usesCycleMap, Set<Module> cycle) {
        ArrayList<Requirement> blameReqs;
        int i;
        Capability cap;
        Set<Capability> candCaps;
        if (cycle.contains(module)) {
            return;
        }
        cycle.add(module);
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Capability> caps = new ArrayList<Capability>();
        if (module.isResolved()) {
            for (Wire wire : module.getWires()) {
                reqs.add(wire.getRequirement());
                caps.add(wire.getCapability());
            }
            for (Requirement req : module.getDynamicRequirements()) {
                candCaps = candidateMap.get(req);
                if (candCaps == null) continue;
                cap = candCaps.iterator().next();
                reqs.add(req);
                caps.add(cap);
                break;
            }
        } else {
            for (Requirement req : module.getRequirements()) {
                candCaps = candidateMap.get(req);
                if (candCaps == null) continue;
                cap = candCaps.iterator().next();
                reqs.add(req);
                caps.add(cap);
            }
        }
        ResolverImpl.calculateExportedPackages(module, modulePkgMap);
        Packages modulePkgs = modulePkgMap.get(module);
        for (i = 0; i < reqs.size(); ++i) {
            Requirement req = (Requirement)reqs.get(i);
            cap = (Capability)caps.get(i);
            ResolverImpl.calculateExportedPackages(cap.getModule(), modulePkgMap);
            this.mergeCandidatePackages(module, req, cap, modulePkgMap, candidateMap);
            ResolverImpl.addCapabilityDependency(cap, req, capDepSet);
        }
        for (i = 0; i < caps.size(); ++i) {
            this.calculatePackageSpaces(((Capability)caps.get(i)).getModule(), candidateMap, modulePkgMap, capDepSet, usesCycleMap, cycle);
        }
        for (Map.Entry<String, List<Blame>> entry : modulePkgs.m_importedPkgs.entrySet()) {
            for (Blame blame : entry.getValue()) {
                if (blame.m_cap.getModule().equals(module)) continue;
                blameReqs = new ArrayList<Requirement>();
                blameReqs.add(blame.m_reqs.get(0));
                this.mergeUses(module, modulePkgs, blame.m_cap, blameReqs, modulePkgMap, candidateMap, usesCycleMap);
            }
        }
        for (Map.Entry<String, List<Blame>> entry : modulePkgs.m_requiredPkgs.entrySet()) {
            for (Blame blame : entry.getValue()) {
                blameReqs = new ArrayList();
                blameReqs.add(blame.m_reqs.get(0));
                this.mergeUses(module, modulePkgs, blame.m_cap, blameReqs, modulePkgMap, candidateMap, usesCycleMap);
            }
        }
    }

    private void mergeCandidatePackages(Module current, Requirement currentReq, Capability candCap, Map<Module, Packages> modulePkgMap, Map<Requirement, Set<Capability>> candidateMap) {
        if (candCap.getNamespace().equals("package")) {
            this.mergeCandidatePackage(current, false, currentReq, candCap, modulePkgMap);
        } else if (candCap.getNamespace().equals("module")) {
            ResolverImpl.calculateExportedPackages(candCap.getModule(), modulePkgMap);
            Packages candPkgs = modulePkgMap.get(candCap.getModule());
            for (Map.Entry<String, Blame> entry : candPkgs.m_exportedPkgs.entrySet()) {
                this.mergeCandidatePackage(current, true, currentReq, entry.getValue().m_cap, modulePkgMap);
            }
            for (Requirement req : candCap.getModule().getRequirements()) {
                Directive dir;
                if (!req.getNamespace().equals("module") || (dir = req.getDirective("visibility")) == null || !dir.getValue().equals("reexport") || candidateMap.get(req) == null) continue;
                this.mergeCandidatePackages(current, currentReq, candidateMap.get(req).iterator().next(), modulePkgMap, candidateMap);
            }
        }
    }

    private void mergeCandidatePackage(Module current, boolean requires, Requirement currentReq, Capability candCap, Map<Module, Packages> modulePkgMap) {
        if (candCap.getNamespace().equals("package")) {
            String pkgName = (String)candCap.getAttribute("package").getValue();
            ArrayList<Requirement> blameReqs = new ArrayList<Requirement>();
            blameReqs.add(currentReq);
            Packages currentPkgs = modulePkgMap.get(current);
            if (requires) {
                List<Blame> currentRequiredBlames = currentPkgs.m_requiredPkgs.get(pkgName);
                if (currentRequiredBlames == null) {
                    currentRequiredBlames = new ArrayList<Blame>();
                    currentPkgs.m_requiredPkgs.put(pkgName, currentRequiredBlames);
                }
                currentRequiredBlames.add(new Blame(candCap, blameReqs));
            } else {
                List<Blame> currentImportedBlames = currentPkgs.m_importedPkgs.get(pkgName);
                if (currentImportedBlames == null) {
                    currentImportedBlames = new ArrayList<Blame>();
                    currentPkgs.m_importedPkgs.put(pkgName, currentImportedBlames);
                }
                currentImportedBlames.add(new Blame(candCap, blameReqs));
            }
        }
    }

    private static void addCapabilityDependency(Capability cap, Requirement req, Map<Capability, Set<Requirement>> capDepSet) {
        Set<Requirement> reqs = capDepSet.get(cap);
        if (reqs == null) {
            reqs = new HashSet<Requirement>();
            capDepSet.put(cap, reqs);
        }
        reqs.add(req);
    }

    private void mergeUses(Module current, Packages currentPkgs, Capability mergeCap, List<Requirement> blameReqs, Map<Module, Packages> modulePkgMap, Map<Requirement, Set<Capability>> candidateMap, Map<Capability, List<Module>> cycleMap) {
        if (!mergeCap.getNamespace().equals("package")) {
            return;
        }
        if (current == mergeCap.getModule()) {
            return;
        }
        ArrayList<Module> list = cycleMap.get(mergeCap);
        if (list != null && list.contains(current)) {
            return;
        }
        list = list == null ? new ArrayList<Module>() : list;
        list.add(current);
        cycleMap.put(mergeCap, list);
        for (Capability candSourceCap : this.getPackageSources(mergeCap, modulePkgMap)) {
            for (String usedPkgName : candSourceCap.getUses()) {
                Packages candSourcePkgs = modulePkgMap.get(candSourceCap.getModule());
                Blame candExportedBlame = candSourcePkgs.m_exportedPkgs.get(usedPkgName);
                List<Object> candSourceBlames = null;
                if (candExportedBlame != null) {
                    candSourceBlames = new ArrayList<Blame>(1);
                    candSourceBlames.add(candExportedBlame);
                } else {
                    candSourceBlames = candSourcePkgs.m_importedPkgs.get(usedPkgName);
                }
                if (candSourceBlames == null) continue;
                List<Blame> usedCaps = currentPkgs.m_usedPkgs.get(usedPkgName);
                if (usedCaps == null) {
                    usedCaps = new ArrayList<Blame>();
                    currentPkgs.m_usedPkgs.put(usedPkgName, usedCaps);
                }
                for (Blame blame : candSourceBlames) {
                    if (blame.m_reqs != null) {
                        ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>(blameReqs);
                        blameReqs2.add(blame.m_reqs.get(blame.m_reqs.size() - 1));
                        usedCaps.add(new Blame(blame.m_cap, blameReqs2));
                        this.mergeUses(current, currentPkgs, blame.m_cap, blameReqs2, modulePkgMap, candidateMap, cycleMap);
                        continue;
                    }
                    usedCaps.add(new Blame(blame.m_cap, blameReqs));
                    this.mergeUses(current, currentPkgs, blame.m_cap, blameReqs, modulePkgMap, candidateMap, cycleMap);
                }
            }
        }
    }

    private void checkPackageSpaceConsistency(Module module, Map<Requirement, Set<Capability>> candidateMap, Map<Module, Packages> modulePkgMap, Map<Capability, Set<Requirement>> capDepSet, Map<Module, Object> resultCache) {
        if (module.isResolved()) {
            return;
        }
        if (resultCache.containsKey(module)) {
            return;
        }
        Packages pkgs = modulePkgMap.get(module);
        ResolveException rethrow = null;
        Map<Requirement, Set<Capability>> copyConflict = null;
        Set mutated = null;
        HashSet<Module> checkModules = new HashSet<Module>();
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Blame sourceBlame = null;
            for (Blame blame : entry.getValue()) {
                Iterator<Capability> it;
                Map<Requirement, Set<Capability>> importPerm;
                if (sourceBlame == null) {
                    sourceBlame = blame;
                    continue;
                }
                if (sourceBlame.m_cap.equals(blame.m_cap)) continue;
                Requirement req = blame.m_reqs.get(0);
                Set<Capability> candidates = candidateMap.get(req);
                if (candidates.size() > 1) {
                    importPerm = ResolverImpl.copyCandidateMap(candidateMap);
                    candidates = importPerm.get(req);
                    it = candidates.iterator();
                    it.next();
                    it.remove();
                    this.m_importPermutations.add(importPerm);
                }
                if ((candidates = candidateMap.get(req = sourceBlame.m_reqs.get(0))).size() > 1) {
                    importPerm = ResolverImpl.copyCandidateMap(candidateMap);
                    candidates = importPerm.get(req);
                    it = candidates.iterator();
                    it.next();
                    it.remove();
                    this.m_importPermutations.add(importPerm);
                }
                ResolveException ex = new ResolveException(new StringBuffer().append("Constraint violation for package '").append(entry.getKey()).append("' when resolving module ").append(module).append(" between an import ").append(sourceBlame).append(" and a fragment import ").append(blame).toString(), module, blame.m_reqs.get(0));
                this.m_logger.log(4, "Conflicting fragment import", ex);
                throw ex;
            }
        }
        for (Map.Entry<String, Object> entry : pkgs.m_exportedPkgs.entrySet()) {
            String pkgName = entry.getKey();
            Blame exportBlame = (Blame)entry.getValue();
            if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
            block3: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                Requirement req;
                if (this.isCompatible(exportBlame.m_cap, usedBlame.m_cap, modulePkgMap)) continue;
                copyConflict = copyConflict != null ? copyConflict : ResolverImpl.copyCandidateMap(candidateMap);
                rethrow = rethrow != null ? rethrow : new ResolveException(new StringBuffer().append("Constraint violation for package '").append(pkgName).append("' when resolving module ").append(module).append(" between existing export ").append(exportBlame).append(" and uses constraint ").append(usedBlame).toString(), null, null);
                mutated = mutated != null ? mutated : new HashSet();
                for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                    Set<Capability> candidates = copyConflict.get(req);
                    if (candidates == null || candidates.size() <= 1) continue;
                    mutated.add(req);
                    Iterator<Capability> it = candidates.iterator();
                    it.next();
                    it.remove();
                    continue block3;
                }
            }
            if (rethrow == null) continue;
            if (mutated.size() > 0) {
                this.m_usesPermutations.add(copyConflict);
            }
            this.m_logger.log(4, "Conflict between an export and import", rethrow);
            throw rethrow;
        }
        for (Map.Entry<String, Object> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : (List)entry.getValue()) {
                Set<Capability> candidates;
                String pkgName;
                if (!module.equals(importBlame.m_cap.getModule())) {
                    checkModules.add(importBlame.m_cap.getModule());
                }
                if (!pkgs.m_usedPkgs.containsKey(pkgName = entry.getKey())) continue;
                block7: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                    Requirement req;
                    if (this.isCompatible(importBlame.m_cap, usedBlame.m_cap, modulePkgMap)) continue;
                    copyConflict = copyConflict != null ? copyConflict : ResolverImpl.copyCandidateMap(candidateMap);
                    rethrow = rethrow != null ? rethrow : new ResolveException(new StringBuffer().append("Constraint violation for package '").append(pkgName).append("' when resolving module ").append(module).append(" between existing import ").append(importBlame).append(" and uses constraint ").append(usedBlame).toString(), null, null);
                    mutated = mutated != null ? mutated : new HashSet();
                    for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                        Set<Capability> candidates2 = copyConflict.get(req);
                        if (candidates2 == null || candidates2.size() <= 1) continue;
                        mutated.add(req);
                        Iterator<Capability> it = candidates2.iterator();
                        it.next();
                        it.remove();
                        continue block7;
                    }
                }
                if (rethrow == null) continue;
                Requirement req = importBlame.m_reqs.get(0);
                if (!mutated.contains(req) && (candidates = candidateMap.get(req)).size() > 1) {
                    Map<Requirement, Set<Capability>> importPerm = ResolverImpl.copyCandidateMap(candidateMap);
                    candidates = importPerm.get(req);
                    Iterator<Capability> it = candidates.iterator();
                    it.next();
                    it.remove();
                    this.m_importPermutations.add(importPerm);
                }
                if (mutated.size() > 0) {
                    this.m_usesPermutations.add(copyConflict);
                }
                this.m_logger.log(4, "Conflict between imports", rethrow);
                throw rethrow;
            }
        }
        resultCache.put(module, Boolean.TRUE);
        for (Module module2 : checkModules) {
            this.checkPackageSpaceConsistency(module2, candidateMap, modulePkgMap, capDepSet, resultCache);
        }
    }

    private static void calculateExportedPackages(Module module, Map<Module, Packages> modulePkgMap) {
        Packages packages = modulePkgMap.get(module);
        if (packages != null) {
            return;
        }
        packages = new Packages();
        List<Capability> caps = module.getCapabilities();
        if (caps.size() > 0) {
            for (int i = 0; i < caps.size(); ++i) {
                if (!caps.get(i).getNamespace().equals("package") || ResolverImpl.hasOverlappingImport(module, caps.get(i))) continue;
                packages.m_exportedPkgs.put((String)caps.get(i).getAttribute("package").getValue(), new Blame(caps.get(i), null));
            }
        }
        modulePkgMap.put(module, packages);
    }

    private static boolean hasOverlappingImport(Module module, Capability cap) {
        List<Requirement> reqs = module.getRequirements();
        for (int i = 0; i < reqs.size(); ++i) {
            if (!reqs.get(i).getNamespace().equals("package") || !CapabilitySet.matches(cap, reqs.get(i).getFilter())) continue;
            return true;
        }
        return false;
    }

    private boolean isCompatible(Capability currentCap, Capability candCap, Map<Module, Packages> modulePkgMap) {
        if (currentCap != null && candCap != null) {
            List<Capability> candSources;
            if (currentCap.equals(candCap)) {
                return true;
            }
            List<Capability> currentSources = this.getPackageSources(currentCap, modulePkgMap);
            return currentSources.containsAll(candSources = this.getPackageSources(candCap, modulePkgMap)) || candSources.containsAll(currentSources);
        }
        return true;
    }

    private List<Capability> getPackageSources(Capability cap, Map<Module, Packages> modulePkgMap) {
        if (cap.getNamespace().equals("package")) {
            List<Capability> sources = this.m_packageSourcesCache.get(cap);
            if (sources == null) {
                sources = ResolverImpl.getPackageSourcesInternal(cap, modulePkgMap, new ArrayList<Capability>(), new HashSet<Capability>());
                this.m_packageSourcesCache.put(cap, sources);
            }
            return sources;
        }
        return Util.m_emptyList;
    }

    private static List<Capability> getPackageSourcesInternal(Capability cap, Map<Module, Packages> modulePkgMap, List<Capability> sources, Set<Capability> cycleMap) {
        if (cap.getNamespace().equals("package")) {
            if (cycleMap.contains(cap)) {
                return sources;
            }
            cycleMap.add(cap);
            String pkgName = cap.getAttribute("package").getValue().toString();
            List<Capability> caps = cap.getModule().getCapabilities();
            for (int capIdx = 0; capIdx < caps.size(); ++capIdx) {
                if (!caps.get(capIdx).getNamespace().equals("package") || !caps.get(capIdx).getAttribute("package").getValue().equals(pkgName)) continue;
                sources.add(caps.get(capIdx));
            }
            Packages pkgs = modulePkgMap.get(cap.getModule());
            List<Blame> required = pkgs.m_requiredPkgs.get(pkgName);
            if (required != null) {
                for (Blame blame : required) {
                    ResolverImpl.getPackageSourcesInternal(blame.m_cap, modulePkgMap, sources, cycleMap);
                }
            }
        }
        return sources;
    }

    private static Map<Requirement, Set<Capability>> copyCandidateMap(Map<Requirement, Set<Capability>> candidateMap) {
        HashMap<Requirement, Set<Capability>> copy = new HashMap<Requirement, Set<Capability>>();
        for (Map.Entry<Requirement, Set<Capability>> entry : candidateMap.entrySet()) {
            TreeSet<Capability> candidates = new TreeSet<Capability>(new CandidateComparator());
            candidates.addAll((Collection<Capability>)entry.getValue());
            copy.put(entry.getKey(), candidates);
        }
        return copy;
    }

    private static Map<Module, List<Wire>> populateWireMap(Module module, Map<Module, Packages> modulePkgMap, Map<Module, List<Wire>> wireMap, Map<Requirement, Set<Capability>> candidateMap) {
        if (!module.isResolved() && !wireMap.containsKey(module)) {
            wireMap.put(module, m_emptyWires);
            ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
            ArrayList<WireModuleImpl> moduleWires = new ArrayList<WireModuleImpl>();
            for (Requirement req : module.getRequirements()) {
                Set<Capability> cands = candidateMap.get(req);
                if (cands == null || cands.size() <= 0) continue;
                Capability cand = cands.iterator().next();
                if (!cand.getModule().isResolved()) {
                    ResolverImpl.populateWireMap(cand.getModule(), modulePkgMap, wireMap, candidateMap);
                }
                if (req.getNamespace().equals("package") && !module.equals(cand.getModule())) {
                    packageWires.add(new WireImpl(module, req, cand.getModule(), cand));
                    continue;
                }
                if (!req.getNamespace().equals("module")) continue;
                Packages candPkgs = modulePkgMap.get(cand.getModule());
                moduleWires.add(new WireModuleImpl(module, req, cand.getModule(), cand, candPkgs.getExportedAndReexportedPackages()));
            }
            packageWires.addAll(moduleWires);
            wireMap.put(module, packageWires);
        }
        return wireMap;
    }

    private static Map<Module, List<Wire>> populateDynamicWireMap(Module module, String pkgName, Map<Module, Packages> modulePkgMap, Map<Module, List<Wire>> wireMap, Map<Requirement, Set<Capability>> candidateMap) {
        wireMap.put(module, m_emptyWires);
        ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
        Packages pkgs = modulePkgMap.get(module);
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame blame : entry.getValue()) {
                if (module.equals(blame.m_cap.getModule()) || !blame.m_cap.getAttribute("package").getValue().equals(pkgName)) continue;
                if (!blame.m_cap.getModule().isResolved()) {
                    ResolverImpl.populateWireMap(blame.m_cap.getModule(), modulePkgMap, wireMap, candidateMap);
                }
                ArrayList<Attribute> attrs = new ArrayList<Attribute>();
                attrs.add(new Attribute("package", pkgName, false));
                packageWires.add(new WireImpl(module, new RequirementImpl(module, "package", new ArrayList<Directive>(0), attrs), blame.m_cap.getModule(), blame.m_cap));
            }
        }
        wireMap.put(module, packageWires);
        return wireMap;
    }

    private static void dumpCandidateMap(Map<Requirement, Set<Capability>> candidateMap) {
        HashSet<Module> modules = new HashSet<Module>();
        for (Map.Entry<Requirement, Set<Capability>> entry : candidateMap.entrySet()) {
            modules.add(entry.getKey().getModule());
        }
        System.out.println("=== BEGIN CANDIDATE MAP ===");
        for (Module module : modules) {
            Set<Capability> candidates;
            System.out.println(new StringBuffer().append("  ").append(module).append(" (").append(module.isResolved() ? "RESOLVED)" : "UNRESOLVED)").toString());
            for (Requirement req : module.getRequirements()) {
                candidates = candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println(new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
            for (Requirement req : module.getDynamicRequirements()) {
                candidates = candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println(new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
        }
        System.out.println("=== END CANDIDATE MAP ===");
    }

    private static void dumpModulePkgMap(Map<Module, Packages> modulePkgMap) {
        System.out.println("+++MODULE PKG MAP+++");
        for (Map.Entry<Module, Packages> entry : modulePkgMap.entrySet()) {
            ResolverImpl.dumpModulePkgs(entry.getKey(), entry.getValue());
        }
    }

    private static void dumpModulePkgs(Module module, Packages packages) {
        System.out.println(new StringBuffer().append(module).append(" (").append(module.isResolved() ? "RESOLVED)" : "UNRESOLVED)").toString());
        System.out.println("  EXPORTED");
        for (Map.Entry<String, Blame> entry : packages.m_exportedPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
        System.out.println("  IMPORTED");
        for (Map.Entry<String, Object> entry : packages.m_importedPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
        System.out.println("  REQUIRED");
        for (Map.Entry<String, Object> entry : packages.m_requiredPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
        System.out.println("  USED");
        for (Map.Entry<String, Object> entry : packages.m_usedPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Blame {
        public final Capability m_cap;
        public final List<Requirement> m_reqs;

        public Blame(Capability cap, List<Requirement> reqs) {
            this.m_cap = cap;
            this.m_reqs = reqs;
        }

        public String toString() {
            return new StringBuffer().append(this.m_cap.getModule()).append(".").append(this.m_cap.getAttribute("package").getValue()).append(this.m_reqs == null || this.m_reqs.size() == 0 ? " NO BLAME" : new StringBuffer().append(" BLAMED ON ").append(this.m_reqs).toString()).toString();
        }

        public boolean equals(Object o) {
            return o instanceof Blame && ((Object)this.m_reqs).equals(((Blame)o).m_reqs) && this.m_cap.equals(((Blame)o).m_cap);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Packages {
        public final Map<String, Blame> m_exportedPkgs = new HashMap<String, Blame>();
        public final Map<String, List<Blame>> m_importedPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_requiredPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_usedPkgs = new HashMap<String, List<Blame>>();

        public Packages() {
        }

        public Packages(Packages packages) {
            this.m_exportedPkgs.putAll(packages.m_exportedPkgs);
            this.m_importedPkgs.putAll(packages.m_importedPkgs);
            this.m_requiredPkgs.putAll(packages.m_requiredPkgs);
            this.m_usedPkgs.putAll(packages.m_usedPkgs);
        }

        public List<String> getExportedAndReexportedPackages() {
            ArrayList<String> pkgs = new ArrayList<String>();
            for (Map.Entry<String, Blame> entry : this.m_exportedPkgs.entrySet()) {
                pkgs.add((String)entry.getValue().m_cap.getAttribute("package").getValue());
            }
            block1: for (Map.Entry<String, Object> entry : this.m_requiredPkgs.entrySet()) {
                for (Blame blame : (List)entry.getValue()) {
                    Directive dir = blame.m_reqs.get(blame.m_reqs.size() - 1).getDirective("visibility");
                    if (dir == null || !dir.getValue().equals("reexport")) continue;
                    pkgs.add((String)blame.m_cap.getAttribute("package").getValue());
                    continue block1;
                }
            }
            return pkgs;
        }
    }
}

