/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import org.apache.felix.framework.FilterImpl;
import org.apache.felix.framework.util.MapToDictionary;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IRequirement;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class Requirement
implements IRequirement {
    private final String m_namespace;
    private R4Directive[] m_directives;
    private R4Attribute[] m_attributes;
    private boolean m_isOptional = false;
    private String m_pkgName;
    private VersionRange m_pkgVersionRange;
    private Filter m_filter;

    public Requirement(String namespace, String filterStr) throws InvalidSyntaxException {
        this.m_namespace = namespace;
        this.m_filter = new FilterImpl(filterStr);
    }

    public Requirement(String namespace, R4Directive[] directives, R4Attribute[] attributes) {
        int i;
        this.m_namespace = namespace;
        this.m_directives = directives;
        this.m_attributes = attributes;
        for (i = 0; this.m_directives != null && i < this.m_directives.length; ++i) {
            if (!this.m_directives[i].getName().equals("resolution")) continue;
            this.m_isOptional = this.m_directives[i].getValue().equals("optional");
        }
        for (i = 0; i < this.m_attributes.length; ++i) {
            if (this.m_attributes[i].getName().equals("package")) {
                this.m_pkgName = (String)this.m_attributes[i].getValue();
                continue;
            }
            if (!this.m_namespace.equals("package") || !this.m_attributes[i].getName().equals("version")) continue;
            this.m_pkgVersionRange = (VersionRange)this.m_attributes[i].getValue();
        }
        if (this.m_pkgVersionRange == null) {
            this.m_pkgVersionRange = VersionRange.infiniteRange;
        }
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public Filter getFilter() {
        if (this.m_filter == null) {
            this.m_filter = this.convertToFilter();
        }
        return this.m_filter;
    }

    public String getPackageName() {
        return this.m_pkgName;
    }

    public VersionRange getPackageVersionRange() {
        return this.m_pkgVersionRange;
    }

    public R4Directive[] getDirectives() {
        return this.m_directives;
    }

    public R4Attribute[] getAttributes() {
        return this.m_attributes;
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public String getComment() {
        return "Comment for " + this.toString();
    }

    public boolean isSatisfied(ICapability capability) {
        if (this.m_attributes == null && this.m_filter != null) {
            return this.m_namespace.equals(capability.getNamespace()) && this.getFilter().match(new MapToDictionary(capability.getProperties()));
        }
        if (this.m_attributes != null) {
            return capability.getNamespace().equals(this.getNamespace()) && this.doAttributesMatch((Capability)capability);
        }
        return false;
    }

    private boolean doAttributesMatch(Capability ec) {
        boolean found;
        R4Attribute[] capAttrs = ec.getAttributes();
        for (int reqAttrIdx = 0; reqAttrIdx < this.m_attributes.length; ++reqAttrIdx) {
            R4Attribute reqAttr = this.m_attributes[reqAttrIdx];
            found = false;
            for (int capAttrIdx = 0; !found && capAttrIdx < capAttrs.length; ++capAttrIdx) {
                R4Attribute capAttr = capAttrs[capAttrIdx];
                if (!reqAttr.getName().equals(capAttr.getName())) continue;
                if (capAttr.getValue() instanceof Version) {
                    if (!((VersionRange)reqAttr.getValue()).isInRange((Version)capAttr.getValue())) {
                        return false;
                    }
                } else if (capAttr.getValue() instanceof Object[]) {
                    Object[] values = (Object[])capAttr.getValue();
                    boolean matched = false;
                    for (int valIdx = 0; !matched && valIdx < values.length; ++valIdx) {
                        if (!reqAttr.getValue().equals(values[valIdx])) continue;
                        matched = true;
                    }
                    if (!matched) {
                        return false;
                    }
                } else if (!reqAttr.getValue().equals(capAttr.getValue())) {
                    return false;
                }
                found = true;
            }
            if (found) continue;
            return false;
        }
        for (int capAttrIdx = 0; capAttrIdx < capAttrs.length; ++capAttrIdx) {
            R4Attribute capAttr = capAttrs[capAttrIdx];
            if (!capAttr.isMandatory()) continue;
            found = false;
            for (int reqAttrIdx = 0; !found && reqAttrIdx < this.m_attributes.length; ++reqAttrIdx) {
                R4Attribute reqAttr = this.m_attributes[reqAttrIdx];
                if (!capAttr.getName().equals(reqAttr.getName())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private Filter convertToFilter() {
        StringBuffer sb = new StringBuffer();
        if (this.m_attributes != null && this.m_attributes.length > 1) {
            sb.append("(&");
        }
        for (int i = 0; this.m_attributes != null && i < this.m_attributes.length; ++i) {
            if (this.m_namespace.equals("package") && this.m_attributes[i].getName().equals("package") && this.m_attributes[i].getValue().toString().endsWith(".*")) {
                int idx = this.m_attributes[i].getValue().toString().indexOf(".*");
                sb.append("(|(package=");
                sb.append(this.m_attributes[i].getValue().toString().substring(0, idx));
                sb.append(")(package=");
                sb.append(this.m_attributes[i].getValue().toString());
                sb.append("))");
                continue;
            }
            if (this.m_attributes[i].getValue() instanceof VersionRange) {
                VersionRange vr = (VersionRange)this.m_attributes[i].getValue();
                if (vr.isLowInclusive()) {
                    sb.append("(");
                    sb.append(this.m_attributes[i].getName());
                    sb.append(">=");
                    sb.append(vr.getLow().toString());
                    sb.append(")");
                } else {
                    sb.append("(!(");
                    sb.append(this.m_attributes[i].getName());
                    sb.append("<=");
                    sb.append(vr.getLow().toString());
                    sb.append("))");
                }
                if (vr.getHigh() == null) continue;
                if (vr.isHighInclusive()) {
                    sb.append("(");
                    sb.append(this.m_attributes[i].getName());
                    sb.append("<=");
                    sb.append(vr.getHigh().toString());
                    sb.append(")");
                    continue;
                }
                sb.append("(!(");
                sb.append(this.m_attributes[i].getName());
                sb.append(">=");
                sb.append(vr.getHigh().toString());
                sb.append("))");
                continue;
            }
            sb.append("(");
            sb.append(this.m_attributes[i].getName());
            sb.append("=");
            sb.append(this.m_attributes[i].getValue().toString());
            sb.append(")");
        }
        if (this.m_attributes != null && this.m_attributes.length > 1) {
            sb.append(")");
        }
        try {
            return new FilterImpl(sb.toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public String toString() {
        return this.getNamespace() + "; " + ((Object)this.getFilter()).toString();
    }
}

