/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.ModuleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.RequiredBundle;

class RequiredBundleImpl
implements RequiredBundle {
    private final Felix m_felix;
    private final FelixBundle m_bundle;

    public RequiredBundleImpl(Felix felix, FelixBundle bundle) {
        this.m_felix = felix;
        this.m_bundle = bundle;
    }

    public String getSymbolicName() {
        return this.m_bundle.getSymbolicName();
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.m_bundle.getInfo().isStale()) {
            return null;
        }
        ArrayList<IModule> moduleList = new ArrayList<IModule>();
        IModule[] modules = this.m_bundle.getInfo().getModules();
        for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
            IModule[] dependents = ((ModuleImpl)modules[modIdx]).getDependentRequirers();
            for (int depIdx = 0; dependents != null && depIdx < dependents.length; ++depIdx) {
                moduleList.add(dependents[modIdx]);
            }
        }
        HashSet<Bundle> bundleSet = new HashSet<Bundle>();
        for (int modIdx = 0; modIdx < moduleList.size(); ++modIdx) {
            long id = Util.getBundleIdFromModuleId(((IModule)moduleList.get(modIdx)).getId());
            Bundle bundle = this.m_felix.getBundle(id);
            if (bundle == null) continue;
            bundleSet.add(bundle);
        }
        return bundleSet.toArray(new Bundle[bundleSet.size()]);
    }

    public Version getVersion() {
        ICapability[] caps = Util.getCapabilityByNamespace(this.m_bundle.getInfo().getCurrentModule(), "module");
        if (caps != null && caps.length > 0) {
            return (Version)caps[0].getProperties().get("bundle-version");
        }
        return null;
    }

    public boolean isRemovalPending() {
        return this.m_bundle.getInfo().isRemovalPending();
    }
}

