/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Dictionary;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.log.FormatterLoggerImpl;
import org.apache.felix.log.Log;
import org.apache.felix.log.LoggerContextImpl;
import org.apache.felix.log.LoggerImpl;
import org.apache.felix.log.RootLoggerContextImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.log.FormatterLogger;
import org.osgi.service.log.Logger;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class LoggerAdminImpl
implements LoggerAdmin {
    private final Log m_log;
    private final LoggerContext m_rootContext;
    private final ConcurrentMap<String, LoggerContext> m_contexts = new ConcurrentHashMap<String, LoggerContext>();
    private final ConcurrentMap<LoggerKey, Logger> _loggers = new ConcurrentHashMap<LoggerKey, Logger>();

    public LoggerAdminImpl(String defaultLogLevelString, Log log) {
        this.m_rootContext = new RootLoggerContextImpl(defaultLogLevelString, this);
        this.m_log = log;
    }

    @Override
    public LoggerContext getLoggerContext(String name) {
        return this.getOrCreateLoggerContext(name);
    }

    public Set<String> getLoggerContextNames() {
        return this.m_contexts.keySet();
    }

    protected void updateConfiguration(String name, Dictionary<String, Object> properties) {
        LoggerContext loggerContext = this.getOrCreateLoggerContext(name);
        LoggerContextImpl contextImpl = (LoggerContextImpl)loggerContext;
        contextImpl.updateLoggerContext(properties);
    }

    protected LoggerContext getOrCreateLoggerContext(String name) {
        if (name == null) {
            return this.m_rootContext;
        }
        LoggerContext loggerContext = (LoggerContext)this.m_contexts.get(name);
        if (loggerContext == null) {
            loggerContext = new LoggerContextImpl(name, this, this.m_rootContext);
        }
        return loggerContext;
    }

    public void keepLoggerContext(String name, LoggerContextImpl loggerContext) {
        if (loggerContext instanceof RootLoggerContextImpl) {
            return;
        }
        this.m_contexts.put(name, loggerContext);
    }

    public <L extends Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
        Logger previous;
        LoggerKey key = new LoggerKey(bundle, name, loggerType);
        Logger logger = (Logger)this._loggers.get(key);
        if (logger == null && (previous = this._loggers.putIfAbsent(key, logger = loggerType.equals(FormatterLogger.class) ? new FormatterLoggerImpl(name, bundle, this.m_log, this) : new LoggerImpl(name, bundle, this.m_log, this))) != null) {
            logger = previous;
        }
        return (L)logger;
    }

    LoggerContext getLoggerContext(Bundle bundle, String name) {
        String loggerContextName = String.format("%s|%s|%s", bundle.getSymbolicName(), bundle.getVersion(), bundle.getLocation());
        LoggerContext loggerContext = this.getLoggerContext(loggerContextName);
        if (loggerContext.isEmpty()) {
            loggerContextName = String.format("%s|%s", bundle.getSymbolicName(), bundle.getVersion());
            loggerContext = this.getLoggerContext(loggerContextName);
        }
        if (loggerContext.isEmpty()) {
            loggerContext = this.getLoggerContext(bundle.getSymbolicName());
        }
        return loggerContext;
    }

    static class LoggerKey {
        private final Bundle m_bundle;
        private final String m_name;
        private final Class<? extends Logger> m_loggerType;
        private volatile String m_string;

        public LoggerKey(Bundle bundle, String name, Class<? extends Logger> loggerType) {
            this.m_bundle = bundle;
            this.m_name = name;
            this.m_loggerType = loggerType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_bundle == null ? 0 : this.m_bundle.hashCode());
            result = 31 * result + (this.m_loggerType == null ? 0 : this.m_loggerType.hashCode());
            result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoggerKey other = (LoggerKey)obj;
            if (this.m_bundle == null ? other.m_bundle != null : this.m_bundle.getBundleId() != other.m_bundle.getBundleId()) {
                return false;
            }
            if (this.m_loggerType == null ? other.m_loggerType != null : !this.m_loggerType.equals(other.m_loggerType)) {
                return false;
            }
            return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
        }

        public String toString() {
            if (this.m_string == null) {
                this.m_string = this.getClass().getSimpleName() + "[" + this.m_bundle + "#" + this.m_name + "!" + this.m_loggerType.getSimpleName() + "]";
            }
            return this.m_string;
        }
    }
}

