/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.log.Log;
import org.apache.felix.log.LoggerAdminImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.log.LogLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConfigurationListenerImpl {
    private static final String CONFIGURATION_CLASS = "org.osgi.service.cm.Configuration";
    private static final String CONFIGURATION_ADMIN_CLASS = "org.osgi.service.cm.ConfigurationAdmin";
    private static final String CONFIGURATION_EVENT_CLASS = "org.osgi.service.cm.ConfigurationEvent";
    private static final String CONFIGURATION_LISTENER_CLASS = "org.osgi.service.cm.ConfigurationListener";
    private static final String LOGGER_ADMIN_PID = "org.osgi.service.log.admin";
    private static final String LOGGER_ADMIN_PID_PREFIX = "org.osgi.service.log.admin|";
    final ServiceTracker<?, ?> m_cmtracker;
    final BundleContext m_context;
    final Log m_log;
    final LoggerAdminImpl m_loggerAdmin;

    public ConfigurationListenerImpl(BundleContext context, Log log, LoggerAdminImpl loggerAdmin) throws Exception {
        this.m_context = context;
        this.m_log = log;
        this.m_loggerAdmin = loggerAdmin;
        Filter filter = context.createFilter(String.format("(%s=%s)", "objectClass", CONFIGURATION_ADMIN_CLASS));
        this.m_cmtracker = new ServiceTracker(this.m_context, filter, (ServiceTrackerCustomizer)new CLCustomizer());
        this.m_cmtracker.open();
    }

    public void close() {
        this.m_cmtracker.close();
    }

    class CLCustomizer
    implements ServiceTrackerCustomizer<Object, CLProxy> {
        CLCustomizer() {
        }

        public CLProxy addingService(ServiceReference<Object> reference) {
            CLProxy clProxy = new CLProxy(reference);
            clProxy.updateContext(null, ConfigurationListenerImpl.LOGGER_ADMIN_PID, false);
            for (String name : ConfigurationListenerImpl.this.m_loggerAdmin.getLoggerContextNames()) {
                String pid = ConfigurationListenerImpl.LOGGER_ADMIN_PID_PREFIX + name;
                clProxy.updateContext(name, pid, false);
            }
            return clProxy;
        }

        public void modifiedService(ServiceReference<Object> reference, CLProxy clProxy) {
        }

        public void removedService(ServiceReference<Object> reference, CLProxy clProxy) {
            for (String name : ConfigurationListenerImpl.this.m_loggerAdmin.getLoggerContextNames()) {
                String pid = ConfigurationListenerImpl.LOGGER_ADMIN_PID_PREFIX + name;
                clProxy.updateContext(name, pid, true);
            }
            clProxy.updateContext(null, ConfigurationListenerImpl.LOGGER_ADMIN_PID, true);
            clProxy.unregister();
        }
    }

    class CLProxy {
        private final Object m_ca;
        private final ServiceReference<?> m_caReference;
        private final ServiceRegistration<?> m_registration;
        private final Class<?> m_caClass;
        private final Class<?> m_ceClass;
        private final Class<?> m_clClass;
        private final Class<?> m_configurationClass;
        private final Method m_caGetConfiguration;
        private final Method m_caListConfigurations;
        private final Method m_ceGetPid;
        private final Method m_ceGetType;
        private final Method m_clConfigurationEvent;
        private final Method m_configurationGetProperties;
        private final Method m_configurationGetProcessedProperties;

        public CLProxy(ServiceReference<?> caReference) {
            this.m_caReference = caReference;
            this.m_ca = ConfigurationListenerImpl.this.m_context.getService(this.m_caReference);
            try {
                this.m_caClass = this.m_caReference.getBundle().loadClass(ConfigurationListenerImpl.CONFIGURATION_ADMIN_CLASS);
                this.m_caGetConfiguration = this.m_caClass.getMethod("getConfiguration", String.class, String.class);
                this.m_caListConfigurations = this.m_caClass.getMethod("listConfigurations", String.class);
                this.m_configurationClass = this.m_caReference.getBundle().loadClass(ConfigurationListenerImpl.CONFIGURATION_CLASS);
                this.m_configurationGetProperties = this.m_configurationClass.getMethod("getProperties", new Class[0]);
                Method configurationGetProcessedProperties = null;
                try {
                    configurationGetProcessedProperties = this.m_configurationClass.getMethod("getProcessedProperties", ServiceReference.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                this.m_configurationGetProcessedProperties = configurationGetProcessedProperties;
                this.m_ceClass = this.m_caReference.getBundle().loadClass(ConfigurationListenerImpl.CONFIGURATION_EVENT_CLASS);
                this.m_ceGetPid = this.m_ceClass.getMethod("getPid", new Class[0]);
                this.m_ceGetType = this.m_ceClass.getMethod("getType", new Class[0]);
                this.m_clClass = this.m_caReference.getBundle().loadClass(ConfigurationListenerImpl.CONFIGURATION_LISTENER_CLASS);
                this.m_clConfigurationEvent = this.m_clClass.getMethod("configurationEvent", this.m_ceClass);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException("Failure reflecting over API from Configuration Admin service bundle", e);
            }
            this.m_registration = ConfigurationListenerImpl.this.m_context.registerService(ConfigurationListenerImpl.CONFIGURATION_LISTENER_CLASS, this.configurationListenerProxy(), null);
        }

        private Object configurationListenerProxy() {
            ClassLoader classLoader = ((BundleWiring)this.m_caReference.getBundle().adapt(BundleWiring.class)).getClassLoader();
            return Proxy.newProxyInstance(classLoader, new Class[]{this.m_clClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.equals(CLProxy.this.m_clConfigurationEvent)) {
                        String pid = (String)CLProxy.this.m_ceGetPid.invoke(args[0], new Object[0]);
                        if (!pid.startsWith(ConfigurationListenerImpl.LOGGER_ADMIN_PID)) {
                            return null;
                        }
                        String configName = null;
                        String location = "?";
                        if (pid.startsWith(ConfigurationListenerImpl.LOGGER_ADMIN_PID_PREFIX) && (configName = pid.substring(ConfigurationListenerImpl.LOGGER_ADMIN_PID_PREFIX.length())).contains("|") && configName.split("|").length == 3) {
                            String[] parts = configName.split("|");
                            location = parts[2];
                        }
                        switch ((Integer)CLProxy.this.m_ceGetType.invoke(args[0], new Object[0])) {
                            case 2: {
                                ConfigurationListenerImpl.this.m_loggerAdmin.updateConfiguration(configName, null);
                                break;
                            }
                            default: {
                                Object configObj = CLProxy.this.m_caGetConfiguration.invoke(CLProxy.this.m_ca, pid, location);
                                Dictionary propertiesObj = CLProxy.this.getProperties(configObj);
                                ConfigurationListenerImpl.this.m_loggerAdmin.updateConfiguration(configName, propertiesObj);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        private Dictionary<String, Object> getProperties(Object configObj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.m_configurationGetProcessedProperties != null) {
                return (Dictionary)this.m_configurationGetProcessedProperties.invoke(configObj, this.m_caReference);
            }
            return (Dictionary)this.m_configurationGetProperties.invoke(configObj, new Object[0]);
        }

        private List<Dictionary> listConfigurations(String filter) {
            try {
                Object result = this.m_caListConfigurations.invoke(this.m_ca, filter);
                if (result != null) {
                    ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>();
                    for (Object configObj : (Object[])result) {
                        dictionaries.add(this.getProperties(configObj));
                    }
                    return dictionaries;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                if (e instanceof InvocationTargetException) {
                    ConfigurationListenerImpl.this.m_log.log(this.getClass().getName(), ConfigurationListenerImpl.this.m_context.getBundle(), null, LogLevel.ERROR, "An error occured reflecting on ConfigurationAdmin.", ((InvocationTargetException)e).getTargetException());
                }
                ConfigurationListenerImpl.this.m_log.log(this.getClass().getName(), ConfigurationListenerImpl.this.m_context.getBundle(), null, LogLevel.ERROR, "An error occured reflecting on ConfigurationAdmin.", e);
            }
            return Collections.emptyList();
        }

        private void unregister() {
            this.m_registration.unregister();
        }

        private void updateContext(String name, String pid, boolean delete) {
            List<Dictionary> configurations = this.listConfigurations(String.format("(%s=%s)", "service.pid", pid));
            if (!configurations.isEmpty()) {
                ConfigurationListenerImpl.this.m_loggerAdmin.updateConfiguration(name, delete ? null : configurations.get(0));
            }
        }
    }
}

