/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation.annotations;

import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

class PropertyAnnotationParser
extends EmptyVisitor
implements AnnotationVisitor {
    private Element m_parent;
    private String m_field;
    private String m_name;
    private String m_value;
    private String m_mandatory;
    private String m_type;

    PropertyAnnotationParser(String field, Element parent) {
        this.m_parent = parent;
        this.m_field = field;
    }

    PropertyAnnotationParser(Element parent) {
        this.m_parent = parent;
        this.m_field = null;
    }

    public void visit(String arg0, Object arg1) {
        if (arg0.equals("name")) {
            this.m_name = arg1.toString();
            return;
        }
        if (arg0.equals("value")) {
            this.m_value = arg1.toString();
            return;
        }
        if (arg0.equals("mandatory")) {
            this.m_mandatory = arg1.toString();
            return;
        }
        if (arg0.equals("type")) {
            this.m_type = arg1.toString();
            return;
        }
    }

    public void visitEnd() {
        if (this.m_field != null && this.m_name == null) {
            this.m_name = this.m_field;
        }
        Element[] props = this.m_parent.getElements("Property");
        Element prop = null;
        for (int i = 0; prop == null && props != null && i < props.length; ++i) {
            String name = props[i].getAttribute("name");
            if (name == null || !name.equals(this.m_name)) continue;
            prop = props[i];
        }
        if (prop == null) {
            prop = new Element("property", "");
            this.m_parent.addElement(prop);
            if (this.m_name != null) {
                prop.addAttribute(new Attribute("name", this.m_name));
            }
        }
        if (this.m_field != null) {
            prop.addAttribute(new Attribute("field", this.m_field));
        }
        if (this.m_type != null) {
            prop.addAttribute(new Attribute("type", this.m_type));
        }
        if (this.m_value != null) {
            prop.addAttribute(new Attribute("value", this.m_value));
        }
        if (this.m_mandatory != null) {
            prop.addAttribute(new Attribute("mandatory", this.m_mandatory));
        }
    }
}

