/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ErrorHandler;
import org.apache.felix.ipojo.Extender;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Logger {
    public static final String IPOJO_LOG_LEVEL_PROP = "ipojo.log.level";
    public static final String IPOJO_LOG_LEVEL_HEADER = "Ipojo-log-level";
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private BundleContext m_context;
    private String m_name;
    private ComponentInstance m_instance;
    private int m_level;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;
    static /* synthetic */ Class class$org$apache$felix$ipojo$ErrorHandler;

    public Logger(BundleContext context, String name, int level) {
        this.m_name = name;
        this.m_level = level;
        this.m_context = context;
    }

    public Logger(BundleContext context, ComponentInstance instance, int level) {
        this.m_instance = instance;
        this.m_name = this.m_instance.getInstanceName();
        this.m_level = level;
        this.m_context = context;
    }

    public Logger(BundleContext context, String name) {
        this(context, name, Logger.getDefaultLevel(context));
    }

    public Logger(BundleContext context, ComponentInstance instance) {
        this(context, instance, Logger.getDefaultLevel(context));
    }

    public void log(int level, String msg) {
        if (this.m_level >= level) {
            this.dispatch(level, msg);
        }
        this.invokeErrorHandler(level, msg, null);
    }

    public void log(int level, String msg, Throwable exception) {
        if (this.m_level >= level) {
            this.dispatch(level, msg, exception);
        }
        this.invokeErrorHandler(level, msg, exception);
    }

    private void dispatch(int level, String msg) {
        LogService log = null;
        ServiceReference ref = null;
        try {
            if (SecurityHelper.hasPermissionToGetService((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName(), this.m_context)) {
                ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            } else {
                Extender.getIPOJOBundleContext().getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            }
            if (ref != null) {
                log = (LogService)this.m_context.getService(ref);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String message = null;
        String name = this.m_name;
        if (name == null) {
            name = "";
        }
        switch (level) {
            case 4: {
                message = "[DEBUG] " + name + " : " + msg;
                if (log != null) {
                    log.log(4, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            case 1: {
                message = "[ERROR] " + name + " : " + msg;
                if (log != null) {
                    log.log(1, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            case 3: {
                message = "[INFO] " + name + " : " + msg;
                if (log != null) {
                    log.log(3, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            case 2: {
                message = "[WARNING] " + name + " : " + msg;
                if (log != null) {
                    log.log(2, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            default: {
                message = "[UNKNOWN] " + name + " : " + msg;
                System.err.println(message);
            }
        }
        if (log != null) {
            this.m_context.ungetService(ref);
        }
    }

    private void dispatch(int level, String msg, Throwable exception) {
        LogService log = null;
        ServiceReference ref = null;
        try {
            if (SecurityHelper.hasPermissionToGetService((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName(), this.m_context)) {
                ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            } else {
                Extender.getIPOJOBundleContext().getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            }
            if (ref != null) {
                log = (LogService)this.m_context.getService(ref);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String message = null;
        String name = this.m_name;
        if (name == null) {
            name = "";
        }
        switch (level) {
            case 4: {
                message = "[DEBUG] " + name + " : " + msg;
                if (log != null) {
                    log.log(4, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            case 1: {
                message = "[ERROR] " + name + " : " + msg;
                if (log != null) {
                    log.log(1, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            case 3: {
                message = "[INFO] " + name + " : " + msg;
                if (log != null) {
                    log.log(3, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            case 2: {
                message = "[WARNING] " + name + " : " + msg;
                if (log != null) {
                    log.log(2, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            default: {
                message = "[UNKNOWN] " + name + " : " + msg;
                System.err.println(message);
                exception.printStackTrace();
            }
        }
        if (log != null) {
            this.m_context.ungetService(ref);
        }
    }

    private void invokeErrorHandler(int level, String msg, Throwable error) {
        if (level > 2) {
            return;
        }
        try {
            ServiceReference ref = this.m_context.getServiceReference((class$org$apache$felix$ipojo$ErrorHandler == null ? (class$org$apache$felix$ipojo$ErrorHandler = Logger.class$("org.apache.felix.ipojo.ErrorHandler")) : class$org$apache$felix$ipojo$ErrorHandler).getName());
            if (ref != null) {
                ErrorHandler handler = (ErrorHandler)this.m_context.getService(ref);
                if (level == 1) {
                    handler.onError(this.m_instance, msg, error);
                } else if (level == 2) {
                    handler.onWarning(this.m_instance, msg, error);
                }
                this.m_context.ungetService(ref);
                return;
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    private static int getDefaultLevel(BundleContext context) {
        String level = context.getProperty(IPOJO_LOG_LEVEL_PROP);
        if (level == null) {
            String key = IPOJO_LOG_LEVEL_PROP.replace('.', '-');
            level = (String)context.getBundle().getHeaders().get(key);
        }
        if (level == null) {
            level = (String)context.getBundle().getHeaders().get(IPOJO_LOG_LEVEL_HEADER);
        }
        if (level != null) {
            if (level.equalsIgnoreCase("info")) {
                return 3;
            }
            if (level.equalsIgnoreCase("debug")) {
                return 4;
            }
            if (level.equalsIgnoreCase("warning")) {
                return 2;
            }
            if (level.equalsIgnoreCase("error")) {
                return 1;
            }
        }
        return 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

