/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.util.Iterator;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedService;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandler;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class ProvidedServiceHandlerDescription
extends HandlerDescription {
    private ProvidedServiceDescription[] m_providedServices = new ProvidedServiceDescription[0];

    public ProvidedServiceHandlerDescription(ProvidedServiceHandler handler, ProvidedService[] pss) {
        super(handler);
        this.m_providedServices = new ProvidedServiceDescription[pss.length];
        for (int i = 0; i < pss.length; ++i) {
            this.m_providedServices[i] = new ProvidedServiceDescription(pss[i]);
        }
    }

    public ProvidedServiceDescription[] getProvidedServices() {
        return this.m_providedServices;
    }

    public Element getHandlerInfo() {
        Element services = super.getHandlerInfo();
        for (int i = 0; i < this.m_providedServices.length; ++i) {
            Element service = new Element("provides", null);
            StringBuffer spec = new StringBuffer("[");
            for (int j = 0; j < this.m_providedServices[i].getServiceSpecifications().length; ++j) {
                if (j == 0) {
                    spec.append(this.m_providedServices[i].getServiceSpecifications()[j]);
                    continue;
                }
                spec.append(',');
                spec.append(this.m_providedServices[i].getServiceSpecifications()[j]);
            }
            spec.append(']');
            service.addAttribute(new Attribute("specifications", spec.toString()));
            if (this.m_providedServices[i].getState() == 1) {
                service.addAttribute(new Attribute("state", "registered"));
                service.addAttribute(new Attribute("service.id", this.m_providedServices[i].getServiceReference().getProperty("service.id").toString()));
            } else {
                service.addAttribute(new Attribute("state", "unregistered"));
            }
            Iterator<Object> iterator = this.m_providedServices[i].getProperties().keySet().iterator();
            while (iterator.hasNext()) {
                Element prop = new Element("property", null);
                String name = (String)iterator.next();
                prop.addAttribute(new Attribute("name", name));
                prop.addAttribute(new Attribute("value", this.m_providedServices[i].getProperties().getProperty(name)));
                service.addElement(prop);
            }
            services.addElement(service);
        }
        return services;
    }
}

