/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.declaration;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.ipojo.extender.InstanceDeclaration;
import org.apache.felix.ipojo.extender.internal.declaration.AbstractDeclaration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInstanceDeclaration
extends AbstractDeclaration
implements InstanceDeclaration {
    private static final Dictionary<String, Object> EMPTY_DICTIONARY = new Hashtable<String, Object>();
    private final String m_componentName;
    private final Dictionary<String, Object> m_configuration;
    private final String m_componentVersion;
    private final String m_instanceName;

    public DefaultInstanceDeclaration(BundleContext bundleContext, String componentName) {
        this(bundleContext, componentName, EMPTY_DICTIONARY);
    }

    public DefaultInstanceDeclaration(BundleContext bundleContext, String componentName, Dictionary<String, Object> configuration) {
        super(bundleContext, InstanceDeclaration.class);
        this.m_componentName = componentName;
        this.m_configuration = configuration;
        this.m_componentVersion = this.initComponentVersion();
        this.m_instanceName = this.initInstanceName();
    }

    private String initInstanceName() {
        String name = (String)this.m_configuration.get("instance.name");
        if (name == null) {
            name = "unnamed";
        }
        return name;
    }

    private String initComponentVersion() {
        return (String)this.m_configuration.get("factory.version");
    }

    @Override
    public Dictionary<String, Object> getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public String getComponentName() {
        return this.m_componentName;
    }

    @Override
    public String getComponentVersion() {
        return this.m_componentVersion;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundleContext.getBundle();
    }

    @Override
    protected Dictionary<String, ?> getServiceProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("ipojo.component.name", this.m_componentName);
        String version = this.getComponentVersion();
        if (version != null) {
            properties.put("ipojo.component.version", version);
        }
        properties.put("ipojo.instance.name", this.m_instanceName);
        return properties;
    }
}

