/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator<T> {
    private final BundleContext m_context;
    private final Class<T> m_clazz;
    private ServiceReference m_reference;
    private T m_service;

    public ServiceLocator(Class<T> clazz, BundleContext context) {
        this.m_clazz = clazz;
        this.m_context = context;
    }

    public synchronized T get() {
        if (this.m_service != null) {
            return this.m_service;
        }
        this.m_reference = this.m_context.getServiceReference(this.m_clazz.getName());
        if (this.m_reference == null) {
            return null;
        }
        this.m_service = this.m_context.getService(this.m_reference);
        return this.m_service;
    }

    public synchronized void unget() {
        this.m_service = null;
        if (this.m_reference != null) {
            this.m_context.ungetService(this.m_reference);
            this.m_reference = null;
        }
    }
}

