/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.MethodInterceptor;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.handlers.dependency.DependencyCallback;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.handlers.dependency.NullableObject;
import org.apache.felix.ipojo.handlers.dependency.ServiceUsage;
import org.apache.felix.ipojo.util.DependencyModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

public class Dependency
extends DependencyModel
implements FieldInterceptor,
MethodInterceptor {
    private final DependencyHandler m_handler;
    private final String m_field;
    private DependencyCallback[] m_callbacks;
    private boolean m_isServiceLevelRequirement;
    private boolean m_isFrozen;
    private boolean m_isStarted;
    private final ServiceUsage m_usage;
    private Object m_nullable;
    private final String m_di;
    private final boolean m_supportNullable;
    private String m_id;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Nullable;

    public Dependency(DependencyHandler handler, String field, Class spec, Filter filter, boolean isOptional, boolean isAggregate, boolean nullable, String identity, BundleContext context, int policy, Comparator cmp, String defaultImplem) {
        super(spec, isAggregate, isOptional, filter, cmp, policy, context, handler);
        this.m_handler = handler;
        this.m_field = field;
        this.m_usage = field != null ? new ServiceUsage() : null;
        this.m_supportNullable = nullable;
        this.m_di = defaultImplem;
        if (identity == null) {
            if (spec != null) {
                this.m_id = spec.getName();
            }
        } else {
            this.m_id = identity;
        }
    }

    public void setSpecification(Class spec) {
        super.setSpecification(spec);
        if (this.m_id == null) {
            this.m_id = spec.getName();
        }
    }

    public String getField() {
        return this.m_field;
    }

    protected void addDependencyCallback(DependencyCallback callback) {
        if (this.m_callbacks == null) {
            this.m_callbacks = new DependencyCallback[]{callback};
        } else {
            DependencyCallback[] newCallbacks = new DependencyCallback[this.m_callbacks.length + 1];
            System.arraycopy(this.m_callbacks, 0, newCallbacks, 0, this.m_callbacks.length);
            newCallbacks[this.m_callbacks.length] = callback;
            this.m_callbacks = newCallbacks;
        }
    }

    public synchronized void stop() {
        this.m_isStarted = false;
        super.stop();
    }

    public String getStringFilter() {
        return this.getFilter().toString();
    }

    public DependencyHandler getHandler() {
        return this.m_handler;
    }

    public synchronized boolean isFrozen() {
        return this.m_isFrozen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onObjectCreation(Object pojo) {
        ServiceReference[] refs;
        Dependency dependency = this;
        synchronized (dependency) {
            if (!this.m_isStarted) {
                return;
            }
            if (this.getBindingPolicy() == 1) {
                this.m_isFrozen = true;
            }
            if (this.isOptional() && this.getSize() == 0) {
                return;
            }
            refs = this.getServiceReferences();
        }
        for (int j = 0; this.m_callbacks != null && j < this.m_callbacks.length; ++j) {
            if (this.m_callbacks[j].getMethodType() != 0) continue;
            if (this.isAggregate()) {
                for (int i = 0; i < refs.length; ++i) {
                    this.invokeCallback(this.m_callbacks[j], refs[i], pojo);
                }
                continue;
            }
            this.invokeCallback(this.m_callbacks[j], refs[0], pojo);
        }
    }

    private void callUnbindMethod(ServiceReference ref) {
        if (this.m_handler.getInstanceManager().getState() > 0 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            for (int i = 0; this.m_callbacks != null && i < this.m_callbacks.length; ++i) {
                if (this.m_callbacks[i].getMethodType() != 1) continue;
                this.invokeCallback(this.m_callbacks[i], ref, null);
            }
        }
    }

    private void invokeCallback(DependencyCallback callback, ServiceReference ref, Object pojo) {
        try {
            if (pojo == null) {
                callback.call(ref, this.getService(ref));
            } else {
                callback.callOnInstance(pojo, ref, this.getService(ref));
            }
        }
        catch (NoSuchMethodException e) {
            this.m_handler.error("The method " + callback.getMethodName() + " does not exist in the class " + this.m_handler.getInstanceManager().getClassName());
            this.m_handler.getInstanceManager().stop();
        }
        catch (IllegalAccessException e) {
            this.m_handler.error("The method " + callback.getMethodName() + " is not accessible in the class " + this.m_handler.getInstanceManager().getClassName());
            this.m_handler.getInstanceManager().stop();
        }
        catch (InvocationTargetException e) {
            this.m_handler.error("The method " + callback.getMethodName() + " in the class " + this.m_handler.getInstanceManager().getClassName() + " throws an exception : " + e.getTargetException().getMessage(), e.getTargetException());
            this.m_handler.getInstanceManager().stop();
        }
    }

    private void callBindMethod(ServiceReference ref) {
        if (this.m_handler.getInstanceManager().getState() > 0 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            for (int i = 0; this.m_callbacks != null && i < this.m_callbacks.length; ++i) {
                if (this.m_callbacks[i].getMethodType() != 0) continue;
                this.invokeCallback(this.m_callbacks[i], ref, null);
            }
        }
    }

    public void start() {
        if (this.isOptional() && !this.isAggregate()) {
            if (this.m_di == null) {
                if (this.m_supportNullable) {
                    try {
                        this.m_nullable = Proxy.newProxyInstance(this.getHandler().getInstanceManager().getClazz().getClassLoader(), new Class[]{this.getSpecification(), class$org$apache$felix$ipojo$Nullable == null ? (class$org$apache$felix$ipojo$Nullable = Dependency.class$("org.apache.felix.ipojo.Nullable")) : class$org$apache$felix$ipojo$Nullable}, (InvocationHandler)new NullableObject());
                    }
                    catch (NoClassDefFoundError e) {
                        throw new IllegalStateException("Cannot create the Nullable object, a referenced class cannot be loaded: " + e.getMessage());
                    }
                }
            } else {
                try {
                    Class clazz = this.getHandler().getInstanceManager().getContext().getBundle().loadClass(this.m_di);
                    this.m_nullable = clazz.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
            }
        }
        super.start();
        if (this.getBindingPolicy() == 1 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            this.m_isFrozen = true;
        }
        this.m_isStarted = true;
    }

    protected DependencyCallback[] getCallbacks() {
        return this.m_callbacks;
    }

    public void setServiceLevelDependency() {
        this.m_isServiceLevelRequirement = true;
        this.setBundleContext(new PolicyServiceContext(this.m_handler.getInstanceManager().getGlobalContext(), this.m_handler.getInstanceManager().getLocalServiceContext(), 0));
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isServiceLevelRequirement() {
        return this.m_isServiceLevelRequirement;
    }

    public void onServiceArrival(ServiceReference reference) {
        this.callBindMethod(reference);
    }

    public void onServiceDeparture(ServiceReference ref) {
        this.callUnbindMethod(ref);
    }

    public void onDependencyReconfiguration(ServiceReference[] departs, ServiceReference[] arrivals) {
        throw new UnsupportedOperationException("Dependency set change is not yet supported");
    }

    public List getServiceReferencesAsList() {
        ServiceReference[] refs = super.getServiceReferences();
        if (refs == null) {
            return null;
        }
        return Arrays.asList(refs);
    }

    public Object onGet(Object pojo, String fieldName, Object value) {
        ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
        if (usage.m_stack == 0) {
            ServiceReference[] refs = super.getServiceReferences();
            if (this.isAggregate()) {
                if (refs == null) {
                    usage.m_objects = (Object[])Array.newInstance(this.getSpecification(), 0);
                } else {
                    usage.m_objects = (Object[])Array.newInstance(this.getSpecification(), refs.length);
                    for (int i = 0; refs != null && i < refs.length; ++i) {
                        ServiceReference ref = refs[i];
                        usage.m_objects[i] = this.getService(ref);
                    }
                }
            } else {
                usage.m_objects = (Object[])Array.newInstance(this.getSpecification(), 1);
                if (refs == null) {
                    if (this.m_nullable == null && this.m_supportNullable) {
                        this.m_handler.warn("[" + this.m_handler.getInstanceManager().getInstanceName() + "] The dependency is not optional, however no service object can be injected in " + this.m_field + " -> " + this.getSpecification().getName());
                    }
                    usage.m_objects[0] = this.m_nullable;
                } else {
                    ServiceReference ref = this.getServiceReference();
                    usage.m_objects[0] = this.getService(ref);
                }
            }
            usage.inc();
            this.m_usage.set(usage);
        }
        if (this.isAggregate()) {
            return usage.m_objects;
        }
        return usage.m_objects[0];
    }

    public void onSet(Object pojo, String fieldName, Object value) {
    }

    public void onEntry(Object pojo, Method method, Object[] args) {
        if (this.m_usage != null) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            if (usage.m_stack > 0) {
                usage.inc();
                this.m_usage.set(usage);
            }
        }
    }

    public void onError(Object pojo, Method method, Throwable throwable) {
    }

    public void onExit(Object pojo, Method method, Object returnedObj) {
    }

    public void onFinally(Object pojo, Method method) {
        if (this.m_usage != null) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            if (usage.m_stack > 0 && usage.dec()) {
                usage.clear();
                this.m_usage.set(usage);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

