/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.Dictionary;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class HandlerManagerFactory
extends ComponentFactory
implements HandlerFactory {
    private final String m_type;
    private final String m_namespace;
    private final int m_level;
    static /* synthetic */ Class class$org$apache$felix$ipojo$HandlerFactory;

    public HandlerManagerFactory(BundleContext context, Element metadata) throws ConfigurationException {
        super(context, metadata);
        this.m_factoryName = metadata.getAttribute("name");
        if (this.m_factoryName == null) {
            throw new ConfigurationException("An Handler needs a name");
        }
        String type = metadata.getAttribute("type");
        this.m_type = type != null ? type : "primitive";
        String level = metadata.getAttribute("level");
        this.m_level = level != null ? new Integer(level) : Integer.MAX_VALUE;
        String namespace = metadata.getAttribute("namespace");
        this.m_namespace = namespace != null ? namespace.toLowerCase() : "org.apache.felix.ipojo";
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getHandlerName() {
        return this.m_namespace + ":" + this.getName();
    }

    public String getType() {
        return this.m_type;
    }

    public int getStartLevel() {
        return this.m_level;
    }

    public ComponentTypeDescription getComponentTypeDescription() {
        return new HandlerTypeDescription(this);
    }

    public void stopping() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
    }

    public ComponentInstance createInstance(Dictionary configuration, IPojoContext context, HandlerManager[] handlers) throws ConfigurationException {
        HandlerManager instance = new HandlerManager(this, context, handlers);
        instance.configure(this.m_componentMetadata, configuration);
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HandlerTypeDescription
    extends ComponentTypeDescription {
        public HandlerTypeDescription(Factory factory) {
            super(factory);
        }

        public Dictionary getPropertiesToPublish() {
            Dictionary props = super.getPropertiesToPublish();
            props.put("handler.name", HandlerManagerFactory.this.m_factoryName);
            props.put("handler.namespace", HandlerManagerFactory.this.m_namespace);
            props.put("handler.type", HandlerManagerFactory.this.m_type);
            if (HandlerManagerFactory.this.m_level != Integer.MAX_VALUE) {
                props.put("handler.level", new Integer(HandlerManagerFactory.this.m_level));
            }
            return props;
        }

        public String[] getFactoryInterfacesToPublish() {
            return new String[]{(class$org$apache$felix$ipojo$HandlerFactory == null ? (class$org$apache$felix$ipojo$HandlerFactory = HandlerManagerFactory.class$("org.apache.felix.ipojo.HandlerFactory")) : class$org$apache$felix$ipojo$HandlerFactory).getName()};
        }
    }
}

