/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.composite.CompositeManager;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class CompositeFactory
extends ComponentFactory
implements TrackerCustomizer {
    protected Tracker m_tracker;
    static /* synthetic */ Class class$org$apache$felix$ipojo$HandlerFactory;

    public CompositeFactory(BundleContext context, Element metadata) throws ConfigurationException {
        super(context, metadata);
    }

    public void check(Element metadata) throws ConfigurationException {
        String name = metadata.getAttribute("name");
        if (name == null) {
            throw new ConfigurationException("A composite needs a name : " + metadata);
        }
    }

    public String getClassName() {
        return "composite";
    }

    public List getRequiredHandlerList() {
        IPojoFactory.RequiredHandler req;
        ArrayList<IPojoFactory.RequiredHandler> list = new ArrayList<IPojoFactory.RequiredHandler>();
        Element[] elems = this.m_componentMetadata.getElements();
        for (int i = 0; i < elems.length; ++i) {
            Element current = elems[i];
            IPojoFactory.RequiredHandler req2 = new IPojoFactory.RequiredHandler((IPojoFactory)this, current.getName(), current.getNameSpace());
            if (list.contains(req2)) continue;
            list.add(req2);
        }
        String arch = this.m_componentMetadata.getAttribute("architecture");
        if ((arch == null || arch.equalsIgnoreCase("true")) && !list.contains(req = new IPojoFactory.RequiredHandler((IPojoFactory)this, "architecture", null))) {
            list.add(req);
        }
        return list;
    }

    public synchronized void stopping() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
        }
        this.m_tracker = null;
    }

    public synchronized void starting() {
        if (this.m_requiredHandlers.size() != 0) {
            try {
                String filter = "(&(objectClass=" + (class$org$apache$felix$ipojo$HandlerFactory == null ? (class$org$apache$felix$ipojo$HandlerFactory = CompositeFactory.class$("org.apache.felix.ipojo.HandlerFactory")) : class$org$apache$felix$ipojo$HandlerFactory).getName() + ")" + "(" + "handler.type" + "=" + "composite" + ")" + "(factory.state=1)" + ")";
                this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
                this.m_tracker.open();
            }
            catch (InvalidSyntaxException e) {
                this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
                this.stop();
                return;
            }
        }
    }

    public ComponentInstance createInstance(Dictionary configuration, IPojoContext context, HandlerManager[] handlers) throws ConfigurationException {
        CompositeManager inst = new CompositeManager(this, (BundleContext)context, handlers);
        inst.configure(this.m_componentMetadata, configuration);
        inst.start();
        return inst;
    }

    public synchronized void reconfigure(Dictionary properties) throws UnacceptableConfiguration, MissingHandlerException {
        ComponentInstance instance;
        if (properties == null || properties.get("instance.name") == null && properties.get("name") == null) {
            throw new UnacceptableConfiguration("The configuration does not contains the \"instance.name\" property");
        }
        String name = (String)properties.get("instance.name");
        if (name == null) {
            name = (String)properties.get("name");
        }
        if ((instance = (ComponentInstance)this.m_componentInstances.get(name)) == null) {
            return;
        }
        instance.reconfigure(properties);
    }

    public String getFactoryName() {
        return this.m_componentMetadata.getAttribute("name");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

