/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.instance;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.composite.CompositeHandler;
import org.apache.felix.ipojo.composite.instance.InstanceHandlerDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseException;

public class InstanceHandler
extends CompositeHandler
implements InstanceStateListener,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_scope;
    private ServiceContext m_scope;
    private boolean __Fm_factories;
    private Factory[] m_factories;
    private boolean __Fm_description;
    private InstanceHandlerDescription m_description;
    private boolean __Fm_configurations;
    private ManagedConfiguration[] m_configurations;
    private boolean __McreateInstance$org_apache_felix_ipojo_Factory$org_apache_felix_ipojo_composite_instance_InstanceHandler$ManagedConfiguration;
    private boolean __MbindFactory$org_apache_felix_ipojo_Factory;
    private boolean __MunbindFactory$org_apache_felix_ipojo_Factory;
    private boolean __Mstop;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __Mstart;
    private boolean __McheckValidity;
    private boolean __MstateChanged$org_apache_felix_ipojo_ComponentInstance$int;
    private boolean __MgetObjectFromInstance$java_lang_String;
    private boolean __MgetDescription;
    private boolean __MgetUsedType;

    ServiceContext __getm_scope() {
        if (!this.__Fm_scope) {
            return this.m_scope;
        }
        return (ServiceContext)this.__IM.onGet((Object)this, "m_scope");
    }

    void __setm_scope(ServiceContext serviceContext) {
        if (!this.__Fm_scope) {
            this.m_scope = serviceContext;
            return;
        }
        this.__IM.onSet((Object)this, "m_scope", (Object)serviceContext);
    }

    Factory[] __getm_factories() {
        if (!this.__Fm_factories) {
            return this.m_factories;
        }
        return (Factory[])this.__IM.onGet((Object)this, "m_factories");
    }

    void __setm_factories(Factory[] factoryArray) {
        if (!this.__Fm_factories) {
            this.m_factories = factoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_factories", (Object)factoryArray);
    }

    InstanceHandlerDescription __getm_description() {
        if (!this.__Fm_description) {
            return this.m_description;
        }
        return (InstanceHandlerDescription)((Object)this.__IM.onGet((Object)this, "m_description"));
    }

    void __setm_description(InstanceHandlerDescription instanceHandlerDescription) {
        if (!this.__Fm_description) {
            this.m_description = instanceHandlerDescription;
            return;
        }
        this.__IM.onSet((Object)this, "m_description", (Object)instanceHandlerDescription);
    }

    ManagedConfiguration[] __getm_configurations() {
        if (!this.__Fm_configurations) {
            return this.m_configurations;
        }
        return (ManagedConfiguration[])this.__IM.onGet((Object)this, "m_configurations");
    }

    void __setm_configurations(ManagedConfiguration[] managedConfigurationArray) {
        if (!this.__Fm_configurations) {
            this.m_configurations = managedConfigurationArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_configurations", (Object)managedConfigurationArray);
    }

    public InstanceHandler() {
        this(null);
    }

    private InstanceHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_configurations(new ManagedConfiguration[0]);
    }

    private void createInstance(Factory factory, ManagedConfiguration managedConfiguration) {
        if (!this.__McreateInstance$org_apache_felix_ipojo_Factory$org_apache_felix_ipojo_composite_instance_InstanceHandler$ManagedConfiguration) {
            this.__createInstance(factory, managedConfiguration);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createInstance$org_apache_felix_ipojo_Factory$org_apache_felix_ipojo_composite_instance_InstanceHandler$ManagedConfiguration", new Object[]{factory, managedConfiguration});
            this.__createInstance(factory, managedConfiguration);
            this.__IM.onExit((Object)this, "createInstance$org_apache_felix_ipojo_Factory$org_apache_felix_ipojo_composite_instance_InstanceHandler$ManagedConfiguration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createInstance$org_apache_felix_ipojo_Factory$org_apache_felix_ipojo_composite_instance_InstanceHandler$ManagedConfiguration", throwable);
            throw throwable;
        }
    }

    private void __createInstance(Factory fact, ManagedConfiguration config) {
        Dictionary conf = config.getConfiguration();
        try {
            config.setInstance(fact.createComponentInstance(conf, this.__getm_scope()));
            config.setFactory(fact.getName());
            config.getInstance().addInstanceStateListener((InstanceStateListener)this);
        }
        catch (UnacceptableConfiguration e) {
            this.error("A factory is available for the configuration but the configuration is not acceptable", e);
        }
        catch (MissingHandlerException e) {
            this.error("The instance creation has failed, at least one handler is missing", e);
        }
        catch (ConfigurationException e) {
            this.error("The instance creation has failed, an error during the configuration has occured", e);
        }
    }

    public void bindFactory(Factory factory) {
        if (!this.__MbindFactory$org_apache_felix_ipojo_Factory) {
            this.__bindFactory(factory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", new Object[]{factory});
            this.__bindFactory(factory);
            this.__IM.onExit((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
    }

    private void __bindFactory(Factory factory) {
        boolean implicated = false;
        String factName = factory.getName();
        String className = factory.getComponentDescription().getClassName();
        for (int i = 0; i < this.__getm_configurations().length; ++i) {
            if (this.__getm_configurations()[i].getInstance() != null || !this.__getm_configurations()[i].getNeededFactoryName().equals(factName) && !this.__getm_configurations()[i].getNeededFactoryName().equals(className)) continue;
            this.createInstance(factory, this.__getm_configurations()[i]);
            implicated = true;
        }
        if (implicated && !this.getValidity()) {
            this.checkValidity();
        }
    }

    public void unbindFactory(Factory factory) {
        if (!this.__MunbindFactory$org_apache_felix_ipojo_Factory) {
            this.__unbindFactory(factory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", new Object[]{factory});
            this.__unbindFactory(factory);
            this.__IM.onExit((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
    }

    private void __unbindFactory(Factory factory) {
        boolean implicated = false;
        for (int i = 0; i < this.__getm_configurations().length; ++i) {
            if (this.__getm_configurations()[i].getInstance() == null || !this.__getm_configurations()[i].getFactory().equals(factory.getName())) continue;
            this.__getm_configurations()[i].setInstance(null);
            this.__getm_configurations()[i].setFactory(null);
            implicated = true;
        }
        if (implicated && this.getValidity()) {
            this.checkValidity();
        }
    }

    public synchronized void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        for (int i = 0; i < this.__getm_configurations().length; ++i) {
            if (this.__getm_configurations()[i].getInstance() != null) {
                this.__getm_configurations()[i].getInstance().removeInstanceStateListener((InstanceStateListener)this);
                if (this.__getm_configurations()[i].getInstance().getState() != -1) {
                    this.__getm_configurations()[i].getInstance().dispose();
                }
            }
            this.__getm_configurations()[i].setInstance(null);
            this.__getm_configurations()[i].setFactory(null);
        }
        this.__setm_configurations(new ManagedConfiguration[0]);
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__configure(element, dictionary);
            this.__IM.onExit((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __configure(Element metadata, Dictionary configuration) throws ConfigurationException {
        this.__setm_scope(this.getCompositeManager().getServiceContext());
        Properties toAppend = new Properties();
        Enumeration keys = configuration.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("instance.name") && !key.equals("component")) continue;
            toAppend.put(key, configuration.get(key));
        }
        Element[] instances = metadata.getElements("instance");
        this.__setm_configurations(new ManagedConfiguration[instances.length]);
        for (int i = 0; i < instances.length; ++i) {
            Properties conf = null;
            try {
                conf = InstanceHandler.parseInstance(instances[i]);
            }
            catch (ParseException e) {
                this.error("An instance cannot be parsed correctly", e);
                throw new ConfigurationException("An instance cannot be parsed correctly : " + e.getMessage());
            }
            Properties instanceConfiguration = new Properties();
            instanceConfiguration.putAll((Map<?, ?>)conf);
            instanceConfiguration.putAll((Map<?, ?>)toAppend);
            this.__getm_configurations()[i] = new ManagedConfiguration(instanceConfiguration);
        }
        this.__setm_description(new InstanceHandlerDescription(this, this.__getm_configurations()));
    }

    public static Properties parseInstance(Element instance) throws ParseException {
        String comp;
        Properties dict = new Properties();
        String name = instance.getAttribute("name");
        if (name != null) {
            dict.put("name", name);
        }
        if ((comp = instance.getAttribute("component")) == null) {
            throw new ParseException("An instance does not have the 'component' attribute");
        }
        dict.put("component", comp);
        Element[] props = instance.getElements("property");
        for (int i = 0; props != null && i < props.length; ++i) {
            InstanceHandler.parseProperty(props[i], dict);
        }
        return dict;
    }

    public static void parseProperty(Element prop, Dictionary dict) throws ParseException {
        String name = prop.getAttribute("name");
        String value = prop.getAttribute("value");
        if (name == null) {
            throw new ParseException("A property does not have the 'name' attribute");
        }
        if (value == null) {
            Element[] subProps = prop.getElements("property");
            if (subProps == null) {
                throw new ParseException("A complex property must have at least one 'property' sub-element");
            }
            Properties dict2 = new Properties();
            for (int i = 0; i < subProps.length; ++i) {
                InstanceHandler.parseProperty(subProps[i], dict2);
                dict.put(prop.getAttribute("name"), dict2);
            }
        } else {
            dict.put(name, value);
        }
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        for (int j = 0; j < this.__getm_factories().length; ++j) {
            String factName = this.__getm_factories()[j].getName();
            String className = this.__getm_factories()[j].getClassName();
            for (int i = 0; i < this.__getm_configurations().length; ++i) {
                if (this.__getm_configurations()[i].getInstance() != null || !this.__getm_configurations()[i].getNeededFactoryName().equals(factName) && !this.__getm_configurations()[i].getNeededFactoryName().equals(className)) continue;
                this.createInstance(this.__getm_factories()[j], this.__getm_configurations()[i]);
            }
        }
        this.checkValidity();
    }

    private void checkValidity() {
        if (!this.__McheckValidity) {
            this.__checkValidity();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkValidity", new Object[0]);
            this.__checkValidity();
            this.__IM.onExit((Object)this, "checkValidity", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkValidity", throwable);
            throw throwable;
        }
    }

    private void __checkValidity() {
        for (int i = 0; i < this.__getm_configurations().length; ++i) {
            if (this.__getm_configurations()[i].getInstance() != null && this.__getm_configurations()[i].getInstance().getState() == 2) continue;
            this.setValidity(false);
            return;
        }
        this.setValidity(true);
    }

    public void stateChanged(ComponentInstance componentInstance, int n) {
        if (!this.__MstateChanged$org_apache_felix_ipojo_ComponentInstance$int) {
            this.__stateChanged(componentInstance, n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stateChanged$org_apache_felix_ipojo_ComponentInstance$int", new Object[]{componentInstance, new Integer(n)});
            this.__stateChanged(componentInstance, n);
            this.__IM.onExit((Object)this, "stateChanged$org_apache_felix_ipojo_ComponentInstance$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stateChanged$org_apache_felix_ipojo_ComponentInstance$int", throwable);
            throw throwable;
        }
    }

    private void __stateChanged(ComponentInstance instance, int newState) {
        switch (newState) {
            case -1: 
            case 0: {
                break;
            }
            case 2: {
                if (this.getValidity()) break;
                this.checkValidity();
                break;
            }
            case 1: {
                if (!this.getValidity()) break;
                this.checkValidity();
                break;
            }
        }
    }

    public Object getObjectFromInstance(String string) {
        Object object;
        if (!this.__MgetObjectFromInstance$java_lang_String) {
            return this.__getObjectFromInstance(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getObjectFromInstance$java_lang_String", new Object[]{string});
            object = this.__getObjectFromInstance(string);
            this.__IM.onExit((Object)this, "getObjectFromInstance$java_lang_String", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getObjectFromInstance$java_lang_String", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __getObjectFromInstance(String type) {
        for (int i = 0; i < this.__getm_configurations().length; ++i) {
            if (this.__getm_configurations()[i].getInstance() == null || !type.equals(this.__getm_configurations()[i].getFactory())) continue;
            if (this.__getm_configurations()[i].getInstance().getState() == 2) {
                return ((InstanceManager)this.__getm_configurations()[i].getInstance()).getPojoObject();
            }
            this.error("An object cannot be get from the instance of the type " + type + ": invalid instance" + this.__getm_configurations()[i].getInstance().getInstanceDescription().getDescription());
            return null;
        }
        return null;
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__getDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getDescription", new Object[0]);
            handlerDescription = this.__getDescription();
            this.__IM.onExit((Object)this, "getDescription", (Object)handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __getDescription() {
        return this.__getm_description();
    }

    public List getUsedType() {
        List list;
        if (!this.__MgetUsedType) {
            return this.__getUsedType();
        }
        try {
            this.__IM.onEntry((Object)this, "getUsedType", new Object[0]);
            list = this.__getUsedType();
            this.__IM.onExit((Object)this, "getUsedType", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUsedType", throwable);
            throw throwable;
        }
        return list;
    }

    private List __getUsedType() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.__getm_configurations().length; ++i) {
            result.add(this.__getm_configurations()[i].getConfiguration().get("component"));
        }
        return result;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_configurations")) {
                this.__Fm_configurations = true;
            }
            if (set.contains("m_scope")) {
                this.__Fm_scope = true;
            }
            if (set.contains("m_description")) {
                this.__Fm_description = true;
            }
            if (set.contains("m_factories")) {
                this.__Fm_factories = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("createInstance$org_apache_felix_ipojo_Factory$org_apache_felix_ipojo_composite_instance_InstanceHandler$ManagedConfiguration")) {
                this.__McreateInstance$org_apache_felix_ipojo_Factory$org_apache_felix_ipojo_composite_instance_InstanceHandler$ManagedConfiguration = true;
            }
            if (set.contains("bindFactory$org_apache_felix_ipojo_Factory")) {
                this.__MbindFactory$org_apache_felix_ipojo_Factory = true;
            }
            if (set.contains("unbindFactory$org_apache_felix_ipojo_Factory")) {
                this.__MunbindFactory$org_apache_felix_ipojo_Factory = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("checkValidity")) {
                this.__McheckValidity = true;
            }
            if (set.contains("stateChanged$org_apache_felix_ipojo_ComponentInstance$int")) {
                this.__MstateChanged$org_apache_felix_ipojo_ComponentInstance$int = true;
            }
            if (set.contains("getObjectFromInstance$java_lang_String")) {
                this.__MgetObjectFromInstance$java_lang_String = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("getUsedType")) {
                this.__MgetUsedType = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    class ManagedConfiguration {
        private Dictionary m_configuration;
        private String m_factoryName;
        private ComponentInstance m_instance;
        private String m_desiredFactory;

        ManagedConfiguration(Dictionary conf) {
            this.m_configuration = conf;
            this.m_desiredFactory = (String)conf.get("component");
        }

        protected Dictionary getConfiguration() {
            return this.m_configuration;
        }

        protected String getFactory() {
            return this.m_factoryName;
        }

        protected String getNeededFactoryName() {
            return this.m_desiredFactory;
        }

        protected ComponentInstance getInstance() {
            return this.m_instance;
        }

        protected void setFactory(String name) {
            this.m_factoryName = name;
        }

        protected void setInstance(ComponentInstance instance) {
            this.m_instance = instance;
        }
    }
}

