/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind;

import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.AbstractBindVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.Action;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Names;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.tree.MethodNode;

public class MethodBindVisitor
extends AbstractBindVisitor {
    private MethodNode m_node;
    private Reporter m_reporter;

    public MethodBindVisitor(ComponentWorkbench workbench, Action action, MethodNode method, Reporter reporter) {
        super(workbench, action);
        this.m_node = method;
        this.m_reporter = reporter;
    }

    public void visitEnd() {
        if (this.m_id == null) {
            String identifier = Names.getMethodIdentifier(this.m_node);
            if (identifier != null) {
                this.m_id = identifier;
            } else if (this.m_specification != null) {
                this.m_id = this.m_specification;
            } else {
                this.m_reporter.error("Cannot determine the requires identifier for the (%s) %s method: %s", Names.computeEffectiveMethodName(this.m_node.name), this.action.name(), "Either 'id' attribute is missing or method name do not follow the bind/set/add/modified naming pattern, or no specification (service interface) can be found in method signature or specified in annotation. Dependency will be ignored (would cause an Exception at runtime)");
                return;
            }
        }
        Element requires = this.getRequiresElement();
        Element callback = new Element("callback", "");
        callback.addAttribute(new Attribute("method", Names.computeEffectiveMethodName(this.m_node.name)));
        callback.addAttribute(new Attribute("type", this.action.name().toLowerCase()));
        requires.addElement(callback);
        this.workbench.getIds().put(this.m_id, requires);
        this.workbench.getElements().put(requires, null);
    }
}

