/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.composite.service.provides.CompositionException;
import org.apache.felix.ipojo.composite.service.provides.FieldMetadata;
import org.apache.felix.ipojo.composite.service.provides.MethodMetadata;
import org.apache.felix.ipojo.composite.service.provides.POJOWriter;
import org.apache.felix.ipojo.composite.service.provides.ProvidedServiceHandler;
import org.apache.felix.ipojo.composite.service.provides.SpecificationMetadata;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CompositionMetadata {
    private SpecificationMetadata m_specification;
    private String m_name;
    private BundleContext m_context;
    private Element m_manipulation;
    private ProvidedServiceHandler m_handler;
    private List m_mappings = new ArrayList();
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;

    public CompositionMetadata(BundleContext context, Element description, ProvidedServiceHandler psh, String name) {
        this.m_context = context;
        this.m_handler = psh;
        this.m_name = description.getAttribute("specification") + name;
        String spec = description.getAttribute("specification");
        this.m_specification = new SpecificationMetadata(spec, this.m_context, false, false, this.m_handler);
        Element[] mappings = description.getElements("delegation");
        for (int i = 0; mappings != null && i < mappings.length; ++i) {
            String methodName = mappings[i].getAttribute("method");
            MethodMetadata method = this.m_specification.getMethodByName(methodName);
            if (method == null) {
                this.m_handler.error("The method " + methodName + " does not exist in the specicifation " + spec);
                return;
            }
            if (!mappings[i].getAttribute("policy").equalsIgnoreCase("All")) continue;
            method.setAllPolicy();
        }
    }

    protected BundleContext getBundleContext() {
        return this.m_context;
    }

    public String getName() {
        return this.m_name;
    }

    public SpecificationMetadata getSpecificationMetadata() {
        return this.m_specification;
    }

    private void buildAvailableMappingList() throws CompositionException {
        int i;
        int index = 0;
        for (i = 0; i < this.m_handler.getInstanceType().size(); ++i) {
            String type = (String)this.m_handler.getInstanceType().get(i);
            try {
                ServiceReference[] refs = this.m_context.getServiceReferences((class$org$apache$felix$ipojo$Factory == null ? CompositionMetadata.class$("org.apache.felix.ipojo.Factory") : class$org$apache$felix$ipojo$Factory).getName(), "(factory.name=" + type + ")");
                if (refs == null) {
                    this.m_handler.error("The factory " + type + " is not available, cannot check the composition");
                    throw new CompositionException("The factory " + type + " needs to be available to check the composition");
                }
                String className = (String)refs[0].getProperty("component.class");
                Class impl = this.m_context.getBundle().loadClass(className);
                SpecificationMetadata spec = new SpecificationMetadata(impl, type, this.m_handler);
                FieldMetadata field = new FieldMetadata(spec);
                field.setName("_field" + index);
                Mapping map = new Mapping(spec, field);
                this.m_mappings.add(map);
                ++index;
                continue;
            }
            catch (InvalidSyntaxException e) {
                this.m_handler.error("A LDAP filter is not valid : " + e.getMessage());
                continue;
            }
            catch (ClassNotFoundException e) {
                this.m_handler.error("The implementation class of a component cannot be loaded : " + e.getMessage());
            }
        }
        for (i = 0; i < this.m_handler.getSpecifications().size(); ++i) {
            SpecificationMetadata spec = (SpecificationMetadata)this.m_handler.getSpecifications().get(i);
            FieldMetadata field = new FieldMetadata(spec);
            field.setName("_field" + index);
            if (spec.isOptional()) {
                field.setOptional(true);
            }
            if (spec.isAggregate()) {
                field.setAggregate(true);
            }
            Mapping map = new Mapping(spec, field);
            this.m_mappings.add(map);
            ++index;
        }
    }

    protected void buildMapping() throws CompositionException {
        this.buildAvailableMappingList();
        HashMap<MethodMetadata, Mapping> svcMethods = new HashMap<MethodMetadata, Mapping>();
        HashMap<MethodMetadata, Mapping> instMethods = new HashMap<MethodMetadata, Mapping>();
        for (int i = 0; i < this.m_mappings.size(); ++i) {
            Mapping map = (Mapping)this.m_mappings.get(i);
            SpecificationMetadata spec = map.getSpecification();
            for (int j = 0; j < spec.getMethods().size(); ++j) {
                MethodMetadata method = (MethodMetadata)spec.getMethods().get(j);
                if (spec.isInterface()) {
                    svcMethods.put(method, map);
                    continue;
                }
                instMethods.put(method, map);
            }
        }
        for (int j = 0; j < this.m_specification.getMethods().size(); ++j) {
            FieldMetadata field;
            MethodMetadata met;
            MethodMetadata method = (MethodMetadata)this.m_specification.getMethods().get(j);
            Set keys = instMethods.keySet();
            Iterator iterator = keys.iterator();
            boolean found = false;
            while (iterator.hasNext() & !found) {
                met = (MethodMetadata)iterator.next();
                if (!met.equals(method)) continue;
                found = true;
                field = ((Mapping)instMethods.get(met)).getField();
                field.setUseful(true);
                method.setDelegation(field);
            }
            if (!found) {
                keys = svcMethods.keySet();
                iterator = keys.iterator();
                while (!found && iterator.hasNext()) {
                    met = (MethodMetadata)iterator.next();
                    if (!met.equals(method)) continue;
                    found = true;
                    field = ((Mapping)svcMethods.get(met)).getField();
                    field.setUseful(true);
                    method.setDelegation(field);
                    if (!field.isOptional() || method.throwsUnsupportedOperationException()) continue;
                    this.m_handler.warn("The method " + method.getMethod().getName() + " could not be provided correctly : the specification " + field.getSpecification().getName() + " is optional");
                }
            }
            if (found) continue;
            throw new CompositionException("Inconsistent composition - the method " + method.getMethod() + " could not be delegated");
        }
    }

    protected byte[] buildPOJO() {
        Class clazz = null;
        try {
            clazz = this.getBundleContext().getBundle().loadClass(this.m_specification.getName());
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
        byte[] pojo = POJOWriter.dump(clazz, this.m_name, this.getFieldList(), this.getMethodList());
        Manipulator manipulator = new Manipulator();
        try {
            byte[] newclazz = manipulator.manipulate(pojo);
            this.m_manipulation = manipulator.getManipulationMetadata();
            return newclazz;
        }
        catch (IOException e) {
            this.m_handler.error("An error occurs during the composite implementation creation : " + e.getMessage(), e);
            return null;
        }
    }

    protected Element buildMetadata(String name) {
        Element elem = new Element("component", "");
        Attribute className = new Attribute("classname", this.m_name);
        Attribute factory = new Attribute("factory", "false");
        elem.addAttribute(className);
        elem.addAttribute(factory);
        elem.addAttribute(new Attribute("architecture", "true"));
        Element provides = new Element("provides", "");
        provides.addAttribute(new Attribute("specification", this.m_specification.getName()));
        elem.addElement(provides);
        List fields = this.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            FieldMetadata field = (FieldMetadata)fields.get(i);
            if (!field.isUseful() || !field.getSpecification().isInterface()) continue;
            Element dep = new Element("requires", "");
            dep.addAttribute(new Attribute("field", field.getName()));
            dep.addAttribute(new Attribute("scope", "composite"));
            if (field.getSpecification().isOptional()) {
                dep.addAttribute(new Attribute("optional", "true"));
            }
            dep.addAttribute(new Attribute("filter", "(!(instance.name=" + name + "))"));
            elem.addElement(dep);
        }
        Element properties = new Element("properties", "");
        for (int i = 0; i < fields.size(); ++i) {
            FieldMetadata field = (FieldMetadata)fields.get(i);
            if (!field.isUseful() || field.getSpecification().isInterface()) continue;
            Element prop = new Element("Property", "");
            prop.addAttribute(new Attribute("field", field.getName()));
            properties.addElement(prop);
        }
        if (properties.getElements().length != 0) {
            elem.addElement(properties);
        }
        elem.addElement(this.m_manipulation);
        return elem;
    }

    public List getFieldList() {
        ArrayList<FieldMetadata> list = new ArrayList<FieldMetadata>();
        for (int i = 0; i < this.m_mappings.size(); ++i) {
            Mapping map = (Mapping)this.m_mappings.get(i);
            list.add(map.getField());
        }
        return list;
    }

    private List getMethodList() {
        return this.m_specification.getMethods();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Mapping {
        private SpecificationMetadata m_spec;
        private FieldMetadata m_field;

        public Mapping(SpecificationMetadata spec, FieldMetadata field) {
            this.m_spec = spec;
            this.m_field = field;
        }

        public SpecificationMetadata getSpecification() {
            return this.m_spec;
        }

        public FieldMetadata getField() {
            return this.m_field;
        }
    }
}

