/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.tracker;

import javax.servlet.Servlet;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.apache.felix.http.whiteboard.internal.tracker.AbstractTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class ServletTracker
extends AbstractTracker<Servlet> {
    private final ExtenderManager manager;

    private static Filter createFilter(BundleContext btx) {
        try {
            return btx.createFilter(String.format("(&(objectClass=%s)(%s=*))", Servlet.class.getName(), "alias"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public ServletTracker(BundleContext context, ExtenderManager manager) {
        super(context, ServletTracker.createFilter(context));
        this.manager = manager;
    }

    @Override
    protected void added(Servlet service, ServiceReference ref) {
        SystemLogger.warning("Deprecation warning: Servlet registered through Apache Felix whiteboard service: " + ref + ". Please change your code to the OSGi Http Whiteboard Service.", null);
        this.manager.add(service, ref);
    }

    @Override
    protected void modified(Servlet service, ServiceReference ref) {
        this.removed(service, ref);
        this.added(service, ref);
    }

    @Override
    protected void removed(Servlet service, ServiceReference ref) {
        this.manager.removeServlet(ref);
    }
}

